/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2022-02-20 13:33:04 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `theme_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=440 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=50775 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1297 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

CREATE TABLE `theme_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=85895 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8831 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1338 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_exclusions` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reason` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `count` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `date` (`date`),
  KEY `reason` (`reason`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_historical` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `category` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `uri` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `page_id` (`page_id`),
  UNIQUE KEY `uri` (`uri`),
  KEY `category` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_pages` (
  `page_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `uri` varchar(190) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `count` int(11) NOT NULL,
  `id` int(11) NOT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `date_2` (`date`,`uri`),
  KEY `url` (`uri`),
  KEY `date` (`date`),
  KEY `id` (`id`),
  KEY `uri` (`uri`,`count`,`id`)
) ENGINE=MyISAM AUTO_INCREMENT=818 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_search` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `engine` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `host` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `words` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `last_counter` (`last_counter`),
  KEY `engine` (`engine`),
  KEY `host` (`host`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_useronline` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `ip` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` int(11) DEFAULT NULL,
  `timestamp` int(10) NOT NULL,
  `date` datetime NOT NULL,
  `referred` text CHARACTER SET utf8 NOT NULL,
  `agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(48) NOT NULL,
  `page_id` bigint(48) NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=9196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_visit` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_visit` datetime NOT NULL,
  `last_counter` date NOT NULL,
  `visit` int(10) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `unique_date` (`last_counter`)
) ENGINE=MyISAM AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_visitor` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `last_counter` date NOT NULL,
  `referred` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `agent` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `platform` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `UAString` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint(40) NOT NULL,
  `hits` int(11) DEFAULT NULL,
  `honeypot` int(11) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `date_ip_agent` (`last_counter`,`ip`,`agent`(50),`platform`(50),`version`(50)),
  KEY `agent` (`agent`),
  KEY `platform` (`platform`),
  KEY `version` (`version`),
  KEY `location` (`location`)
) ENGINE=MyISAM AUTO_INCREMENT=6427 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_statistics_visitor_relationships` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `visitor_id` bigint(20) NOT NULL,
  `page_id` bigint(20) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `visitor_id` (`visitor_id`),
  KEY `page_id` (`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=793 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12690 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=672 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=MyISAM AUTO_INCREMENT=292 DEFAULT CHARSET=utf8;

CREATE TABLE `theme_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=MyISAM AUTO_INCREMENT=233 DEFAULT CHARSET=utf8;

CREATE TABLE `theme_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_title` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=859 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `theme_yoast_migrations_version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `theme_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=40659 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: theme_actionscheduler_actions */
INSERT INTO `theme_actionscheduler_actions` VALUES("396", "wc-admin_import_customers", "complete", "2022-02-03 09:39:57", "2022-02-03 13:09:57", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643881197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643881197;}", "2", "1", "2022-02-03 09:42:15", "2022-02-03 13:12:15", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("403", "wc-admin_import_customers", "complete", "2022-02-10 09:42:22", "2022-02-10 13:12:22", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644486142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644486142;}", "2", "1", "2022-02-10 09:42:27", "2022-02-10 13:12:27", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("389", "wc-admin_import_customers", "complete", "2022-01-21 11:45:10", "2022-01-21 15:15:10", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1642765510;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1642765510;}", "2", "1", "2022-01-21 11:45:22", "2022-01-21 15:15:22", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("390", "wc-admin_import_customers", "complete", "2022-01-22 15:29:36", "2022-01-22 18:59:36", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1642865376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1642865376;}", "2", "1", "2022-01-22 15:30:24", "2022-01-22 19:00:24", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("391", "wc-admin_import_customers", "complete", "2022-01-23 18:02:52", "2022-01-23 21:32:52", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1642960972;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1642960972;}", "2", "1", "2022-01-23 18:14:15", "2022-01-23 21:44:15", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("392", "wc-admin_import_customers", "complete", "2022-01-24 14:10:38", "2022-01-24 17:40:38", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643033438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643033438;}", "2", "1", "2022-01-24 14:11:47", "2022-01-24 17:41:47", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("394", "wc-admin_import_customers", "complete", "2022-02-01 09:37:07", "2022-02-01 13:07:07", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643708227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643708227;}", "2", "1", "2022-02-01 09:37:08", "2022-02-01 13:07:08", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("395", "wc-admin_import_customers", "complete", "2022-02-02 12:11:54", "2022-02-02 15:41:54", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643803914;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643803914;}", "2", "1", "2022-02-02 12:14:46", "2022-02-02 15:44:46", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("397", "wc-admin_import_customers", "complete", "2022-02-04 10:15:09", "2022-02-04 13:45:09", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643969709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643969709;}", "2", "1", "2022-02-04 10:15:27", "2022-02-04 13:45:27", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("399", "wc-admin_import_customers", "complete", "2022-02-06 13:00:37", "2022-02-06 16:30:37", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644152437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644152437;}", "2", "1", "2022-02-06 13:02:08", "2022-02-06 16:32:08", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("401", "wc-admin_import_customers", "complete", "2022-02-08 12:24:47", "2022-02-08 15:54:47", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644323087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644323087;}", "2", "1", "2022-02-08 12:25:59", "2022-02-08 15:55:59", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("404", "wc-admin_import_customers", "complete", "2022-02-11 14:45:01", "2022-02-11 18:15:01", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644590701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644590701;}", "2", "1", "2022-02-11 14:45:24", "2022-02-11 18:15:24", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("406", "wc-admin_import_customers", "complete", "2022-02-13 08:40:28", "2022-02-13 12:10:28", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644741628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644741628;}", "2", "1", "2022-02-13 08:40:29", "2022-02-13 12:10:29", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("408", "wc-admin_import_customers", "complete", "2022-02-15 07:21:51", "2022-02-15 10:51:51", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644909711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644909711;}", "2", "1", "2022-02-15 07:23:01", "2022-02-15 10:53:01", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("427", "action_scheduler/migration_hook", "complete", "2022-02-17 08:04:56", "2022-02-17 11:34:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645085096;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645085096;}", "1", "1", "2022-02-17 08:05:29", "2022-02-17 11:35:29", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("430", "action_scheduler/migration_hook", "complete", "2022-02-18 12:12:01", "2022-02-18 15:42:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645186321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645186321;}", "1", "1", "2022-02-18 12:12:25", "2022-02-18 15:42:25", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("393", "wc-admin_import_customers", "complete", "2022-01-31 08:30:59", "2022-01-31 12:00:59", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1643617859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1643617859;}", "2", "1", "2022-01-31 08:31:04", "2022-01-31 12:01:04", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("398", "wc-admin_import_customers", "complete", "2022-02-05 08:33:42", "2022-02-05 12:03:42", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644050022;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644050022;}", "2", "1", "2022-02-05 08:34:55", "2022-02-05 12:04:55", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("400", "wc-admin_import_customers", "complete", "2022-02-07 08:11:55", "2022-02-07 11:41:55", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644221515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644221515;}", "2", "1", "2022-02-07 08:11:55", "2022-02-07 11:41:55", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("402", "wc-admin_import_customers", "complete", "2022-02-09 06:37:52", "2022-02-09 10:07:52", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644388672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644388672;}", "2", "1", "2022-02-09 06:37:53", "2022-02-09 10:07:53", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("405", "wc-admin_import_customers", "complete", "2022-02-12 07:51:04", "2022-02-12 11:21:04", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644652264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644652264;}", "2", "1", "2022-02-12 07:51:23", "2022-02-12 11:21:23", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("407", "wc-admin_import_customers", "complete", "2022-02-14 06:48:09", "2022-02-14 10:18:09", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644821289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644821289;}", "2", "1", "2022-02-14 06:53:37", "2022-02-14 10:23:37", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("409", "wc-admin_import_customers", "complete", "2022-02-16 07:11:43", "2022-02-16 10:41:43", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1644995503;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1644995503;}", "2", "1", "2022-02-16 07:12:54", "2022-02-16 10:42:54", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("410", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:13:25", "2022-02-16 15:43:25", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("411", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:15:23", "2022-02-16 15:45:23", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("412", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:16:24", "2022-02-16 15:46:24", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("413", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:18:23", "2022-02-16 15:48:23", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("414", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:20:24", "2022-02-16 15:50:24", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("415", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:25:12", "2022-02-16 15:55:12", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("416", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:27:28", "2022-02-16 15:57:28", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("417", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:29:29", "2022-02-16 15:59:29", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("418", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:31:27", "2022-02-16 16:01:27", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("419", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:34:28", "2022-02-16 16:04:28", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("420", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:38:36", "2022-02-16 16:08:36", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("421", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:47:34", "2022-02-16 16:17:34", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("422", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:47:34", "2022-02-16 16:17:34", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("423", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:49:32", "2022-02-16 16:19:32", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("424", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:50:25", "2022-02-16 16:20:25", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("425", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2022-02-16 12:52:26", "2022-02-16 16:22:26", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("426", "wc-admin_import_customers", "complete", "2022-02-17 07:01:02", "2022-02-17 10:31:02", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645081262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645081262;}", "2", "1", "2022-02-17 07:01:26", "2022-02-17 10:31:26", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("428", "action_scheduler/migration_hook", "complete", "2022-02-17 08:06:30", "2022-02-17 11:36:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645085190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645085190;}", "1", "1", "2022-02-17 08:06:30", "2022-02-17 11:36:30", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("429", "wc-admin_import_customers", "complete", "2022-02-18 06:05:01", "2022-02-18 09:35:01", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645164301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645164301;}", "2", "1", "2022-02-18 06:06:21", "2022-02-18 09:36:21", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("431", "wc-admin_import_customers", "complete", "2022-02-19 07:18:36", "2022-02-19 10:48:36", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645255116;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645255116;}", "2", "1", "2022-02-19 07:44:17", "2022-02-19 11:14:17", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("432", "wc-admin_import_customers", "complete", "2022-02-20 05:43:48", "2022-02-20 09:13:48", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645335828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645335828;}", "2", "1", "2022-02-20 05:43:49", "2022-02-20 09:13:49", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("433", "woocommerce_run_update_callback", "complete", "2022-02-20 13:09:36", "2022-02-20 16:39:36", "[\"wc_admin_update_300_update_is_read_from_last_read\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645362576;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645362576;}", "3", "1", "2022-02-20 13:09:37", "2022-02-20 16:39:37", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("434", "woocommerce_run_update_callback", "complete", "2022-02-20 13:09:37", "2022-02-20 16:39:37", "[\"wc_admin_update_300_db_version\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645362577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645362577;}", "3", "1", "2022-02-20 13:09:37", "2022-02-20 16:39:37", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("435", "action_scheduler/migration_hook", "complete", "2022-02-20 13:17:47", "2022-02-20 16:47:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645363067;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645363067;}", "1", "1", "2022-02-20 13:18:43", "2022-02-20 16:48:43", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("436", "wc-admin_delete_user_customers", "complete", "2022-02-20 13:17:50", "2022-02-20 16:47:50", "[22]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645363070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645363070;}", "2", "1", "2022-02-20 13:18:43", "2022-02-20 16:48:43", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("437", "wc-admin_delete_user_customers", "complete", "2022-02-20 13:17:50", "2022-02-20 16:47:50", "[21]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645363070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645363070;}", "2", "1", "2022-02-20 13:18:43", "2022-02-20 16:48:43", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("438", "wc-admin_delete_user_customers", "complete", "2022-02-20 13:17:50", "2022-02-20 16:47:50", "[23]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645363070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645363070;}", "2", "1", "2022-02-20 13:18:43", "2022-02-20 16:48:43", "0", NULL);
INSERT INTO `theme_actionscheduler_actions` VALUES("439", "wc-admin_delete_user_customers", "complete", "2022-02-20 13:17:50", "2022-02-20 16:47:50", "[24]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1645363070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1645363070;}", "2", "1", "2022-02-20 13:18:43", "2022-02-20 16:48:43", "0", NULL);

/* INSERT TABLE DATA: theme_actionscheduler_groups */
INSERT INTO `theme_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `theme_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `theme_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");

/* INSERT TABLE DATA: theme_actionscheduler_logs */
INSERT INTO `theme_actionscheduler_logs` VALUES("1167", "396", "action complete via WP Cron", "2022-02-03 09:42:15", "2022-02-03 13:12:15");
INSERT INTO `theme_actionscheduler_logs` VALUES("1166", "396", "action started via WP Cron", "2022-02-03 09:42:15", "2022-02-03 13:12:15");
INSERT INTO `theme_actionscheduler_logs` VALUES("1165", "396", "ایجاد فعالیت", "2022-02-03 09:39:52", "2022-02-03 13:09:52");
INSERT INTO `theme_actionscheduler_logs` VALUES("1188", "403", "action complete via WP Cron", "2022-02-10 09:42:27", "2022-02-10 13:12:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1187", "403", "action started via WP Cron", "2022-02-10 09:42:27", "2022-02-10 13:12:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1186", "403", "ایجاد فعالیت", "2022-02-10 09:42:17", "2022-02-10 13:12:17");
INSERT INTO `theme_actionscheduler_logs` VALUES("1146", "389", "action complete via WP Cron", "2022-01-21 11:45:22", "2022-01-21 15:15:22");
INSERT INTO `theme_actionscheduler_logs` VALUES("1145", "389", "action started via WP Cron", "2022-01-21 11:45:22", "2022-01-21 15:15:22");
INSERT INTO `theme_actionscheduler_logs` VALUES("1144", "389", "ایجاد فعالیت", "2022-01-21 11:45:05", "2022-01-21 15:15:05");
INSERT INTO `theme_actionscheduler_logs` VALUES("1149", "390", "action complete via WP Cron", "2022-01-22 15:30:24", "2022-01-22 19:00:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1148", "390", "action started via WP Cron", "2022-01-22 15:30:24", "2022-01-22 19:00:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1147", "390", "ایجاد فعالیت", "2022-01-22 15:29:31", "2022-01-22 18:59:31");
INSERT INTO `theme_actionscheduler_logs` VALUES("1152", "391", "action complete via WP Cron", "2022-01-23 18:14:15", "2022-01-23 21:44:15");
INSERT INTO `theme_actionscheduler_logs` VALUES("1151", "391", "action started via WP Cron", "2022-01-23 18:14:15", "2022-01-23 21:44:15");
INSERT INTO `theme_actionscheduler_logs` VALUES("1150", "391", "ایجاد فعالیت", "2022-01-23 18:02:47", "2022-01-23 21:32:47");
INSERT INTO `theme_actionscheduler_logs` VALUES("1155", "392", "action complete via WP Cron", "2022-01-24 14:11:47", "2022-01-24 17:41:47");
INSERT INTO `theme_actionscheduler_logs` VALUES("1154", "392", "action started via WP Cron", "2022-01-24 14:11:47", "2022-01-24 17:41:47");
INSERT INTO `theme_actionscheduler_logs` VALUES("1153", "392", "ایجاد فعالیت", "2022-01-24 14:10:33", "2022-01-24 17:40:33");
INSERT INTO `theme_actionscheduler_logs` VALUES("1160", "394", "action started via Async Request", "2022-02-01 09:37:08", "2022-02-01 13:07:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1159", "394", "ایجاد فعالیت", "2022-02-01 09:37:02", "2022-02-01 13:07:02");
INSERT INTO `theme_actionscheduler_logs` VALUES("1164", "395", "action complete via WP Cron", "2022-02-02 12:14:46", "2022-02-02 15:44:46");
INSERT INTO `theme_actionscheduler_logs` VALUES("1163", "395", "action started via WP Cron", "2022-02-02 12:14:46", "2022-02-02 15:44:46");
INSERT INTO `theme_actionscheduler_logs` VALUES("1162", "395", "ایجاد فعالیت", "2022-02-02 12:11:49", "2022-02-02 15:41:49");
INSERT INTO `theme_actionscheduler_logs` VALUES("1170", "397", "action complete via WP Cron", "2022-02-04 10:15:27", "2022-02-04 13:45:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1169", "397", "action started via WP Cron", "2022-02-04 10:15:27", "2022-02-04 13:45:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1168", "397", "ایجاد فعالیت", "2022-02-04 10:15:04", "2022-02-04 13:45:04");
INSERT INTO `theme_actionscheduler_logs` VALUES("1176", "399", "action complete via WP Cron", "2022-02-06 13:02:08", "2022-02-06 16:32:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1175", "399", "action started via WP Cron", "2022-02-06 13:02:08", "2022-02-06 16:32:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1174", "399", "ایجاد فعالیت", "2022-02-06 13:00:32", "2022-02-06 16:30:32");
INSERT INTO `theme_actionscheduler_logs` VALUES("1182", "401", "action complete via WP Cron", "2022-02-08 12:25:59", "2022-02-08 15:55:59");
INSERT INTO `theme_actionscheduler_logs` VALUES("1181", "401", "action started via WP Cron", "2022-02-08 12:25:59", "2022-02-08 15:55:59");
INSERT INTO `theme_actionscheduler_logs` VALUES("1180", "401", "ایجاد فعالیت", "2022-02-08 12:24:42", "2022-02-08 15:54:42");
INSERT INTO `theme_actionscheduler_logs` VALUES("1191", "404", "action complete via WP Cron", "2022-02-11 14:45:24", "2022-02-11 18:15:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1190", "404", "action started via WP Cron", "2022-02-11 14:45:24", "2022-02-11 18:15:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1189", "404", "ایجاد فعالیت", "2022-02-11 14:44:56", "2022-02-11 18:14:56");
INSERT INTO `theme_actionscheduler_logs` VALUES("1196", "406", "action started via Async Request", "2022-02-13 08:40:29", "2022-02-13 12:10:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1195", "406", "ایجاد فعالیت", "2022-02-13 08:40:23", "2022-02-13 12:10:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1203", "408", "action complete via WP Cron", "2022-02-15 07:23:01", "2022-02-15 10:53:01");
INSERT INTO `theme_actionscheduler_logs` VALUES("1202", "408", "action started via WP Cron", "2022-02-15 07:23:01", "2022-02-15 10:53:01");
INSERT INTO `theme_actionscheduler_logs` VALUES("1201", "408", "ایجاد فعالیت", "2022-02-15 07:21:46", "2022-02-15 10:51:46");
INSERT INTO `theme_actionscheduler_logs` VALUES("1260", "427", "action complete via WP Cron", "2022-02-17 08:05:29", "2022-02-17 11:35:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1259", "427", "action started via WP Cron", "2022-02-17 08:05:29", "2022-02-17 11:35:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1258", "427", "ایجاد فعالیت", "2022-02-17 08:03:56", "2022-02-17 11:33:56");
INSERT INTO `theme_actionscheduler_logs` VALUES("1269", "430", "action complete via WP Cron", "2022-02-18 12:12:25", "2022-02-18 15:42:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1268", "430", "action started via WP Cron", "2022-02-18 12:12:25", "2022-02-18 15:42:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1267", "430", "ایجاد فعالیت", "2022-02-18 12:11:01", "2022-02-18 15:41:01");
INSERT INTO `theme_actionscheduler_logs` VALUES("1156", "393", "ایجاد فعالیت", "2022-01-31 08:30:54", "2022-01-31 12:00:54");
INSERT INTO `theme_actionscheduler_logs` VALUES("1157", "393", "action started via Async Request", "2022-01-31 08:31:04", "2022-01-31 12:01:04");
INSERT INTO `theme_actionscheduler_logs` VALUES("1158", "393", "action complete via Async Request", "2022-01-31 08:31:04", "2022-01-31 12:01:04");
INSERT INTO `theme_actionscheduler_logs` VALUES("1161", "394", "action complete via Async Request", "2022-02-01 09:37:08", "2022-02-01 13:07:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1171", "398", "ایجاد فعالیت", "2022-02-05 08:33:37", "2022-02-05 12:03:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1172", "398", "action started via WP Cron", "2022-02-05 08:34:55", "2022-02-05 12:04:55");
INSERT INTO `theme_actionscheduler_logs` VALUES("1173", "398", "action complete via WP Cron", "2022-02-05 08:34:55", "2022-02-05 12:04:55");
INSERT INTO `theme_actionscheduler_logs` VALUES("1177", "400", "ایجاد فعالیت", "2022-02-07 08:11:50", "2022-02-07 11:41:50");
INSERT INTO `theme_actionscheduler_logs` VALUES("1178", "400", "action started via Async Request", "2022-02-07 08:11:55", "2022-02-07 11:41:55");
INSERT INTO `theme_actionscheduler_logs` VALUES("1179", "400", "action complete via Async Request", "2022-02-07 08:11:55", "2022-02-07 11:41:55");
INSERT INTO `theme_actionscheduler_logs` VALUES("1183", "402", "ایجاد فعالیت", "2022-02-09 06:37:47", "2022-02-09 10:07:47");
INSERT INTO `theme_actionscheduler_logs` VALUES("1184", "402", "action started via Async Request", "2022-02-09 06:37:53", "2022-02-09 10:07:53");
INSERT INTO `theme_actionscheduler_logs` VALUES("1185", "402", "action complete via Async Request", "2022-02-09 06:37:53", "2022-02-09 10:07:53");
INSERT INTO `theme_actionscheduler_logs` VALUES("1192", "405", "ایجاد فعالیت", "2022-02-12 07:50:59", "2022-02-12 11:20:59");
INSERT INTO `theme_actionscheduler_logs` VALUES("1193", "405", "action started via WP Cron", "2022-02-12 07:51:23", "2022-02-12 11:21:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1194", "405", "action complete via WP Cron", "2022-02-12 07:51:23", "2022-02-12 11:21:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1197", "406", "action complete via Async Request", "2022-02-13 08:40:29", "2022-02-13 12:10:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1198", "407", "ایجاد فعالیت", "2022-02-14 06:48:04", "2022-02-14 10:18:04");
INSERT INTO `theme_actionscheduler_logs` VALUES("1199", "407", "action started via WP Cron", "2022-02-14 06:53:37", "2022-02-14 10:23:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1200", "407", "action complete via WP Cron", "2022-02-14 06:53:37", "2022-02-14 10:23:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1204", "409", "ایجاد فعالیت", "2022-02-16 07:11:38", "2022-02-16 10:41:38");
INSERT INTO `theme_actionscheduler_logs` VALUES("1205", "409", "action started via WP Cron", "2022-02-16 07:12:54", "2022-02-16 10:42:54");
INSERT INTO `theme_actionscheduler_logs` VALUES("1206", "409", "action complete via WP Cron", "2022-02-16 07:12:54", "2022-02-16 10:42:54");
INSERT INTO `theme_actionscheduler_logs` VALUES("1207", "410", "ایجاد فعالیت", "2022-02-16 12:13:14", "2022-02-16 15:43:14");
INSERT INTO `theme_actionscheduler_logs` VALUES("1208", "410", "action started via WP Cron", "2022-02-16 12:13:25", "2022-02-16 15:43:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1209", "410", "action complete via WP Cron", "2022-02-16 12:13:25", "2022-02-16 15:43:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1210", "411", "ایجاد فعالیت", "2022-02-16 12:15:20", "2022-02-16 15:45:20");
INSERT INTO `theme_actionscheduler_logs` VALUES("1211", "411", "action started via WP Cron", "2022-02-16 12:15:23", "2022-02-16 15:45:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1212", "411", "action complete via WP Cron", "2022-02-16 12:15:23", "2022-02-16 15:45:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1213", "412", "ایجاد فعالیت", "2022-02-16 12:16:08", "2022-02-16 15:46:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1214", "412", "action started via WP Cron", "2022-02-16 12:16:24", "2022-02-16 15:46:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1215", "412", "action complete via WP Cron", "2022-02-16 12:16:24", "2022-02-16 15:46:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1216", "413", "ایجاد فعالیت", "2022-02-16 12:17:49", "2022-02-16 15:47:49");
INSERT INTO `theme_actionscheduler_logs` VALUES("1217", "413", "action started via WP Cron", "2022-02-16 12:18:23", "2022-02-16 15:48:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1218", "413", "action complete via WP Cron", "2022-02-16 12:18:23", "2022-02-16 15:48:23");
INSERT INTO `theme_actionscheduler_logs` VALUES("1219", "414", "ایجاد فعالیت", "2022-02-16 12:20:01", "2022-02-16 15:50:01");
INSERT INTO `theme_actionscheduler_logs` VALUES("1220", "414", "action started via WP Cron", "2022-02-16 12:20:24", "2022-02-16 15:50:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1221", "414", "action complete via WP Cron", "2022-02-16 12:20:24", "2022-02-16 15:50:24");
INSERT INTO `theme_actionscheduler_logs` VALUES("1222", "415", "ایجاد فعالیت", "2022-02-16 12:22:31", "2022-02-16 15:52:31");
INSERT INTO `theme_actionscheduler_logs` VALUES("1223", "415", "action started via WP Cron", "2022-02-16 12:25:12", "2022-02-16 15:55:12");
INSERT INTO `theme_actionscheduler_logs` VALUES("1224", "415", "action complete via WP Cron", "2022-02-16 12:25:12", "2022-02-16 15:55:12");
INSERT INTO `theme_actionscheduler_logs` VALUES("1225", "416", "ایجاد فعالیت", "2022-02-16 12:27:06", "2022-02-16 15:57:06");
INSERT INTO `theme_actionscheduler_logs` VALUES("1226", "416", "action started via WP Cron", "2022-02-16 12:27:28", "2022-02-16 15:57:28");
INSERT INTO `theme_actionscheduler_logs` VALUES("1227", "416", "action complete via WP Cron", "2022-02-16 12:27:28", "2022-02-16 15:57:28");
INSERT INTO `theme_actionscheduler_logs` VALUES("1228", "417", "ایجاد فعالیت", "2022-02-16 12:28:27", "2022-02-16 15:58:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1229", "417", "action started via WP Cron", "2022-02-16 12:29:29", "2022-02-16 15:59:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1230", "417", "action complete via WP Cron", "2022-02-16 12:29:29", "2022-02-16 15:59:29");
INSERT INTO `theme_actionscheduler_logs` VALUES("1231", "418", "ایجاد فعالیت", "2022-02-16 12:30:57", "2022-02-16 16:00:57");
INSERT INTO `theme_actionscheduler_logs` VALUES("1232", "418", "action started via WP Cron", "2022-02-16 12:31:27", "2022-02-16 16:01:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1233", "418", "action complete via WP Cron", "2022-02-16 12:31:27", "2022-02-16 16:01:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1234", "419", "ایجاد فعالیت", "2022-02-16 12:33:36", "2022-02-16 16:03:36");
INSERT INTO `theme_actionscheduler_logs` VALUES("1235", "419", "action started via WP Cron", "2022-02-16 12:34:28", "2022-02-16 16:04:28");
INSERT INTO `theme_actionscheduler_logs` VALUES("1236", "419", "action complete via WP Cron", "2022-02-16 12:34:28", "2022-02-16 16:04:28");
INSERT INTO `theme_actionscheduler_logs` VALUES("1237", "420", "ایجاد فعالیت", "2022-02-16 12:35:27", "2022-02-16 16:05:27");
INSERT INTO `theme_actionscheduler_logs` VALUES("1238", "420", "action started via WP Cron", "2022-02-16 12:38:36", "2022-02-16 16:08:36");
INSERT INTO `theme_actionscheduler_logs` VALUES("1239", "420", "action complete via WP Cron", "2022-02-16 12:38:36", "2022-02-16 16:08:36");
INSERT INTO `theme_actionscheduler_logs` VALUES("1240", "421", "ایجاد فعالیت", "2022-02-16 12:46:30", "2022-02-16 16:16:30");
INSERT INTO `theme_actionscheduler_logs` VALUES("1241", "422", "ایجاد فعالیت", "2022-02-16 12:46:49", "2022-02-16 16:16:49");
INSERT INTO `theme_actionscheduler_logs` VALUES("1242", "421", "action started via WP Cron", "2022-02-16 12:47:34", "2022-02-16 16:17:34");
INSERT INTO `theme_actionscheduler_logs` VALUES("1243", "421", "action complete via WP Cron", "2022-02-16 12:47:34", "2022-02-16 16:17:34");
INSERT INTO `theme_actionscheduler_logs` VALUES("1244", "422", "action started via WP Cron", "2022-02-16 12:47:34", "2022-02-16 16:17:34");
INSERT INTO `theme_actionscheduler_logs` VALUES("1245", "422", "action complete via WP Cron", "2022-02-16 12:47:34", "2022-02-16 16:17:34");
INSERT INTO `theme_actionscheduler_logs` VALUES("1246", "423", "ایجاد فعالیت", "2022-02-16 12:48:52", "2022-02-16 16:18:52");
INSERT INTO `theme_actionscheduler_logs` VALUES("1247", "423", "action started via WP Cron", "2022-02-16 12:49:32", "2022-02-16 16:19:32");
INSERT INTO `theme_actionscheduler_logs` VALUES("1248", "423", "action complete via WP Cron", "2022-02-16 12:49:32", "2022-02-16 16:19:32");
INSERT INTO `theme_actionscheduler_logs` VALUES("1249", "424", "ایجاد فعالیت", "2022-02-16 12:50:25", "2022-02-16 16:20:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1250", "424", "action started via WP Cron", "2022-02-16 12:50:25", "2022-02-16 16:20:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1251", "424", "action complete via WP Cron", "2022-02-16 12:50:25", "2022-02-16 16:20:25");
INSERT INTO `theme_actionscheduler_logs` VALUES("1252", "425", "ایجاد فعالیت", "2022-02-16 12:52:08", "2022-02-16 16:22:08");
INSERT INTO `theme_actionscheduler_logs` VALUES("1253", "425", "action started via WP Cron", "2022-02-16 12:52:26", "2022-02-16 16:22:26");
INSERT INTO `theme_actionscheduler_logs` VALUES("1254", "425", "action complete via WP Cron", "2022-02-16 12:52:26", "2022-02-16 16:22:26");
INSERT INTO `theme_actionscheduler_logs` VALUES("1255", "426", "ایجاد فعالیت", "2022-02-17 07:00:57", "2022-02-17 10:30:57");
INSERT INTO `theme_actionscheduler_logs` VALUES("1256", "426", "action started via WP Cron", "2022-02-17 07:01:26", "2022-02-17 10:31:26");
INSERT INTO `theme_actionscheduler_logs` VALUES("1257", "426", "action complete via WP Cron", "2022-02-17 07:01:26", "2022-02-17 10:31:26");
INSERT INTO `theme_actionscheduler_logs` VALUES("1261", "428", "ایجاد فعالیت", "2022-02-17 08:05:30", "2022-02-17 11:35:30");
INSERT INTO `theme_actionscheduler_logs` VALUES("1262", "428", "action started via WP Cron", "2022-02-17 08:06:30", "2022-02-17 11:36:30");
INSERT INTO `theme_actionscheduler_logs` VALUES("1263", "428", "action complete via WP Cron", "2022-02-17 08:06:30", "2022-02-17 11:36:30");
INSERT INTO `theme_actionscheduler_logs` VALUES("1264", "429", "ایجاد فعالیت", "2022-02-18 06:04:56", "2022-02-18 09:34:56");
INSERT INTO `theme_actionscheduler_logs` VALUES("1265", "429", "action started via WP Cron", "2022-02-18 06:06:21", "2022-02-18 09:36:21");
INSERT INTO `theme_actionscheduler_logs` VALUES("1266", "429", "action complete via WP Cron", "2022-02-18 06:06:21", "2022-02-18 09:36:21");
INSERT INTO `theme_actionscheduler_logs` VALUES("1270", "431", "ایجاد فعالیت", "2022-02-19 07:18:31", "2022-02-19 10:48:31");
INSERT INTO `theme_actionscheduler_logs` VALUES("1271", "431", "action started via WP Cron", "2022-02-19 07:44:17", "2022-02-19 11:14:17");
INSERT INTO `theme_actionscheduler_logs` VALUES("1272", "431", "action complete via WP Cron", "2022-02-19 07:44:17", "2022-02-19 11:14:17");
INSERT INTO `theme_actionscheduler_logs` VALUES("1273", "432", "ایجاد فعالیت", "2022-02-20 05:43:43", "2022-02-20 09:13:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1274", "432", "action started via Async Request", "2022-02-20 05:43:49", "2022-02-20 09:13:49");
INSERT INTO `theme_actionscheduler_logs` VALUES("1275", "432", "action complete via Async Request", "2022-02-20 05:43:49", "2022-02-20 09:13:49");
INSERT INTO `theme_actionscheduler_logs` VALUES("1276", "433", "ایجاد فعالیت", "2022-02-20 13:09:36", "2022-02-20 16:39:36");
INSERT INTO `theme_actionscheduler_logs` VALUES("1277", "434", "ایجاد فعالیت", "2022-02-20 13:09:36", "2022-02-20 16:39:36");
INSERT INTO `theme_actionscheduler_logs` VALUES("1278", "433", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:09:37", "2022-02-20 16:39:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1279", "433", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:09:37", "2022-02-20 16:39:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1280", "434", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:09:37", "2022-02-20 16:39:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1281", "434", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:09:37", "2022-02-20 16:39:37");
INSERT INTO `theme_actionscheduler_logs` VALUES("1282", "435", "ایجاد فعالیت", "2022-02-20 13:16:47", "2022-02-20 16:46:47");
INSERT INTO `theme_actionscheduler_logs` VALUES("1283", "436", "ایجاد فعالیت", "2022-02-20 13:17:45", "2022-02-20 16:47:45");
INSERT INTO `theme_actionscheduler_logs` VALUES("1284", "437", "ایجاد فعالیت", "2022-02-20 13:17:45", "2022-02-20 16:47:45");
INSERT INTO `theme_actionscheduler_logs` VALUES("1285", "438", "ایجاد فعالیت", "2022-02-20 13:17:45", "2022-02-20 16:47:45");
INSERT INTO `theme_actionscheduler_logs` VALUES("1286", "439", "ایجاد فعالیت", "2022-02-20 13:17:45", "2022-02-20 16:47:45");
INSERT INTO `theme_actionscheduler_logs` VALUES("1287", "435", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1288", "435", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1289", "436", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1290", "436", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1291", "437", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1292", "437", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1293", "438", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1294", "438", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1295", "439", "عملیات توسط WP Cron شروع شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");
INSERT INTO `theme_actionscheduler_logs` VALUES("1296", "439", "عملیات توسط WP Cron کامل شد", "2022-02-20 13:18:43", "2022-02-20 16:48:43");

/* INSERT TABLE DATA: theme_commentmeta */
INSERT INTO `theme_commentmeta` VALUES("3", "3", "rating", "5");
INSERT INTO `theme_commentmeta` VALUES("4", "3", "verified", "0");

/* INSERT TABLE DATA: theme_comments */
INSERT INTO `theme_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-08-05 22:24:47", "2021-08-05 18:54:47", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `theme_comments` VALUES("3", "287", "میلاد", "saeidanoushe@yahoo.com", "", "164.215.237.30", "2021-09-01 12:45:05", "2021-09-01 08:15:05", "چقدر عالی- من چطور می تونم این گوشی رو خریداری کنم", "0", "1", "Mozilla/5.0 (Windows NT 6.1; rv:85.0) Gecko/20100101 Firefox/85.0", "review", "0", "0");
INSERT INTO `theme_comments` VALUES("5", "756", "Cherehapa.ru", "sharon.nelson@gmail.com", "https://ro.exospecial.com/cherehapa.ru", "185.213.27.108", "2022-01-09 05:56:12", "2022-01-09 02:26:12", "Great content!  Keep up the good work!", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:83.0) Gecko/20100101 Firefox/83.0", "comment", "0", "0");

/* INSERT TABLE DATA: theme_duplicator_packages */
INSERT INTO `theme_duplicator_packages` VALUES("10", "Shapino_Theme", "2b50d6afa458c1fc4242_20220220133252", "21", "2022-02-20 13:33:04", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-20 13:32:52\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:7:\"10.4.20\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:10;s:4:\"Name\";s:13:\"Shapino_Theme\";s:4:\"Hash\";s:35:\"2b50d6afa458c1fc4242_20220220133252\";s:8:\"NameHash\";s:49:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:61:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:49:\"/home/instabot/domains/instabotapp.ir/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-20 13:32:52\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:7:\"10.4.20\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"Shapino_Theme\";s:4:\"Hash\";s:35:\"2b50d6afa458c1fc4242_20220220133252\";s:8:\"NameHash\";s:49:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:63:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:62:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:5:{s:29:\"theme_actionscheduler_actions\";s:2:\"51\";s:28:\"theme_actionscheduler_claims\";s:1:\"0\";s:28:\"theme_actionscheduler_groups\";s:1:\"3\";s:26:\"theme_actionscheduler_logs\";s:3:\"153\";s:17:\"theme_commentmeta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:144:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/backups-dup-lite/tmp/Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:58:\"/home/instabot/domains/instabotapp.ir/public_html/wp-admin\";i:1;s:68:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/uploads\";i:2;s:70:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/languages\";i:3;s:67:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes\";i:4;s:61:\"/home/instabot/domains/instabotapp.ir/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:49:\"/home/instabot/domains/instabotapp.ir/public_html\";i:1;s:60:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:135;}");

/* INSERT TABLE DATA: theme_options */
INSERT INTO `theme_options` VALUES("1", "siteurl", "https://instabotapp.ir", "yes");
INSERT INTO `theme_options` VALUES("2", "home", "https://instabotapp.ir", "yes");
INSERT INTO `theme_options` VALUES("3", "blogname", "شاپینو", "yes");
INSERT INTO `theme_options` VALUES("4", "blogdescription", "معتبرترین و بزرگترین فروشگاه اینترنتی ایران", "yes");
INSERT INTO `theme_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `theme_options` VALUES("6", "admin_email", "amirmohammadkazemaslani@yahoo.com", "yes");
INSERT INTO `theme_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `theme_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `theme_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `theme_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `theme_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `theme_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `theme_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `theme_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `theme_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `theme_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `theme_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `theme_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `theme_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `theme_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `theme_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `theme_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `theme_options` VALUES("23", "date_format", "j , F , Y", "yes");
INSERT INTO `theme_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `theme_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `theme_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `theme_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `theme_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `theme_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `theme_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `theme_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `theme_options` VALUES("33", "active_plugins", "a:13:{i:0;s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";i:1;s:35:\"classic-widgets/classic-widgets.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:5;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:41:\"wordpress-importer/wordpress-importer.php\";i:8;s:24:\"wordpress-seo/wp-seo.php\";i:9;s:23:\"wp-shamsi/wp-shamsi.php\";i:10;s:31:\"wp-statistics/wp-statistics.php\";i:12;s:36:\"yith-woocommerce-quick-view/init.php\";i:13;s:34:\"yith-woocommerce-wishlist/init.php\";}", "yes");
INSERT INTO `theme_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `theme_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `theme_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `theme_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `theme_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `theme_options` VALUES("39", "recently_edited", "a:5:{i:0;s:86:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes/Shapino/header.php\";i:1;s:85:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes/Shapino/style.css\";i:3;s:92:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes/Shapino/js/jquery.min.js\";i:4;s:91:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes/Shapino/myfunctions.php\";i:5;s:111:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes/Shapino/widgets/category-title-carousel.php\";}", "no");
INSERT INTO `theme_options` VALUES("40", "template", "Shapino", "yes");
INSERT INTO `theme_options` VALUES("41", "stylesheet", "Shapino", "yes");
INSERT INTO `theme_options` VALUES("168", "finished_updating_comment_type", "1", "yes");
INSERT INTO `theme_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `theme_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `theme_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `theme_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `theme_options` VALUES("48", "db_version", "51917", "yes");
INSERT INTO `theme_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `theme_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `theme_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `theme_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `theme_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `theme_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `theme_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `theme_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `theme_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `theme_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `theme_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `theme_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `theme_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `theme_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `theme_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `theme_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `theme_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `theme_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `theme_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `theme_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `theme_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `theme_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `theme_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `theme_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `theme_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `theme_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `theme_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `theme_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `theme_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("79", "widget_text", "a:5:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:33:\"نماد ها و اعتبارات\";s:4:\"text\";s:136:\"<img class=\"alignnone  wp-image-931\" src=\"https://instabotapp.ir/wp-content/uploads/2021/09/ll-1.png\" alt=\"\" width=\"135\" height=\"126\" />\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:3;a:4:{s:5:\"title\";s:17:\"درباره ما\";s:4:\"text\";s:348:\"<div id=\"text\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی ...</div>\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}i:4;a:4:{s:5:\"title\";s:23:\"اطلاعات تماس\";s:4:\"text\";s:102:\"<strong>شماره تماس :</strong>\r\n\r\n021-123456\r\n\r\n<strong>ایمیل</strong> :\r\n\r\ninfo@test.com\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("81", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `theme_options` VALUES("82", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `theme_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `theme_options` VALUES("84", "page_on_front", "271", "yes");
INSERT INTO `theme_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `theme_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `theme_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `theme_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `theme_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `theme_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `theme_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `theme_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `theme_options` VALUES("93", "admin_email_lifespan", "1659356086", "yes");
INSERT INTO `theme_options` VALUES("94", "initial_db_version", "47018", "yes");
INSERT INTO `theme_options` VALUES("95", "theme_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "yes");
INSERT INTO `theme_options` VALUES("96", "fresh_site", "0", "yes");
INSERT INTO `theme_options` VALUES("97", "WPLANG", "fa_IR", "yes");
INSERT INTO `theme_options` VALUES("98", "widget_search", "a:3:{i:2;a:1:{s:5:\"title\";s:10:\"جستجو\";}i:3;a:1:{s:5:\"title\";s:10:\"جستجو\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("99", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("100", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("101", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("102", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("103", "sidebars_widgets", "a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"mihan_footer_widget\";a:4:{i:0;s:6:\"text-3\";i:1;s:6:\"text-4\";i:2;s:10:\"nav_menu-2\";i:3;s:6:\"text-2\";}s:26:\"mihan_bottom_footer_widget\";a:1:{i:0;s:13:\"custom_html-2\";}s:20:\"mihan_sidebar_widget\";a:4:{i:0;s:8:\"search-2\";i:1;s:24:\"mihanmarketpostswidget-2\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";}s:22:\"mihan_sidebar_widget_2\";a:3:{i:0;s:19:\"mc4wp_form_widget-3\";i:1;s:8:\"search-3\";i:2;s:24:\"mihanmarketpostswidget-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `theme_options` VALUES("104", "cron", "a:25:{i:1645364002;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1645365288;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1645366035;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1645366042;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1645366176;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1645370929;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"0ec7318db0ef02283c70fa6939b91776\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1337;}}}}i:1645373376;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645376788;a:1:{s:28:\"wp_statistics_add_visit_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645379757;a:1:{s:34:\"yith_wcwl_delete_expired_wishlists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645383287;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1645383288;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1645383295;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645384176;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1645387582;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1645387635;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645387897;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645390800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645424400;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645429596;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645443460;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645448986;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1645775196;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1645815287;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1646658636;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `theme_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("107", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("108", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("109", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("110", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("111", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("112", "widget_nav_menu", "a:2:{i:2;a:2:{s:5:\"title\";s:21:\"دسترسی سریع\";s:8:\"nav_menu\";i:114;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("113", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:87:\"<p style=\"text-align:center;\">\r\n	تمامی حقوق محفوظ است - ۱۴۰۰\r\n</p>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("115", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("117", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1628193669;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `theme_options` VALUES("161", "disallowed_keys", "", "no");
INSERT INTO `theme_options` VALUES("162", "comment_previously_approved", "1", "yes");
INSERT INTO `theme_options` VALUES("163", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("164", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `theme_options` VALUES("165", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `theme_options` VALUES("166", "auto_update_core_major", "unset", "yes");
INSERT INTO `theme_options` VALUES("167", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("169", "db_upgraded", "", "yes");
INSERT INTO `theme_options` VALUES("173", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("466", "rsssl_le_installation_progress", "a:2:{i:0;s:16:\"dns-verification\";i:1;s:13:\"system-status\";}", "yes");
INSERT INTO `theme_options` VALUES("179", "action_scheduler_hybrid_store_demarkation", "7", "yes");
INSERT INTO `theme_options` VALUES("180", "schema-ActionScheduler_StoreSchema", "6.0.1645362575", "yes");
INSERT INTO `theme_options` VALUES("181", "schema-ActionScheduler_LoggerSchema", "3.0.1640435743", "yes");
INSERT INTO `theme_options` VALUES("433", "new_admin_email", "amirmohammadkazemaslani@yahoo.com", "yes");
INSERT INTO `theme_options` VALUES("85451", "_transient_timeout__woocommerce_helper_updates", "1645383767", "no");
INSERT INTO `theme_options` VALUES("85452", "_transient__woocommerce_helper_updates", "a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1645340567;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}", "no");
INSERT INTO `theme_options` VALUES("382", "elementor_active_kit", "12", "yes");
INSERT INTO `theme_options` VALUES("388", "_elementor_installed_time", "1628194299", "yes");
INSERT INTO `theme_options` VALUES("389", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:3:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:13:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:14:\"Online Service\";i:7;s:7:\"Product\";i:8;s:11:\"Real Estate\";i:9;s:18:\"Social Involvement\";i:10;s:14:\"Thank You Page\";i:11;s:6:\"Travel\";i:12;s:18:\"Under Construction\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:735:{i:0;a:16:{s:4:\"tmpl\";i:768;s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:206;s:11:\"trend_index\";i:207;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:16:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:16:{s:4:\"tmpl\";i:773;s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:295;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:16:{s:4:\"tmpl\";i:776;s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:151;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:16:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:16:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:16:{s:4:\"tmpl\";i:782;s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:458;s:11:\"trend_index\";i:597;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:16:{s:4:\"tmpl\";i:783;s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:233;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:16:{s:4:\"tmpl\";i:787;s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:689;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:16:{s:4:\"tmpl\";i:788;s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:326;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:16:{s:4:\"tmpl\";i:790;s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:390;s:11:\"trend_index\";i:393;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:16:{s:4:\"tmpl\";i:791;s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:525;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:16:{s:4:\"tmpl\";i:793;s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:636;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:16:{s:4:\"tmpl\";i:794;s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:242;s:11:\"trend_index\";i:258;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:16:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:16:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:16:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:16:{s:4:\"tmpl\";i:799;s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:353;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:16:{s:4:\"tmpl\";i:800;s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:298;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:16:{s:4:\"tmpl\";i:802;s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:722;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:16:{s:4:\"tmpl\";i:804;s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:554;s:11:\"trend_index\";i:618;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:16:{s:4:\"tmpl\";i:805;s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:382;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:16:{s:4:\"tmpl\";i:807;s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:629;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:16:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:16:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:16:{s:4:\"tmpl\";i:812;s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:485;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:16:{s:4:\"tmpl\";i:814;s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:356;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:16:{s:4:\"tmpl\";i:815;s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:494;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:16:{s:4:\"tmpl\";i:817;s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:543;s:11:\"trend_index\";i:456;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:16:{s:4:\"tmpl\";i:818;s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:722;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:16:{s:4:\"tmpl\";i:819;s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:440;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:16:{s:4:\"tmpl\";i:820;s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:676;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:16:{s:4:\"tmpl\";i:821;s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:384;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:16:{s:4:\"tmpl\";i:822;s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:477;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:16:{s:4:\"tmpl\";i:824;s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:398;s:11:\"trend_index\";i:282;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:16:{s:4:\"tmpl\";i:827;s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:570;s:11:\"trend_index\";i:589;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:16:{s:4:\"tmpl\";i:828;s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:623;s:11:\"trend_index\";i:660;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:16:{s:4:\"tmpl\";i:830;s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:700;s:11:\"trend_index\";i:738;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:16:{s:4:\"tmpl\";i:835;s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:694;s:11:\"trend_index\";i:694;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:16:{s:4:\"tmpl\";i:836;s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:442;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:16:{s:4:\"tmpl\";i:854;s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:475;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:16:{s:4:\"tmpl\";i:857;s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:16:{s:4:\"tmpl\";i:858;s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:572;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:16:{s:4:\"tmpl\";i:861;s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:664;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:16:{s:4:\"tmpl\";i:862;s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:668;s:11:\"trend_index\";i:668;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:16:{s:4:\"tmpl\";i:863;s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:615;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:16:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:16:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:16:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:16:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:16:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:16:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:16:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:16:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"online shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:16:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:16:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:16:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:16:{s:4:\"tmpl\";i:719;s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:603;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:16:{s:4:\"tmpl\";i:720;s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:607;s:11:\"trend_index\";i:460;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:16:{s:4:\"tmpl\";i:721;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:705;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:16:{s:4:\"tmpl\";i:724;s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:684;s:11:\"trend_index\";i:658;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:16:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:16:{s:4:\"tmpl\";i:727;s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:571;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:16:{s:4:\"tmpl\";i:728;s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:527;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:16:{s:4:\"tmpl\";i:730;s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:538;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:16:{s:4:\"tmpl\";i:733;s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:691;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:16:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/interior-design-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:16:{s:4:\"tmpl\";i:735;s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:436;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:16:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:16:{s:4:\"tmpl\";i:736;s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:760;s:11:\"trend_index\";i:781;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:16:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:16:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:72;a:16:{s:4:\"tmpl\";i:738;s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:742;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:16:{s:4:\"tmpl\";i:742;s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:669;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:16:{s:4:\"tmpl\";i:743;s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:751;s:11:\"trend_index\";i:838;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:16:{s:4:\"tmpl\";i:744;s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:769;s:11:\"trend_index\";i:684;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:16:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:16:{s:4:\"tmpl\";i:752;s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:757;s:11:\"trend_index\";i:700;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:16:{s:4:\"tmpl\";i:753;s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:551;s:11:\"trend_index\";i:627;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:16:{s:4:\"tmpl\";i:754;s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:588;s:11:\"trend_index\";i:591;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:16:{s:4:\"tmpl\";i:757;s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:772;s:11:\"trend_index\";i:817;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:16:{s:4:\"tmpl\";i:759;s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:792;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:16:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:16:{s:4:\"tmpl\";i:760;s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:587;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:16:{s:4:\"tmpl\";i:761;s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:614;s:11:\"trend_index\";i:717;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:16:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:16:{s:4:\"tmpl\";i:763;s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:764;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:16:{s:4:\"tmpl\";i:766;s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:644;s:11:\"trend_index\";i:632;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:16:{s:4:\"tmpl\";i:767;s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:758;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:16:{s:4:\"tmpl\";i:831;s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:720;s:11:\"trend_index\";i:823;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:16:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:16:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:16:{s:4:\"tmpl\";i:718;s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:600;s:11:\"trend_index\";i:604;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:16:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photographer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"project\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:94;a:16:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:16:{s:4:\"tmpl\";i:1204;s:2:\"id\";i:20208;s:5:\"title\";s:49:\"Alternative Medicine Acupuncture &#8211; Business\";s:9:\"thumbnail\";s:112:\"https://library.elementor.com/wp-content/uploads/2021/10/Alternative-Medicine-Acupuncture-Business-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633880557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/alternative-medicine-acupuncture-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:47:\"[\"Health\",\"Landing Pages\",\"medical\",\"Services\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:96;a:16:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:97;a:16:{s:4:\"tmpl\";i:842;s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:729;s:11:\"trend_index\";i:802;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:16:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:16:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:16:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:101;a:16:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/law-firm-services-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:102;a:16:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:16:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:104;a:16:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photographer-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Gallery\",\"Photography\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:105;a:16:{s:4:\"tmpl\";i:748;s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:765;s:11:\"trend_index\";i:840;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:16:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:16:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:108;a:16:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/architecture-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"creative portfolio\",\"portfolio\",\"Project\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:109;a:16:{s:4:\"tmpl\";i:810;s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:666;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:16:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:16:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:112;a:16:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:113;a:16:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:16:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"online shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:115;a:16:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/3d-designer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"creative portfolio\",\"Design\",\"Designer\",\"portfolio\",\"Project\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:16:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:16:{s:4:\"tmpl\";i:1215;s:2:\"id\";i:20556;s:5:\"title\";s:41:\"Faroe Islands Trip Planner &#8211; Travel\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Faroe-Islands-Trip-Planner-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634026480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/faroe-islands-trip-planner-travel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:26:\"[\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:118;a:16:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/business-consulting-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:119;a:16:{s:4:\"tmpl\";i:834;s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:474;s:11:\"trend_index\";i:398;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:16:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:16:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"interior design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:122;a:16:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/conference-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:37:\"[\"Conference\",\"Contact\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:16:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:124;a:16:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/construction-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:125;a:16:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:126;a:16:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:127;a:16:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:128;a:16:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/contact-plants-store/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:16:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"online shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:130;a:16:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:16:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:132;a:16:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:133;a:16:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dental-care-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:16:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:135;a:16:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:136;a:16:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"medical\",\"Online\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:16:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:138;a:16:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:139;a:16:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/time-management-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:140;a:16:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/exhibition-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"creative portfolio\",\"Exhibition\",\"Gallery\",\"portfolio\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:16:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:142;a:16:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:143;a:16:{s:4:\"tmpl\";i:797;s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:752;s:11:\"trend_index\";i:813;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:144;a:16:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:145;a:16:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/hotel-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Contact\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:16:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:147;a:16:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/conference-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:148;a:16:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/insurance-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:16:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:150;a:16:{s:4:\"tmpl\";i:779;s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:497;s:11:\"trend_index\";i:503;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:16:{s:4:\"tmpl\";i:811;s:2:\"id\";i:10559;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";i:1547967711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:729;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:16:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:16:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:154;a:16:{s:4:\"tmpl\";i:846;s:2:\"id\";i:10403;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";i:1548056371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:627;s:11:\"trend_index\";i:659;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:16:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:16:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/interior-designer-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:16:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:161;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:158;a:16:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:159;a:16:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/online-training-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:16:{s:4:\"tmpl\";i:749;s:2:\"id\";i:9913;s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";i:1547841430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:542;s:11:\"trend_index\";i:417;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:16:{s:4:\"tmpl\";i:506;s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:116;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:162;a:16:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/car-wash-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:163;a:16:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/packing-moving-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"moving\",\"Storge\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:16:{s:4:\"tmpl\";i:504;s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:70;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:16:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:16:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/restaurant-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:46:\"[\"Contact\",\"Food\",\"form\",\"Google Maps\",\"Info\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:16:{s:4:\"tmpl\";i:499;s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:52;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:168;a:16:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:16:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/spa-beauty-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:170;a:16:{s:4:\"tmpl\";i:503;s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:12;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:171;a:16:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:172;a:16:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/travel-agency-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:16:{s:4:\"tmpl\";i:507;s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:303;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:174;a:16:{s:4:\"tmpl\";i:545;s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:40;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:175;a:16:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:176;a:16:{s:4:\"tmpl\";i:717;s:2:\"id\";i:9592;s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";i:1546963720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:807;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:16:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:16:{s:4:\"tmpl\";i:778;s:2:\"id\";i:10210;s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";i:1547886103;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:784;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:179;a:16:{s:4:\"tmpl\";i:546;s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:123;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:180;a:16:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:16:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:182;a:16:{s:4:\"tmpl\";i:508;s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:169;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:183;a:16:{s:4:\"tmpl\";i:556;s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:26;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:184;a:16:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:185;a:16:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:186;a:16:{s:4:\"tmpl\";i:762;s:2:\"id\";i:10047;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";i:1547847757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:513;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:16:{s:4:\"tmpl\";i:509;s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:453;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:188;a:16:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:16:{s:4:\"tmpl\";i:684;s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:15;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:16:{s:4:\"tmpl\";i:746;s:2:\"id\";i:9879;s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";i:1547838416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:676;s:11:\"trend_index\";i:761;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:16:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:192;a:16:{s:4:\"tmpl\";i:685;s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:124;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:16:{s:4:\"tmpl\";i:1201;s:2:\"id\";i:19144;s:5:\"title\";s:25:\"Birthday Party Invitation\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png\";s:12:\"tmpl_created\";i:1623848691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/birthday-party-invitation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Birthday\",\"Event\",\"Landing Pages\",\"Party\",\"RSVD\",\"Save the Date\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:16:{s:4:\"tmpl\";i:1124;s:2:\"id\";i:16473;s:5:\"title\";s:26:\"Beauty Salon &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg\";s:12:\"tmpl_created\";i:1608622373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/beauty-salon-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:184;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:16:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:196;a:16:{s:4:\"tmpl\";i:686;s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:54;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:16:{s:4:\"tmpl\";i:1125;s:2:\"id\";i:16488;s:5:\"title\";s:28:\"Beauty Salon &#8211; Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg\";s:12:\"tmpl_created\";i:1608622374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:101;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:16:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:16:{s:4:\"tmpl\";i:687;s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:396;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:16:{s:4:\"tmpl\";i:843;s:2:\"id\";i:10297;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";i:1548056099;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:607;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:16:{s:4:\"tmpl\";i:1126;s:2:\"id\";i:16496;s:5:\"title\";s:28:\"Beauty Salon &#8211; Gallery\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg\";s:12:\"tmpl_created\";i:1608622379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/beauty-salon-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:90;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:16:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/online-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:16:{s:4:\"tmpl\";i:688;s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:195;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:16:{s:4:\"tmpl\";i:847;s:2:\"id\";i:10393;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";i:1548056682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:837;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:16:{s:4:\"tmpl\";i:1127;s:2:\"id\";i:16457;s:5:\"title\";s:25:\"Beauty Salon &#8211; Home\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg\";s:12:\"tmpl_created\";i:1608622383;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/beauty-salon-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:56;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:16:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:16:{s:4:\"tmpl\";i:689;s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:95;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:16:{s:4:\"tmpl\";i:1128;s:2:\"id\";i:16518;s:5:\"title\";s:29:\"Beauty Salon &#8211; Services\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg\";s:12:\"tmpl_created\";i:1608622386;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/beauty-salon-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:261;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:16:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:16:{s:4:\"tmpl\";i:690;s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:111;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:16:{s:4:\"tmpl\";i:813;s:2:\"id\";i:10579;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";i:1547967887;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:782;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:16:{s:4:\"tmpl\";i:1073;s:2:\"id\";i:15486;s:5:\"title\";s:25:\"Travel Blog &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg\";s:12:\"tmpl_created\";i:1606215720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/travel-blog-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:343;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:16:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:16:{s:4:\"tmpl\";i:691;s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:153;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:16:{s:4:\"tmpl\";i:1074;s:2:\"id\";i:15478;s:5:\"title\";s:27:\"Travel Blog &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1606215735;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-blog-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:564;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:16:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:217;a:16:{s:4:\"tmpl\";i:692;s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:208;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:16:{s:4:\"tmpl\";i:1075;s:2:\"id\";i:15467;s:5:\"title\";s:24:\"Travel Blog &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg\";s:12:\"tmpl_created\";i:1606215756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-blog-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:224;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:219;a:16:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:220;a:16:{s:4:\"tmpl\";i:997;s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:768;s:11:\"trend_index\";i:681;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:16:{s:4:\"tmpl\";i:1056;s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:301;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:16:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:16:{s:4:\"tmpl\";i:998;s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:737;s:11:\"trend_index\";i:523;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:16:{s:4:\"tmpl\";i:1057;s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:373;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:16:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:226;a:16:{s:4:\"tmpl\";i:996;s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Footer\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:267;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:16:{s:4:\"tmpl\";i:1058;s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:458;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:16:{s:4:\"tmpl\";i:833;s:2:\"id\";i:10180;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";i:1548045309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:788;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:16:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:230;a:16:{s:4:\"tmpl\";i:995;s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"Header\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:137;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:231;a:16:{s:4:\"tmpl\";i:1055;s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:602;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:16:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:233;a:16:{s:4:\"tmpl\";i:994;s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:736;s:11:\"trend_index\";i:580;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:16:{s:4:\"tmpl\";i:1059;s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:731;s:11:\"trend_index\";i:661;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:16:{s:4:\"tmpl\";i:1131;s:2:\"id\";i:16527;s:5:\"title\";s:24:\"Beauty Salon &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg\";s:12:\"tmpl_created\";i:1608622517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:29:\"[\"404\",\"Beauty salon\",\"Hair\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:742;s:11:\"trend_index\";i:563;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:16:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:16:{s:4:\"tmpl\";i:1060;s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:741;s:11:\"trend_index\";i:721;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:238;a:16:{s:4:\"tmpl\";i:825;s:2:\"id\";i:9731;s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";i:1547976166;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:648;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:16:{s:4:\"tmpl\";i:1130;s:2:\"id\";i:16535;s:5:\"title\";s:27:\"Beauty Salon &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg\";s:12:\"tmpl_created\";i:1608622498;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"Footer\",\"Hair\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:126;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:16:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/lp/webinar-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:16:{s:4:\"tmpl\";i:1042;s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:426;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:16:{s:4:\"tmpl\";i:1129;s:2:\"id\";i:16545;s:5:\"title\";s:27:\"Beauty Salon &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg\";s:12:\"tmpl_created\";i:1608622495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:32:\"[\"Beauty salon\",\"Hair\",\"Header\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:49;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:243;a:16:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:16:{s:4:\"tmpl\";i:1045;s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:558;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:245;a:16:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:16:{s:4:\"tmpl\";i:641;s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"Archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:152;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:16:{s:4:\"tmpl\";i:1041;s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:297;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:248;a:16:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:16:{s:4:\"tmpl\";i:484;s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:202;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:16:{s:4:\"tmpl\";i:1044;s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:732;s:11:\"trend_index\";i:537;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:16:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:16:{s:4:\"tmpl\";i:487;s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:581;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:16:{s:4:\"tmpl\";i:1043;s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:379;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:16:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:255;a:16:{s:4:\"tmpl\";i:491;s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:633;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:256;a:16:{s:4:\"tmpl\";i:1036;s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/flooring-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:319;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:16:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/moving-company-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:258;a:16:{s:4:\"tmpl\";i:488;s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:263;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:16:{s:4:\"tmpl\";i:1037;s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:380;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:16:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:261;a:16:{s:4:\"tmpl\";i:490;s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:128;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:262;a:16:{s:4:\"tmpl\";i:1038;s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:291;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:16:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:16:{s:4:\"tmpl\";i:496;s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:307;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:265;a:16:{s:4:\"tmpl\";i:758;s:2:\"id\";i:10005;s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";i:1547844909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:755;s:11:\"trend_index\";i:760;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:16:{s:4:\"tmpl\";i:1040;s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/flooring-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:392;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:16:{s:4:\"tmpl\";i:798;s:2:\"id\";i:10424;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";i:1547961866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:753;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:16:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:16:{s:4:\"tmpl\";i:486;s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:520;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:16:{s:4:\"tmpl\";i:755;s:2:\"id\";i:9975;s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";i:1547842284;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:774;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:16:{s:4:\"tmpl\";i:1039;s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/flooring-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:185;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:16:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"interior design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:16:{s:4:\"tmpl\";i:495;s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:168;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:274;a:16:{s:4:\"tmpl\";i:764;s:2:\"id\";i:10067;s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";i:1547848075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:582;s:11:\"trend_index\";i:619;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:16:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:16:{s:4:\"tmpl\";i:493;s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:232;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:277;a:16:{s:4:\"tmpl\";i:1021;s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:447;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:16:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:46:\"Aesthetic Clinic &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:16:{s:4:\"tmpl\";i:485;s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:502;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:16:{s:4:\"tmpl\";i:1020;s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:569;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:281;a:16:{s:4:\"tmpl\";i:789;s:2:\"id\";i:10329;s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";i:1547893478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:781;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:16:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:16:{s:4:\"tmpl\";i:482;s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:134;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:16:{s:4:\"tmpl\";i:1019;s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:165;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:16:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"online shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:16:{s:4:\"tmpl\";i:723;s:2:\"id\";i:9650;s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";i:1547007598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:771;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:287;a:16:{s:4:\"tmpl\";i:483;s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:321;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:288;a:16:{s:4:\"tmpl\";i:1018;s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:167;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:289;a:16:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:16:{s:4:\"tmpl\";i:492;s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:92;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:16:{s:4:\"tmpl\";i:1010;s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:287;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:16:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/open-week-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:16:{s:4:\"tmpl\";i:489;s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:381;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:16:{s:4:\"tmpl\";i:1007;s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:675;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:16:{s:4:\"tmpl\";i:840;s:2:\"id\";i:10200;s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";i:1548055635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:296;a:16:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:16:{s:4:\"tmpl\";i:494;s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:273;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:298;a:16:{s:4:\"tmpl\";i:1006;s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:735;s:11:\"trend_index\";i:829;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:16:{s:4:\"tmpl\";i:832;s:2:\"id\";i:10287;s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";i:1547994301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:439;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:16:{s:4:\"tmpl\";i:1179;s:2:\"id\";i:18329;s:5:\"title\";s:63:\"Online Real Estate Investment Conference &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png\";s:12:\"tmpl_created\";i:1614770404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:76:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Online Event\",\"Real estate\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:866;s:11:\"trend_index\";i:779;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:301;a:16:{s:4:\"tmpl\";i:425;s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:68;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:302;a:16:{s:4:\"tmpl\";i:1005;s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:389;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:16:{s:4:\"tmpl\";i:1183;s:2:\"id\";i:18391;s:5:\"title\";s:45:\"Children&#8217;s Optometrist &#8211; Business\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png\";s:12:\"tmpl_created\";i:1614773564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:85:\"[\"Business\",\"Children\",\"Eye\",\"Glasses\",\"Health\",\"Kids\",\"Landing Pages\",\"Optometrist\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:877;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:16:{s:4:\"tmpl\";i:423;s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:127;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:305;a:16:{s:4:\"tmpl\";i:1009;s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:551;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:16:{s:4:\"tmpl\";i:534;s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:76;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:307;a:16:{s:4:\"tmpl\";i:1182;s:2:\"id\";i:18366;s:5:\"title\";s:30:\"Car Insurance &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png\";s:12:\"tmpl_created\";i:1614773263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/car-insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"car\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:869;s:11:\"trend_index\";i:797;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:308;a:16:{s:4:\"tmpl\";i:747;s:2:\"id\";i:9889;s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";i:1547838722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:743;s:11:\"trend_index\";i:713;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:16:{s:4:\"tmpl\";i:1008;s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:711;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:16:{s:4:\"tmpl\";i:535;s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:313;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:16:{s:4:\"tmpl\";i:1176;s:2:\"id\";i:18291;s:5:\"title\";s:47:\"Grill Restaurant Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png\";s:12:\"tmpl_created\";i:1614767830;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Delivery\",\"Delivery Service\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:819;s:11:\"trend_index\";i:685;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:312;a:16:{s:4:\"tmpl\";i:1016;s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:727;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:16:{s:4:\"tmpl\";i:765;s:2:\"id\";i:10077;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";i:1547848197;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:540;s:11:\"trend_index\";i:574;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:16:{s:4:\"tmpl\";i:1180;s:2:\"id\";i:18340;s:5:\"title\";s:30:\"Restaurant &#8211; Coming Soon\";s:9:\"thumbnail\";s:98:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png\";s:12:\"tmpl_created\";i:1614772183;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:51:\"[\"Coming Soon\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:810;s:11:\"trend_index\";i:809;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:315;a:16:{s:4:\"tmpl\";i:430;s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:187;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:16:{s:4:\"tmpl\";i:999;s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/barbershop-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:832;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:16:{s:4:\"tmpl\";i:844;s:2:\"id\";i:10362;s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";i:1548056253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:560;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:16:{s:4:\"tmpl\";i:1173;s:2:\"id\";i:17480;s:5:\"title\";s:42:\"At-home Massage Therapist &#8211; Business\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg\";s:12:\"tmpl_created\";i:1612879264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:60:\"[\"Business\",\"Health\",\"Landing Pages\",\"Services\",\"Therapist\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:856;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:16:{s:4:\"tmpl\";i:476;s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:106;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:320;a:16:{s:4:\"tmpl\";i:1000;s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/barbershop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:744;s:11:\"trend_index\";i:739;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:16:{s:4:\"tmpl\";i:1178;s:2:\"id\";i:18317;s:5:\"title\";s:26:\"Insurance &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png\";s:12:\"tmpl_created\";i:1614769488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/lp/insurance-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:61:\"[\"Business\",\"Family\",\"Financial\",\"Insurance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:870;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:16:{s:4:\"tmpl\";i:478;s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:335;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:16:{s:4:\"tmpl\";i:1001;s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/barbershop-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:761;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:16:{s:4:\"tmpl\";i:849;s:2:\"id\";i:10454;s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";i:1548056896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:776;s:11:\"trend_index\";i:804;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:325;a:16:{s:4:\"tmpl\";i:1168;s:2:\"id\";i:17401;s:5:\"title\";s:40:\"Conference Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png\";s:12:\"tmpl_created\";i:1612724753;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:59:\"[\"Conference\",\"Event\",\"Events\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:799;s:11:\"trend_index\";i:540;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:326;a:16:{s:4:\"tmpl\";i:481;s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:490;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:327;a:16:{s:4:\"tmpl\";i:1002;s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:756;s:11:\"trend_index\";i:822;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:16:{s:4:\"tmpl\";i:532;s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:357;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:329;a:16:{s:4:\"tmpl\";i:1166;s:2:\"id\";i:17368;s:5:\"title\";s:38:\"Real Estate Agency &#8211; Real-Estate\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png\";s:12:\"tmpl_created\";i:1612711814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:73:\"[\"Landing Pages\",\"listing\",\"Real estate\",\"Realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:858;s:11:\"trend_index\";i:777;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:16:{s:4:\"tmpl\";i:739;s:2:\"id\";i:9803;s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";i:1547831298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:808;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:16:{s:4:\"tmpl\";i:1003;s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:753;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:16:{s:4:\"tmpl\";i:816;s:2:\"id\";i:10611;s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";i:1547968868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:779;s:11:\"trend_index\";i:792;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:333;a:16:{s:4:\"tmpl\";i:1170;s:2:\"id\";i:17423;s:5:\"title\";s:57:\"Volunteer Calls Thank You Page &#8211; Social Involvement\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg\";s:12:\"tmpl_created\";i:1612726058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:62:\"[\"Care\",\"Involvement\",\"Landing Pages\",\"Thank You\",\"Volunteer\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:857;s:11:\"trend_index\";i:818;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:334;a:16:{s:4:\"tmpl\";i:422;s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:217;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:335;a:16:{s:4:\"tmpl\";i:982;s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/online-course-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:125;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:336;a:16:{s:4:\"tmpl\";i:533;s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:495;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:337;a:16:{s:4:\"tmpl\";i:1169;s:2:\"id\";i:17409;s:5:\"title\";s:37:\"Webinar Thank You Page &#8211; Events\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png\";s:12:\"tmpl_created\";i:1612725644;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:56:\"[\"Event\",\"Events\",\"Landing Pages\",\"Thank You\",\"Webinar\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:868;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:338;a:16:{s:4:\"tmpl\";i:983;s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/online-course-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:429;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:339;a:16:{s:4:\"tmpl\";i:806;s:2:\"id\";i:10508;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";i:1547964711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:711;s:11:\"trend_index\";i:793;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:340;a:16:{s:4:\"tmpl\";i:1160;s:2:\"id\";i:17258;s:5:\"title\";s:32:\"Beauty Product &#8211; eCommerce\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png\";s:12:\"tmpl_created\";i:1610903153;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:38:\"[\"beauty\",\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:797;s:11:\"trend_index\";i:703;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:341;a:16:{s:4:\"tmpl\";i:424;s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:131;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:342;a:16:{s:4:\"tmpl\";i:984;s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/online-course-course-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:310;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:343;a:16:{s:4:\"tmpl\";i:1171;s:2:\"id\";i:17435;s:5:\"title\";s:39:\"Gym &#8211; App Service &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png\";s:12:\"tmpl_created\";i:1612726462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/gym-app-service-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:58:\"[\"App\",\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:767;s:11:\"trend_index\";i:577;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:344;a:16:{s:4:\"tmpl\";i:426;s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:93;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:345;a:16:{s:4:\"tmpl\";i:985;s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/online-course-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:533;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:346;a:16:{s:4:\"tmpl\";i:751;s:2:\"id\";i:9934;s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";i:1547841787;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:752;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:347;a:16:{s:4:\"tmpl\";i:1156;s:2:\"id\";i:17111;s:5:\"title\";s:33:\"Sunglasses Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610632408;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Ecommerce\",\"Fashion\",\"Landing Pages\",\"Sale\",\"Sunglasses\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:812;s:11:\"trend_index\";i:732;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:348;a:16:{s:4:\"tmpl\";i:432;s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:31;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:349;a:16:{s:4:\"tmpl\";i:971;s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:264;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:350;a:16:{s:4:\"tmpl\";i:1157;s:2:\"id\";i:17223;s:5:\"title\";s:25:\"Fashion &#8211; eCommerce\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png\";s:12:\"tmpl_created\";i:1610902553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:808;s:11:\"trend_index\";i:745;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:351;a:16:{s:4:\"tmpl\";i:427;s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:150;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:352;a:16:{s:4:\"tmpl\";i:972;s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:334;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:353;a:16:{s:4:\"tmpl\";i:729;s:2:\"id\";i:9709;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";i:1547023834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:728;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:354;a:16:{s:4:\"tmpl\";i:1151;s:2:\"id\";i:17017;s:5:\"title\";s:28:\"Shoes Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610535361;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:55:\"[\"Discount\",\"Ecommerce\",\"Landing Pages\",\"Sale\",\"Shoes\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:803;s:11:\"trend_index\";i:642;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:355;a:16:{s:4:\"tmpl\";i:429;s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:72;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:356;a:16:{s:4:\"tmpl\";i:973;s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:323;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:357;a:16:{s:4:\"tmpl\";i:725;s:2:\"id\";i:9671;s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1547010259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:639;s:11:\"trend_index\";i:598;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:358;a:16:{s:4:\"tmpl\";i:838;s:2:\"id\";i:10234;s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";i:1548055049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:746;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:359;a:16:{s:4:\"tmpl\";i:1163;s:2:\"id\";i:17301;s:5:\"title\";s:53:\"Personal Chef &#8211; Thank You Page &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg\";s:12:\"tmpl_created\";i:1610903622;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:43:\"[\"Chef\",\"Food\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:823;s:11:\"trend_index\";i:754;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:360;a:16:{s:4:\"tmpl\";i:431;s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:260;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:361;a:16:{s:4:\"tmpl\";i:974;s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:337;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:362;a:16:{s:4:\"tmpl\";i:1164;s:2:\"id\";i:17313;s:5:\"title\";s:60:\"Development Course  &#8211; Thank You Page &#8211; Education\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png\";s:12:\"tmpl_created\";i:1610903776;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:7:\"subtype\";s:14:\"Thank You Page\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Education\",\"Landing Pages\",\"Thank You\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:834;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:363;a:16:{s:4:\"tmpl\";i:428;s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:80;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:364;a:16:{s:4:\"tmpl\";i:959;s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:201;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:365;a:16:{s:4:\"tmpl\";i:613;s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:69;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:366;a:16:{s:4:\"tmpl\";i:960;s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:374;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:367;a:16:{s:4:\"tmpl\";i:634;s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:118;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:368;a:16:{s:4:\"tmpl\";i:961;s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:350;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:369;a:16:{s:4:\"tmpl\";i:745;s:2:\"id\";i:9869;s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";i:1547837269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:766;s:11:\"trend_index\";i:820;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:370;a:16:{s:4:\"tmpl\";i:850;s:2:\"id\";i:10539;s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";i:1548056994;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:810;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:371;a:16:{s:4:\"tmpl\";i:633;s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:84;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:372;a:16:{s:4:\"tmpl\";i:962;s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:656;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:373;a:16:{s:4:\"tmpl\";i:632;s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:234;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:374;a:16:{s:4:\"tmpl\";i:963;s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:532;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:375;a:16:{s:4:\"tmpl\";i:618;s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:11;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:376;a:16:{s:4:\"tmpl\";i:964;s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:766;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:377;a:16:{s:4:\"tmpl\";i:574;s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:122;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:378;a:16:{s:4:\"tmpl\";i:965;s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:778;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:379;a:16:{s:4:\"tmpl\";i:628;s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:256;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:380;a:16:{s:4:\"tmpl\";i:966;s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:750;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:381;a:16:{s:4:\"tmpl\";i:839;s:2:\"id\";i:10147;s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";i:1548055522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:775;s:11:\"trend_index\";i:824;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:382;a:16:{s:4:\"tmpl\";i:627;s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:677;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:383;a:16:{s:4:\"tmpl\";i:967;s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:649;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:384;a:16:{s:4:\"tmpl\";i:625;s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:63;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:385;a:16:{s:4:\"tmpl\";i:968;s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:508;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:386;a:16:{s:4:\"tmpl\";i:750;s:2:\"id\";i:9923;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";i:1547841537;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:699;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:387;a:16:{s:4:\"tmpl\";i:852;s:2:\"id\";i:10117;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";i:1548066998;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:662;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:388;a:16:{s:4:\"tmpl\";i:626;s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:486;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:389;a:16:{s:4:\"tmpl\";i:969;s:2:\"id\";i:12805;s:5:\"title\";s:37:\"Photography &#8211; B&amp;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:735;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:390;a:16:{s:4:\"tmpl\";i:611;s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:270;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:391;a:16:{s:4:\"tmpl\";i:970;s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:643;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:392;a:16:{s:4:\"tmpl\";i:741;s:2:\"id\";i:9826;s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";i:1547835513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:745;s:11:\"trend_index\";i:831;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:393;a:16:{s:4:\"tmpl\";i:848;s:2:\"id\";i:10478;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";i:1548056829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:559;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:394;a:16:{s:4:\"tmpl\";i:614;s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:225;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:395;a:16:{s:4:\"tmpl\";i:940;s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:121;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:396;a:16:{s:4:\"tmpl\";i:629;s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:457;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:397;a:16:{s:4:\"tmpl\";i:936;s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:194;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:398;a:16:{s:4:\"tmpl\";i:619;s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:255;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:399;a:16:{s:4:\"tmpl\";i:932;s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:445;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:400;a:16:{s:4:\"tmpl\";i:823;s:2:\"id\";i:10685;s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";i:1547974729;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:814;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:401;a:16:{s:4:\"tmpl\";i:620;s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:262;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:402;a:16:{s:4:\"tmpl\";i:938;s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:726;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:403;a:16:{s:4:\"tmpl\";i:615;s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:117;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:404;a:16:{s:4:\"tmpl\";i:937;s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:481;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:405;a:16:{s:4:\"tmpl\";i:630;s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:517;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:406;a:16:{s:4:\"tmpl\";i:935;s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:501;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:407;a:16:{s:4:\"tmpl\";i:756;s:2:\"id\";i:9985;s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";i:1547844661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:758;s:11:\"trend_index\";i:815;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:408;a:16:{s:4:\"tmpl\";i:631;s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:702;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:409;a:16:{s:4:\"tmpl\";i:934;s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:387;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:410;a:16:{s:4:\"tmpl\";i:933;s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:536;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:411;a:16:{s:4:\"tmpl\";i:473;s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:631;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:412;a:16:{s:4:\"tmpl\";i:623;s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:250;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:413;a:16:{s:4:\"tmpl\";i:892;s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:241;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:414;a:16:{s:4:\"tmpl\";i:891;s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:290;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:415;a:16:{s:4:\"tmpl\";i:474;s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:511;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:416;a:16:{s:4:\"tmpl\";i:890;s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:467;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:417;a:16:{s:4:\"tmpl\";i:475;s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:611;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:418;a:16:{s:4:\"tmpl\";i:889;s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:449;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:419;a:16:{s:4:\"tmpl\";i:480;s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:409;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:420;a:16:{s:4:\"tmpl\";i:866;s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:32;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:421;a:16:{s:4:\"tmpl\";i:612;s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:562;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:422;a:16:{s:4:\"tmpl\";i:714;s:2:\"id\";i:9559;s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";i:1546946547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:839;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:423;a:16:{s:4:\"tmpl\";i:536;s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:828;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:424;a:16:{s:4:\"tmpl\";i:624;s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:484;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:425;a:16:{s:4:\"tmpl\";i:734;s:2:\"id\";i:9752;s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";i:1547823982;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:740;s:11:\"trend_index\";i:801;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:426;a:16:{s:4:\"tmpl\";i:616;s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:130;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:427;a:16:{s:4:\"tmpl\";i:916;s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:344;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:428;a:16:{s:4:\"tmpl\";i:617;s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:362;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:429;a:16:{s:4:\"tmpl\";i:920;s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:314;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:430;a:16:{s:4:\"tmpl\";i:514;s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:586;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:431;a:16:{s:4:\"tmpl\";i:869;s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:166;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:432;a:16:{s:4:\"tmpl\";i:622;s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:235;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:433;a:16:{s:4:\"tmpl\";i:880;s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:590;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:434;a:16:{s:4:\"tmpl\";i:774;s:2:\"id\";i:10169;s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";i:1547852334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:701;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:435;a:16:{s:4:\"tmpl\";i:621;s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:148;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:436;a:16:{s:4:\"tmpl\";i:1061;s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"Dance Studio\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:783;s:11:\"trend_index\";i:710;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:437;a:16:{s:4:\"tmpl\";i:917;s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:640;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:438;a:16:{s:4:\"tmpl\";i:1062;s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Footer\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:243;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:439;a:16:{s:4:\"tmpl\";i:915;s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:114;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:110;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:440;a:16:{s:4:\"tmpl\";i:1063;s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"Dance Studio\",\"Header\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:67;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:441;a:16:{s:4:\"tmpl\";i:921;s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:471;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:442;a:16:{s:4:\"tmpl\";i:726;s:2:\"id\";i:9680;s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";i:1547010967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:725;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:443;a:16:{s:4:\"tmpl\";i:865;s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:170;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:444;a:16:{s:4:\"tmpl\";i:874;s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Footer\",\"Marketing\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:105;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:445;a:16:{s:4:\"tmpl\";i:873;s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"Header\",\"Marketing\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:10;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:446;a:16:{s:4:\"tmpl\";i:879;s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:554;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:447;a:16:{s:4:\"tmpl\";i:737;s:2:\"id\";i:9783;s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";i:1547831059;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:534;s:11:\"trend_index\";i:415;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:448;a:16:{s:4:\"tmpl\";i:872;s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:239;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:449;a:16:{s:4:\"tmpl\";i:871;s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:73;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:450;a:16:{s:4:\"tmpl\";i:922;s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:304;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:451;a:16:{s:4:\"tmpl\";i:870;s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:71;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:452;a:16:{s:4:\"tmpl\";i:918;s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:296;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:453;a:16:{s:4:\"tmpl\";i:520;s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:231;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:454;a:16:{s:4:\"tmpl\";i:864;s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:361;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:455;a:16:{s:4:\"tmpl\";i:523;s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:112;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:456;a:16:{s:4:\"tmpl\";i:878;s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:674;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:457;a:16:{s:4:\"tmpl\";i:524;s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:305;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:458;a:16:{s:4:\"tmpl\";i:882;s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:229;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:459;a:16:{s:4:\"tmpl\";i:519;s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:38;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:460;a:16:{s:4:\"tmpl\";i:919;s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:339;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:461;a:16:{s:4:\"tmpl\";i:521;s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:251;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:462;a:16:{s:4:\"tmpl\";i:868;s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:424;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:463;a:16:{s:4:\"tmpl\";i:522;s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:327;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:464;a:16:{s:4:\"tmpl\";i:881;s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:579;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:465;a:16:{s:4:\"tmpl\";i:525;s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:180;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:466;a:16:{s:4:\"tmpl\";i:877;s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:736;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:467;a:16:{s:4:\"tmpl\";i:526;s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:474;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:468;a:16:{s:4:\"tmpl\";i:867;s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:156;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:469;a:16:{s:4:\"tmpl\";i:517;s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:193;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:470;a:16:{s:4:\"tmpl\";i:876;s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:624;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:471;a:16:{s:4:\"tmpl\";i:518;s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:515;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:472;a:16:{s:4:\"tmpl\";i:548;s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:463;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:473;a:16:{s:4:\"tmpl\";i:542;s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:265;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:474;a:16:{s:4:\"tmpl\";i:547;s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:163;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:475;a:16:{s:4:\"tmpl\";i:566;s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:98;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:476;a:16:{s:4:\"tmpl\";i:567;s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:189;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:477;a:16:{s:4:\"tmpl\";i:541;s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:351;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:478;a:16:{s:4:\"tmpl\";i:540;s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:181;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:479;a:16:{s:4:\"tmpl\";i:516;s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:352;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:480;a:16:{s:4:\"tmpl\";i:515;s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:119;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:481;a:16:{s:4:\"tmpl\";i:539;s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:133;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:482;a:16:{s:4:\"tmpl\";i:565;s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:223;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:483;a:16:{s:4:\"tmpl\";i:564;s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:113;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:484;a:16:{s:4:\"tmpl\";i:1033;s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:671;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:485;a:16:{s:4:\"tmpl\";i:1032;s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:275;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:486;a:16:{s:4:\"tmpl\";i:1031;s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Footer\"]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:192;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:487;a:16:{s:4:\"tmpl\";i:1030;s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"Header\"]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:333;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:488;a:16:{s:4:\"tmpl\";i:1029;s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:226;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:489;a:16:{s:4:\"tmpl\";i:651;s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:539;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:490;a:16:{s:4:\"tmpl\";i:647;s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:115;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:491;a:16:{s:4:\"tmpl\";i:646;s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:203;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:492;a:16:{s:4:\"tmpl\";i:645;s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:140;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:493;a:16:{s:4:\"tmpl\";i:644;s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:212;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:494;a:16:{s:4:\"tmpl\";i:643;s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:41;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:495;a:16:{s:4:\"tmpl\";i:693;s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:154;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:496;a:16:{s:4:\"tmpl\";i:652;s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:96;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:497;a:16:{s:4:\"tmpl\";i:653;s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:91;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:498;a:16:{s:4:\"tmpl\";i:654;s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:55;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:499;a:16:{s:4:\"tmpl\";i:655;s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:109;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:500;a:16:{s:4:\"tmpl\";i:656;s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:146;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:501;a:16:{s:4:\"tmpl\";i:650;s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:186;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:502;a:16:{s:4:\"tmpl\";i:649;s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:144;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:503;a:16:{s:4:\"tmpl\";i:648;s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:100;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:504;a:16:{s:4:\"tmpl\";i:642;s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:346;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:505;a:16:{s:4:\"tmpl\";i:637;s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:83;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:506;a:16:{s:4:\"tmpl\";i:638;s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"Footer\"]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:147;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:507;a:16:{s:4:\"tmpl\";i:888;s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:769;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:508;a:16:{s:4:\"tmpl\";i:887;s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:507;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:509;a:16:{s:4:\"tmpl\";i:886;s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:479;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:510;a:16:{s:4:\"tmpl\";i:885;s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"Footer\",\"Gym\"]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:331;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:511;a:16:{s:4:\"tmpl\";i:884;s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"Header\"]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:135;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:512;a:16:{s:4:\"tmpl\";i:635;s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:17;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:513;a:16:{s:4:\"tmpl\";i:663;s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:14;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:514;a:16:{s:4:\"tmpl\";i:658;s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:103;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:515;a:16:{s:4:\"tmpl\";i:657;s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:75;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:516;a:16:{s:4:\"tmpl\";i:694;s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:58;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:517;a:16:{s:4:\"tmpl\";i:636;s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"Header\"]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:33;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:518;a:16:{s:4:\"tmpl\";i:665;s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:28;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:519;a:16:{s:4:\"tmpl\";i:659;s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:13;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:520;a:16:{s:4:\"tmpl\";i:660;s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:18;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:521;a:16:{s:4:\"tmpl\";i:666;s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:94;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:522;a:16:{s:4:\"tmpl\";i:664;s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:143;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:523;a:16:{s:4:\"tmpl\";i:661;s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:60;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:524;a:16:{s:4:\"tmpl\";i:662;s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:78;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:525;a:16:{s:4:\"tmpl\";i:572;s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:35;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:526;a:16:{s:4:\"tmpl\";i:528;s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:567;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:527;a:16:{s:4:\"tmpl\";i:527;s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:179;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:528;a:16:{s:4:\"tmpl\";i:479;s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:555;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:529;a:16:{s:4:\"tmpl\";i:573;s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:88;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:530;a:16:{s:4:\"tmpl\";i:569;s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:34;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:531;a:16:{s:4:\"tmpl\";i:571;s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:470;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:532;a:16:{s:4:\"tmpl\";i:570;s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:85;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:533;a:16:{s:4:\"tmpl\";i:568;s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:542;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:534;a:16:{s:4:\"tmpl\";i:530;s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:37;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:535;a:16:{s:4:\"tmpl\";i:531;s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:86;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:536;a:16:{s:4:\"tmpl\";i:529;s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:244;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:537;a:16:{s:4:\"tmpl\";i:978;s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:730;s:11:\"trend_index\";i:795;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:538;a:16:{s:4:\"tmpl\";i:979;s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Business\",\"Footer\",\"interior design\"]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:178;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:539;a:16:{s:4:\"tmpl\";i:980;s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Business\",\"Header\",\"interior design\"]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:64;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:540;a:16:{s:4:\"tmpl\";i:977;s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:132;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:541;a:16:{s:4:\"tmpl\";i:976;s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:108;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:542;a:16:{s:4:\"tmpl\";i:975;s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Business\",\"interior design\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:324;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:543;a:16:{s:4:\"tmpl\";i:1011;s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:647;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:544;a:16:{s:4:\"tmpl\";i:1012;s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"Footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:238;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:545;a:16:{s:4:\"tmpl\";i:1013;s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"Header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:274;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:546;a:16:{s:4:\"tmpl\";i:914;s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:716;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:547;a:16:{s:4:\"tmpl\";i:913;s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:294;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:548;a:16:{s:4:\"tmpl\";i:912;s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:240;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:549;a:16:{s:4:\"tmpl\";i:911;s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:39;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:550;a:16:{s:4:\"tmpl\";i:910;s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:433;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:551;a:16:{s:4:\"tmpl\";i:909;s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:214;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:552;a:16:{s:4:\"tmpl\";i:1022;s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:759;s:11:\"trend_index\";i:720;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:553;a:16:{s:4:\"tmpl\";i:1023;s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Footer\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:505;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:554;a:16:{s:4:\"tmpl\";i:1024;s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Header\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:157;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:555;a:16:{s:4:\"tmpl\";i:1026;s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:420;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:556;a:16:{s:4:\"tmpl\";i:1027;s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:665;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:557;a:16:{s:4:\"tmpl\";i:1025;s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:441;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:558;a:16:{s:4:\"tmpl\";i:950;s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:734;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:559;a:16:{s:4:\"tmpl\";i:949;s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:272;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:560;a:16:{s:4:\"tmpl\";i:946;s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"Footer\",\"Magazine\"]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:349;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:561;a:16:{s:4:\"tmpl\";i:945;s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"Header\",\"Magazine\"]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:197;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:562;a:16:{s:4:\"tmpl\";i:947;s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:509;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:563;a:16:{s:4:\"tmpl\";i:944;s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:175;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:564;a:16:{s:4:\"tmpl\";i:943;s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:129;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:565;a:16:{s:4:\"tmpl\";i:942;s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:246;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:566;a:16:{s:4:\"tmpl\";i:941;s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:489;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:567;a:16:{s:4:\"tmpl\";i:948;s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:232;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:585;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:568;a:16:{s:4:\"tmpl\";i:990;s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:233;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:498;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:569;a:16:{s:4:\"tmpl\";i:987;s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:234;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:408;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:570;a:16:{s:4:\"tmpl\";i:989;s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Footer\"]\";s:10:\"menu_order\";i:235;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:308;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:571;a:16:{s:4:\"tmpl\";i:988;s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"Header\"]\";s:10:\"menu_order\";i:236;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:519;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:572;a:16:{s:4:\"tmpl\";i:986;s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:237;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:578;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:573;a:16:{s:4:\"tmpl\";i:953;s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:238;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:706;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:574;a:16:{s:4:\"tmpl\";i:954;s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:239;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:405;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:575;a:16:{s:4:\"tmpl\";i:955;s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"Footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:240;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:230;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:576;a:16:{s:4:\"tmpl\";i:957;s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"Header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:241;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:205;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:577;a:16:{s:4:\"tmpl\";i:956;s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:242;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:645;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:578;a:16:{s:4:\"tmpl\";i:901;s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:243;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:497;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:579;a:16:{s:4:\"tmpl\";i:900;s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"Footer\",\"portfolio\"]\";s:10:\"menu_order\";i:244;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:102;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:580;a:16:{s:4:\"tmpl\";i:898;s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:245;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:455;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:581;a:16:{s:4:\"tmpl\";i:897;s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:246;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:609;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:582;a:16:{s:4:\"tmpl\";i:904;s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"Header\",\"portfolio\"]\";s:10:\"menu_order\";i:247;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:364;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:583;a:16:{s:4:\"tmpl\";i:896;s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:248;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:764;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:584;a:16:{s:4:\"tmpl\";i:895;s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:249;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:816;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:585;a:16:{s:4:\"tmpl\";i:903;s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:250;s:16:\"popularity_index\";i:733;s:11:\"trend_index\";i:744;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:586;a:16:{s:4:\"tmpl\";i:894;s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:251;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:587;a:16:{s:4:\"tmpl\";i:597;s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:252;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:236;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:588;a:16:{s:4:\"tmpl\";i:609;s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:253;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:478;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:589;a:16:{s:4:\"tmpl\";i:598;s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:254;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:421;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:590;a:16:{s:4:\"tmpl\";i:599;s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:255;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:399;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:591;a:16:{s:4:\"tmpl\";i:600;s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:256;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:288;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:592;a:16:{s:4:\"tmpl\";i:601;s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:257;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:329;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:593;a:16:{s:4:\"tmpl\";i:603;s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:258;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:283;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:594;a:16:{s:4:\"tmpl\";i:604;s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:259;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:211;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:595;a:16:{s:4:\"tmpl\";i:606;s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:260;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:22;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:596;a:16:{s:4:\"tmpl\";i:608;s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:261;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:280;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:597;a:16:{s:4:\"tmpl\";i:610;s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:262;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:635;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:598;a:16:{s:4:\"tmpl\";i:468;s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:263;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:608;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:599;a:16:{s:4:\"tmpl\";i:602;s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:264;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:654;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:600;a:16:{s:4:\"tmpl\";i:605;s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:265;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:347;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:601;a:16:{s:4:\"tmpl\";i:607;s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:266;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:386;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:602;a:16:{s:4:\"tmpl\";i:596;s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:267;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:183;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:603;a:16:{s:4:\"tmpl\";i:434;s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:268;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:641;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:604;a:16:{s:4:\"tmpl\";i:439;s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:269;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:506;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:605;a:16:{s:4:\"tmpl\";i:441;s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:270;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:248;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:606;a:16:{s:4:\"tmpl\";i:442;s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:271;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:526;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:607;a:16:{s:4:\"tmpl\";i:444;s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:272;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:450;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:608;a:16:{s:4:\"tmpl\";i:446;s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:273;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:568;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:609;a:16:{s:4:\"tmpl\";i:436;s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:274;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:613;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:610;a:16:{s:4:\"tmpl\";i:438;s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:275;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:825;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:611;a:16:{s:4:\"tmpl\";i:440;s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:276;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:821;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:612;a:16:{s:4:\"tmpl\";i:443;s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:277;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:639;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:613;a:16:{s:4:\"tmpl\";i:445;s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:278;s:16:\"popularity_index\";i:738;s:11:\"trend_index\";i:773;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:614;a:16:{s:4:\"tmpl\";i:433;s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:279;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:451;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:615;a:16:{s:4:\"tmpl\";i:435;s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:280;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:372;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:616;a:16:{s:4:\"tmpl\";i:437;s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:281;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:841;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:617;a:16:{s:4:\"tmpl\";i:701;s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:282;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:25;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:618;a:16:{s:4:\"tmpl\";i:702;s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:283;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:30;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:619;a:16:{s:4:\"tmpl\";i:703;s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:284;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:44;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:620;a:16:{s:4:\"tmpl\";i:1046;s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:285;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:493;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:621;a:16:{s:4:\"tmpl\";i:1047;s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:286;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:358;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:622;a:16:{s:4:\"tmpl\";i:1048;s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"Footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:287;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:500;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:623;a:16:{s:4:\"tmpl\";i:1049;s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"Header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:288;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:423;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:624;a:16:{s:4:\"tmpl\";i:1050;s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:289;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:570;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:625;a:16:{s:4:\"tmpl\";i:1051;s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:290;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:368;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:626;a:16:{s:4:\"tmpl\";i:412;s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:291;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:53;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:627;a:16:{s:4:\"tmpl\";i:413;s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:292;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:138;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:628;a:16:{s:4:\"tmpl\";i:418;s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:293;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:59;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:629;a:16:{s:4:\"tmpl\";i:420;s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:294;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:120;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:630;a:16:{s:4:\"tmpl\";i:403;s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:295;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:172;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:631;a:16:{s:4:\"tmpl\";i:417;s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:296;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:45;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:632;a:16:{s:4:\"tmpl\";i:415;s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:297;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:114;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:633;a:16:{s:4:\"tmpl\";i:414;s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:298;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:149;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:634;a:16:{s:4:\"tmpl\";i:401;s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:299;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:302;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:635;a:16:{s:4:\"tmpl\";i:408;s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:300;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:514;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:636;a:16:{s:4:\"tmpl\";i:406;s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:301;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:209;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:637;a:16:{s:4:\"tmpl\";i:404;s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:302;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:596;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:638;a:16:{s:4:\"tmpl\";i:421;s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:303;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:438;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:639;a:16:{s:4:\"tmpl\";i:419;s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:304;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:249;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:640;a:16:{s:4:\"tmpl\";i:416;s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:305;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:483;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:641;a:16:{s:4:\"tmpl\";i:402;s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:306;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:553;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:642;a:16:{s:4:\"tmpl\";i:560;s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:307;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:550;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:643;a:16:{s:4:\"tmpl\";i:411;s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:308;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:97;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:644;a:16:{s:4:\"tmpl\";i:410;s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:309;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:269;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:645;a:16:{s:4:\"tmpl\";i:409;s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:310;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:21;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:646;a:16:{s:4:\"tmpl\";i:407;s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:311;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:213;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:647;a:16:{s:4:\"tmpl\";i:405;s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:312;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:99;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:648;a:16:{s:4:\"tmpl\";i:677;s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:313;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:145;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:649;a:16:{s:4:\"tmpl\";i:678;s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:314;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:82;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:650;a:16:{s:4:\"tmpl\";i:679;s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:315;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:23;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:651;a:16:{s:4:\"tmpl\";i:680;s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:316;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:190;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:652;a:16:{s:4:\"tmpl\";i:681;s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:317;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:218;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:653;a:16:{s:4:\"tmpl\";i:682;s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:318;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:227;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:654;a:16:{s:4:\"tmpl\";i:683;s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:319;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:316;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:655;a:16:{s:4:\"tmpl\";i:640;s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:320;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:266;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:656;a:16:{s:4:\"tmpl\";i:639;s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:321;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:139;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:657;a:16:{s:4:\"tmpl\";i:705;s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:322;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:204;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:658;a:16:{s:4:\"tmpl\";i:704;s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:323;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:336;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:659;a:16:{s:4:\"tmpl\";i:706;s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:324;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:177;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:660;a:16:{s:4:\"tmpl\";i:707;s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:325;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:279;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:661;a:16:{s:4:\"tmpl\";i:708;s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:326;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:253;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:662;a:16:{s:4:\"tmpl\";i:697;s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:327;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:6;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:663;a:16:{s:4:\"tmpl\";i:698;s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:328;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:42;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:664;a:16:{s:4:\"tmpl\";i:699;s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:329;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:66;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:665;a:16:{s:4:\"tmpl\";i:700;s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:330;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:81;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:666;a:16:{s:4:\"tmpl\";i:555;s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:331;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:692;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:667;a:16:{s:4:\"tmpl\";i:562;s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:332;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:755;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:668;a:16:{s:4:\"tmpl\";i:561;s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:333;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:552;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:669;a:16:{s:4:\"tmpl\";i:563;s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:334;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:811;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:670;a:16:{s:4:\"tmpl\";i:550;s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:335;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:328;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:671;a:16:{s:4:\"tmpl\";i:554;s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:336;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:784;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:672;a:16:{s:4:\"tmpl\";i:551;s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:337;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:385;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:673;a:16:{s:4:\"tmpl\";i:552;s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:338;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:452;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:674;a:16:{s:4:\"tmpl\";i:549;s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:339;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:419;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:675;a:16:{s:4:\"tmpl\";i:553;s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:340;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:492;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:676;a:16:{s:4:\"tmpl\";i:538;s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:341;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:541;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:677;a:16:{s:4:\"tmpl\";i:537;s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:342;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:531;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:678;a:16:{s:4:\"tmpl\";i:559;s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:343;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:557;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:679;a:16:{s:4:\"tmpl\";i:469;s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:344;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:293;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:680;a:16:{s:4:\"tmpl\";i:472;s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:345;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:340;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:681;a:16:{s:4:\"tmpl\";i:470;s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:346;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:620;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:682;a:16:{s:4:\"tmpl\";i:477;s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:347;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:427;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:683;a:16:{s:4:\"tmpl\";i:471;s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:348;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:237;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:684;a:16:{s:4:\"tmpl\";i:465;s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:349;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:188;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:685;a:16:{s:4:\"tmpl\";i:462;s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:350;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:488;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:686;a:16:{s:4:\"tmpl\";i:458;s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:351;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:345;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:687;a:16:{s:4:\"tmpl\";i:543;s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:352;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:318;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:688;a:16:{s:4:\"tmpl\";i:455;s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:353;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:410;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:689;a:16:{s:4:\"tmpl\";i:463;s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:354;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:330;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:690;a:16:{s:4:\"tmpl\";i:558;s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:355;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:365;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:691;a:16:{s:4:\"tmpl\";i:464;s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:356;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:173;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:692;a:16:{s:4:\"tmpl\";i:466;s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:357;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:465;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:693;a:16:{s:4:\"tmpl\";i:459;s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:358;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:159;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:694;a:16:{s:4:\"tmpl\";i:467;s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:359;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:606;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:695;a:16:{s:4:\"tmpl\";i:461;s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:360;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:376;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:696;a:16:{s:4:\"tmpl\";i:460;s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:361;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:378;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:697;a:16:{s:4:\"tmpl\";i:457;s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:362;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:359;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:698;a:16:{s:4:\"tmpl\";i:456;s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:363;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:299;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:699;a:16:{s:4:\"tmpl\";i:544;s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:364;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:277;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:700;a:16:{s:4:\"tmpl\";i:454;s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:365;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:402;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:701;a:16:{s:4:\"tmpl\";i:586;s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:366;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:198;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:702;a:16:{s:4:\"tmpl\";i:582;s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:367;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:522;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:703;a:16:{s:4:\"tmpl\";i:580;s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:368;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:391;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:704;a:16:{s:4:\"tmpl\";i:578;s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:369;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:741;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:705;a:16:{s:4:\"tmpl\";i:595;s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:370;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:411;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:706;a:16:{s:4:\"tmpl\";i:593;s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:371;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:544;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:707;a:16:{s:4:\"tmpl\";i:576;s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:372;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:401;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:708;a:16:{s:4:\"tmpl\";i:594;s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:373;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:199;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:709;a:16:{s:4:\"tmpl\";i:577;s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:374;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:780;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:710;a:16:{s:4:\"tmpl\";i:579;s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:375;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:599;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:711;a:16:{s:4:\"tmpl\";i:581;s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:376;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:653;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:712;a:16:{s:4:\"tmpl\";i:583;s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:377;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:289;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:713;a:16:{s:4:\"tmpl\";i:584;s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:378;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:221;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:714;a:16:{s:4:\"tmpl\";i:585;s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:379;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:566;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:715;a:16:{s:4:\"tmpl\";i:575;s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:380;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:395;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:716;a:16:{s:4:\"tmpl\";i:587;s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:381;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:206;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:717;a:16:{s:4:\"tmpl\";i:591;s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:382;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:546;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:718;a:16:{s:4:\"tmpl\";i:592;s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:383;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:718;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:719;a:16:{s:4:\"tmpl\";i:589;s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:384;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:496;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:720;a:16:{s:4:\"tmpl\";i:590;s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:385;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:695;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:721;a:16:{s:4:\"tmpl\";i:588;s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:386;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:341;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:722;a:16:{s:4:\"tmpl\";i:928;s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:387;s:16:\"popularity_index\";i:747;s:11:\"trend_index\";i:712;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:723;a:16:{s:4:\"tmpl\";i:929;s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:388;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:487;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:724;a:16:{s:4:\"tmpl\";i:927;s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"Header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:389;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:434;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:725;a:16:{s:4:\"tmpl\";i:930;s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:390;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:663;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:726;a:16:{s:4:\"tmpl\";i:931;s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:391;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:548;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:727;a:16:{s:4:\"tmpl\";i:926;s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"Footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:392;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:322;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:728;a:16:{s:4:\"tmpl\";i:1068;s:2:\"id\";i:15498;s:5:\"title\";s:23:\"Travel Blog &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg\";s:12:\"tmpl_created\";i:1606215636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/travel-blog-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:23:\"[\"404\",\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:393;s:16:\"popularity_index\";i:749;s:11:\"trend_index\";i:759;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:729;a:16:{s:4:\"tmpl\";i:1069;s:2:\"id\";i:15508;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg\";s:12:\"tmpl_created\";i:1606215649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:394;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:468;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:730;a:16:{s:4:\"tmpl\";i:1070;s:2:\"id\";i:15518;s:5:\"title\";s:29:\"Travel Blog &#8211; Archive 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg\";s:12:\"tmpl_created\";i:1606215663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:395;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:431;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:731;a:16:{s:4:\"tmpl\";i:1071;s:2:\"id\";i:15528;s:5:\"title\";s:26:\"Travel Blog &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg\";s:12:\"tmpl_created\";i:1606215673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:26:\"[\"Blog\",\"Footer\",\"Travel\"]\";s:10:\"menu_order\";i:396;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:377;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:732;a:16:{s:4:\"tmpl\";i:1067;s:2:\"id\";i:15536;s:5:\"title\";s:26:\"Travel Blog &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg\";s:12:\"tmpl_created\";i:1606215625;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-blog-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:26:\"[\"Blog\",\"Header\",\"Travel\"]\";s:10:\"menu_order\";i:397;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:228;s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:733;a:16:{s:4:\"tmpl\";i:1072;s:2:\"id\";i:15545;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg\";s:12:\"tmpl_created\";i:1606215684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:398;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:482;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:734;a:16:{s:4:\"tmpl\";i:1066;s:2:\"id\";i:15556;s:5:\"title\";s:33:\"Travel Blog &#8211; Single Post 2\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg\";s:12:\"tmpl_created\";i:1606215613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:399;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:454;s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "no");
INSERT INTO `theme_options` VALUES("3280", "widget_mihanmarketpostswidget", "a:3:{i:2;a:1:{s:5:\"title\";s:23:\"آخرین مقالات\";}i:3;a:1:{s:5:\"title\";s:23:\"آخرین مقالات\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("2969", "wpsh_pro_license_status", "0", "yes");
INSERT INTO `theme_options` VALUES("2706", "wpseo_taxonomy_meta", "a:1:{s:11:\"product_cat\";a:9:{i:55;a:3:{s:13:\"wpseo_focuskw\";s:14:\"شیائومی\";s:13:\"wpseo_linkdex\";s:2:\"62\";s:19:\"wpseo_content_score\";s:2:\"90\";}i:117;a:3:{s:13:\"wpseo_focuskw\";s:23:\"پیشنهاد ویژه\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:27;a:3:{s:13:\"wpseo_focuskw\";s:35:\"خودرو و لوازم جانبی\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:21;a:3:{s:13:\"wpseo_focuskw\";s:26:\"زیبایی و سلامت\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:22;a:3:{s:13:\"wpseo_focuskw\";s:32:\"کتاب، لوازم تحریر\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:19;a:3:{s:13:\"wpseo_focuskw\";s:21:\"لوازم خانگی\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:18;a:3:{s:13:\"wpseo_focuskw\";s:25:\"لوازم دیجیتال\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:20;a:3:{s:13:\"wpseo_focuskw\";s:18:\"مد و پوشاک\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:15;a:3:{s:13:\"wpseo_focuskw\";s:28:\"بدون دسته‌بندی\";s:13:\"wpseo_linkdex\";s:2:\"32\";s:19:\"wpseo_content_score\";s:1:\"0\";}}}", "yes");
INSERT INTO `theme_options` VALUES("385", "elementor_version", "3.5.5", "yes");
INSERT INTO `theme_options` VALUES("153", "current_theme", "Shopino Theme", "yes");
INSERT INTO `theme_options` VALUES("154", "theme_switched", "", "yes");
INSERT INTO `theme_options` VALUES("143", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:33:\"amirmohammadkazemaslani@yahoo.com\";s:7:\"version\";s:5:\"5.8.3\";s:9:\"timestamp\";i:1641504132;}", "no");
INSERT INTO `theme_options` VALUES("146", "recently_activated", "a:2:{s:33:\"wps-hide-login/wps-hide-login.php\";i:1645363007;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1645085036;}", "yes");
INSERT INTO `theme_options` VALUES("10963", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("184", "woocommerce_schema_version", "430", "yes");
INSERT INTO `theme_options` VALUES("185", "woocommerce_store_address", "الیگودرز", "yes");
INSERT INTO `theme_options` VALUES("186", "woocommerce_store_address_2", "", "yes");
INSERT INTO `theme_options` VALUES("151", "theme_mods_theme", "a:52:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:9:\"mega-menu\";i:51;s:8:\"top-menu\";i:93;}s:8:\"off-text\";s:136:\"یک فرصت استثنایی خرید از سایت | ۵۰% تخفیف روی تمامی محصولات تا پایان تابستان\";s:9:\"instalink\";s:29:\"http://instagram.com/yourpage\";s:20:\"background-megamenu1\";s:59:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1.jpg\";s:12:\"insta-active\";b:1;s:15:\"whatsapp-active\";b:1;s:15:\"telegram-active\";b:1;s:14:\"youtube-active\";b:1;s:13:\"aparat-active\";b:1;s:12:\"whatsap-link\";s:25:\"http://wa.me/989012345678\";s:19:\"whatsap-description\";s:138:\"در صورت بروز هرگونه مشکل و یا داشتن سوال، در واتساپ پاسخگوی شما عزیزان هستیم\";s:13:\"telegram-link\";s:18:\"http://t.me/yourid\";s:20:\"telegram-description\";s:12:\"تلگرام\";s:12:\"youtube-link\";s:1:\"#\";s:19:\"youtube-description\";s:12:\"یوتیوب\";s:11:\"aparat-link\";s:1:\"#\";s:18:\"aparat-description\";s:12:\"آپارات\";s:17:\"insta-description\";s:86:\"با دنبال کردن پیج ما از کد های تخفیف بهرمند شوید\";s:4:\"logo\";s:60:\"https://instabotapp.ir/wp-content/uploads/2021/08/logo-1.jpg\";s:4:\"tell\";s:22:\"۰۹۰۱۲۳۴۵۶۷۸\";s:20:\"background-megamenu2\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-1.jpg\";s:20:\"background-megamenu3\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-2.jpg\";s:20:\"background-megamenu4\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-3.jpg\";s:20:\"background-megamenu5\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-4.jpg\";s:20:\"background-megamenu6\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-5.jpg\";s:20:\"background-megamenu7\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-6.jpg\";s:20:\"background-megamenu8\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-7.jpg\";s:20:\"background-megamenu9\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-8.jpg\";s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1632221330;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"mihan_footer_widget\";a:4:{i:0;s:6:\"text-3\";i:1;s:19:\"mc4wp_form_widget-2\";i:2;s:10:\"nav_menu-2\";i:3;s:6:\"text-2\";}s:26:\"mihan_bottom_footer_widget\";a:1:{i:0;s:13:\"custom_html-2\";}s:20:\"mihan_sidebar_widget\";a:4:{i:0;s:8:\"search-2\";i:1;s:24:\"mihanmarketpostswidget-2\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";}s:22:\"mihan_sidebar_widget_2\";a:3:{i:0;s:19:\"mc4wp_form_widget-3\";i:1;s:8:\"search-3\";i:2;s:32:\"woocommerce_product_categories-2\";}}}s:13:\"wishlist-icon\";b:1;s:11:\"go-top-icon\";b:1;s:15:\"float-cart-icon\";b:1;s:18:\"float-product-info\";b:1;s:13:\"company-color\";s:7:\"#00a2c6\";s:19:\"tags-product-active\";b:1;s:23:\"category-product-active\";b:1;s:12:\"date-article\";b:1;s:18:\"theme-color-chrome\";s:7:\"#bc0096\";s:19:\"float-header-active\";b:1;s:24:\"date-article-single-page\";b:1;s:18:\"author-single-page\";b:1;s:20:\"category-single-page\";b:1;s:16:\"tags-single-page\";b:1;s:17:\"share-single-page\";b:1;s:17:\"top-footer-item-1\";s:19:\"ارسال سریع\";s:17:\"top-footer-item-2\";s:19:\"بازگشت وجه\";s:17:\"top-footer-item-3\";s:25:\"پشتیبانی عالی\";s:17:\"top-footer-item-4\";s:19:\"تضمین قیمت\";s:17:\"top-footer-item-5\";s:19:\"اصالت کالا\";s:24:\"side-bar-archive-product\";b:1;s:21:\"background-megamenu10\";s:60:\"https://instabotapp.ir/wp-content/uploads/2021/09/benner.jpg\";}", "yes");
INSERT INTO `theme_options` VALUES("160", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("187", "woocommerce_store_city", "الیگودرز", "yes");
INSERT INTO `theme_options` VALUES("188", "woocommerce_default_country", "IR:LRS", "yes");
INSERT INTO `theme_options` VALUES("189", "woocommerce_store_postcode", "6861763569", "yes");
INSERT INTO `theme_options` VALUES("190", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `theme_options` VALUES("191", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("192", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("193", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `theme_options` VALUES("194", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("195", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `theme_options` VALUES("196", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `theme_options` VALUES("197", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `theme_options` VALUES("198", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `theme_options` VALUES("199", "woocommerce_currency", "IRT", "yes");
INSERT INTO `theme_options` VALUES("200", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `theme_options` VALUES("201", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `theme_options` VALUES("202", "woocommerce_price_decimal_sep", "", "yes");
INSERT INTO `theme_options` VALUES("203", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `theme_options` VALUES("204", "woocommerce_shop_page_id", "8", "yes");
INSERT INTO `theme_options` VALUES("205", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `theme_options` VALUES("206", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `theme_options` VALUES("207", "woocommerce_placeholder_image", "7", "yes");
INSERT INTO `theme_options` VALUES("208", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `theme_options` VALUES("209", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `theme_options` VALUES("210", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `theme_options` VALUES("211", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `theme_options` VALUES("212", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `theme_options` VALUES("213", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `theme_options` VALUES("214", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `theme_options` VALUES("215", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `theme_options` VALUES("216", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `theme_options` VALUES("217", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `theme_options` VALUES("218", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `theme_options` VALUES("219", "woocommerce_stock_email_recipient", "amirmohammadkazemaslani@yahoo.com", "no");
INSERT INTO `theme_options` VALUES("220", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `theme_options` VALUES("221", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `theme_options` VALUES("222", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `theme_options` VALUES("223", "woocommerce_stock_format", "", "yes");
INSERT INTO `theme_options` VALUES("224", "woocommerce_file_download_method", "force", "no");
INSERT INTO `theme_options` VALUES("225", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `theme_options` VALUES("226", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `theme_options` VALUES("227", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `theme_options` VALUES("228", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `theme_options` VALUES("229", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `theme_options` VALUES("230", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `theme_options` VALUES("231", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `theme_options` VALUES("232", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `theme_options` VALUES("233", "woocommerce_tax_classes", "", "yes");
INSERT INTO `theme_options` VALUES("234", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `theme_options` VALUES("235", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `theme_options` VALUES("236", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `theme_options` VALUES("237", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `theme_options` VALUES("238", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `theme_options` VALUES("239", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `theme_options` VALUES("240", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `theme_options` VALUES("241", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `theme_options` VALUES("242", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `theme_options` VALUES("243", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `theme_options` VALUES("244", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `theme_options` VALUES("245", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `theme_options` VALUES("246", "woocommerce_registration_generate_username", "no", "no");
INSERT INTO `theme_options` VALUES("247", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `theme_options` VALUES("248", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `theme_options` VALUES("249", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `theme_options` VALUES("250", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `theme_options` VALUES("251", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `theme_options` VALUES("252", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما و پشتیبانی از تجربه شما در این وبسایت و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است استفاده می‌شود.", "yes");
INSERT INTO `theme_options` VALUES("253", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `theme_options` VALUES("254", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `theme_options` VALUES("255", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `theme_options` VALUES("256", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `theme_options` VALUES("257", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `theme_options` VALUES("258", "woocommerce_email_from_name", "دیجیکالا", "no");
INSERT INTO `theme_options` VALUES("259", "woocommerce_email_from_address", "amirmohammadkazemaslani@yahoo.com", "no");
INSERT INTO `theme_options` VALUES("260", "woocommerce_email_header_image", "", "no");
INSERT INTO `theme_options` VALUES("261", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `theme_options` VALUES("262", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `theme_options` VALUES("263", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `theme_options` VALUES("264", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `theme_options` VALUES("265", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `theme_options` VALUES("266", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `theme_options` VALUES("267", "woocommerce_cart_page_id", "9", "no");
INSERT INTO `theme_options` VALUES("268", "woocommerce_checkout_page_id", "10", "no");
INSERT INTO `theme_options` VALUES("269", "woocommerce_myaccount_page_id", "11", "no");
INSERT INTO `theme_options` VALUES("270", "woocommerce_terms_page_id", "", "no");
INSERT INTO `theme_options` VALUES("271", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `theme_options` VALUES("272", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `theme_options` VALUES("273", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `theme_options` VALUES("274", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `theme_options` VALUES("275", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `theme_options` VALUES("276", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `theme_options` VALUES("277", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `theme_options` VALUES("278", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `theme_options` VALUES("279", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `theme_options` VALUES("280", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `theme_options` VALUES("281", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `theme_options` VALUES("282", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `theme_options` VALUES("283", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `theme_options` VALUES("284", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `theme_options` VALUES("285", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `theme_options` VALUES("286", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `theme_options` VALUES("287", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `theme_options` VALUES("288", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `theme_options` VALUES("289", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `theme_options` VALUES("290", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `theme_options` VALUES("291", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `theme_options` VALUES("292", "woocommerce_demo_store", "no", "no");
INSERT INTO `theme_options` VALUES("293", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("294", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `theme_options` VALUES("295", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `theme_options` VALUES("7965", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `theme_options` VALUES("298", "default_product_cat", "15", "yes");
INSERT INTO `theme_options` VALUES("338", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("302", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:33:\"amirmohammadkazemaslani@yahoo.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:33:\"amirmohammadkazemaslani@yahoo.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `theme_options` VALUES("303", "woocommerce_version", "6.2.0", "yes");
INSERT INTO `theme_options` VALUES("304", "woocommerce_db_version", "6.2.0", "yes");
INSERT INTO `theme_options` VALUES("305", "woocommerce_inbox_variant_assignment", "2", "yes");
INSERT INTO `theme_options` VALUES("312", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"SSGelSpK2AnBBqLm2LSBlNXDIu1SfOr1\";}", "yes");
INSERT INTO `theme_options` VALUES("309", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `theme_options` VALUES("310", "action_scheduler_lock_async-request-runner", "1645364006", "yes");
INSERT INTO `theme_options` VALUES("311", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("313", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("314", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("315", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("316", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("317", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("318", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("319", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("320", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("321", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("322", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("323", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("324", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("325", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("329", "woocommerce_admin_install_timestamp", "1628194035", "yes");
INSERT INTO `theme_options` VALUES("330", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `theme_options` VALUES("331", "wc_remote_inbox_notifications_specs", "a:30:{s:27:\"stripe_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"stripe_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:380:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/stripe/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#apple-pay\">enable Apple Pay with Stripe</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"stripe_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}s:27:\"square_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"square_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:393:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/woocommerce-square/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#section-14\">enable Apple Pay with Square</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"square_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}}}s:26:\"wcpay_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"wcpay_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:338:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/payments/apple-pay/\">enable Apple Pay with WooCommerce Payments</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"wcpay_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:15:\"&page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:259:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store\'s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:45:\"https://woocommerce.com/woocommerce-shipping/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:31:\"https://woocommerce.com/mobile/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:736:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site\'s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:5:\"rules\";a:0:{}}s:30:\"wcpay-promo-2021-6-incentive-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"get-woo-commerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"1\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"3\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"5\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"7\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"9\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"11\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:30:\"wcpay-promo-2021-6-incentive-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-2\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"get-woocommerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"2\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"4\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"6\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"8\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"10\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"12\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:440:\"Heads up! There\'s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:513:\"We\'ve developed a whole new <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension for WooCommerce</a> that combines the best features of our many PayPal extensions into just one extension.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br/><br/>Start using our latest PayPal today to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:38:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"We\'re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:134:\"We\'d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}}", "no");
INSERT INTO `theme_options` VALUES("332", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `theme_options` VALUES("337", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `theme_options` VALUES("343", "_transient_woocommerce_reports-transient-version", "1645362576", "yes");
INSERT INTO `theme_options` VALUES("82842", "category_children", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("353", "woocommerce_onboarding_profile", "a:8:{s:12:\"setup_client\";b:0;s:8:\"industry\";a:6:{i:0;a:1:{s:4:\"slug\";s:27:\"fashion-apparel-accessories\";}i:1;a:1:{s:4:\"slug\";s:13:\"health-beauty\";}i:2;a:1:{s:4:\"slug\";s:21:\"electronics-computers\";}i:3;a:1:{s:4:\"slug\";s:10:\"food-drink\";}i:4;a:1:{s:4:\"slug\";s:21:\"home-furniture-garden\";}i:5;a:1:{s:4:\"slug\";s:22:\"education-and-learning\";}}s:13:\"product_types\";a:1:{i:0;s:8:\"physical\";}s:13:\"product_count\";s:5:\"1000+\";s:14:\"selling_venues\";s:2:\"no\";s:19:\"business_extensions\";a:0:{}s:5:\"theme\";s:5:\"theme\";s:9:\"completed\";b:1;}", "yes");
INSERT INTO `theme_options` VALUES("364", "woocommerce_task_list_tracked_completed_tasks", "a:2:{i:0;s:13:\"store_details\";i:1;s:8:\"products\";}", "yes");
INSERT INTO `theme_options` VALUES("365", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `theme_options` VALUES("369", "_transient_shipping-transient-version", "1628194187", "yes");
INSERT INTO `theme_options` VALUES("446", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:1;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.2.3\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:0;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("447", "rsssl_remaining_tasks", "1", "yes");
INSERT INTO `theme_options` VALUES("485", "rsssl_activation_timestamp", "1628196030", "yes");
INSERT INTO `theme_options` VALUES("454", "rsssl_current_version", "5.2.3", "yes");
INSERT INTO `theme_options` VALUES("386", "elementor_install_history", "a:3:{s:5:\"3.3.1\";i:1628194298;s:5:\"3.5.2\";i:1640449367;s:5:\"3.5.5\";i:1645362548;}", "yes");
INSERT INTO `theme_options` VALUES("390", "elementor_remote_info_feed_data", "a:5:{i:0;a:5:{s:5:\"title\";s:34:\"Elementor Websites of January 2022\";s:7:\"excerpt\";s:235:\"Showcasing many of the trends we recently predicted for 2022, January’s showcase offers an intriguing list of websites that weave together a journey that delights the eyes, warms the heart, sparks the imagination, and blows the mind.\";s:7:\"created\";i:1644798900;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:121:\"https://elementor.com/blog/showcase-january-2022/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:80:\"How Ongage Optimized Their Elementor-Based Website and Boosted Its Speed by 110%\";s:7:\"excerpt\";s:221:\"\"We wanted to make a pixel-perfect website that perfectly conveyed our brand\" — learn how Ongage, a full-stack email marketing platform, used Elementor to redesign their website and improve its performance dramatically.\";s:7:\"created\";i:1644321663;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:116:\"https://elementor.com/blog/ongage-casestudy/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:59:\"Expert Web Creators of the Month: One Form to Rule Them All\";s:7:\"excerpt\";s:156:\" We challenged you to create snazzy contact forms, enticing newsletter signups, and delightful multi-step experiences —  see which web creators stood out.\";s:7:\"created\";i:1644219143;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:138:\"https://elementor.com/blog/expert-web-creators-of-the-month-forms/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:55:\"Capture Hearts and Sales With Our Valentine’s Day Kit\";s:7:\"excerpt\";s:185:\"Our new Valentine\'s Day Kit is full of wonderful landing pages, sections, popups, and vector assets to help you quickly get your website ready for the most romantic holiday of the year.\";s:7:\"created\";i:1642422001;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:118:\"https://elementor.com/blog/valentines-day-kit/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:55:\"How To Create a Content Marketing Strategy From Scratch\";s:7:\"excerpt\";s:208:\"A clear content strategy is crucial to stand out and drive business results in an increasingly saturated marketplace. In this guide, we\'ll walk you through the steps of creating a successful content strategy.\";s:7:\"created\";i:1642091419;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:126:\"https://elementor.com/blog/content-marketing-strategy/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "no");
INSERT INTO `theme_options` VALUES("398", "_transient_product_query-transient-version", "1645092279", "yes");
INSERT INTO `theme_options` VALUES("399", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `theme_options` VALUES("402", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `theme_options` VALUES("445", "rsssl_activated_plugin", "1", "yes");
INSERT INTO `theme_options` VALUES("424", "wpp_settings", "a:18:{s:10:\"admin_lang\";s:7:\"disable\";s:9:\"user_lang\";s:7:\"disable\";s:12:\"submenu_move\";s:7:\"disable\";s:12:\"persian_date\";s:6:\"enable\";s:10:\"conv_title\";s:7:\"disable\";s:13:\"conv_contents\";s:7:\"disable\";s:12:\"conv_excerpt\";s:7:\"disable\";s:13:\"conv_comments\";s:7:\"disable\";s:18:\"conv_comment_count\";s:7:\"disable\";s:10:\"conv_dates\";s:7:\"disable\";s:9:\"conv_cats\";s:7:\"disable\";s:11:\"conv_arabic\";s:7:\"disable\";s:15:\"conv_permalinks\";s:7:\"disable\";s:11:\"news_source\";s:5:\"parsi\";s:13:\"woo_per_price\";s:6:\"enable\";s:10:\"edd_prices\";s:6:\"enable\";s:12:\"edd_rial_fix\";s:7:\"disable\";s:9:\"dis_input\";s:0:\"\";}", "yes");
INSERT INTO `theme_options` VALUES("425", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("426", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("484", "https_migration_required", "", "yes");
INSERT INTO `theme_options` VALUES("630", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"18.1\";}", "yes");
INSERT INTO `theme_options` VALUES("631", "wpseo", "a:56:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:0;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:4:\"18.1\";s:16:\"previous_version\";s:4:\"17.8\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1628235996;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:22:\"https://instabotapp.ir\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:9:{s:22:\"elementor_library_type\";s:22:\"elementor_library_type\";s:26:\"elementor_library_category\";s:26:\"elementor_library_category\";s:12:\"product_type\";s:12:\"product_type\";s:18:\"product_visibility\";s:18:\"product_visibility\";s:11:\"product_cat\";s:16:\"product-category\";s:11:\"product_tag\";s:11:\"product-tag\";s:22:\"product_shipping_class\";s:22:\"product_shipping_class\";s:8:\"pa_color\";s:8:\"pa_color\";s:13:\"pa_حافظه\";s:13:\"pa_حافظه\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:36:\"dismiss_configuration_workout_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("632", "wpseo_titles", "a:175:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:51:\"%%name%%, نویسنده در %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:84:\"شما برای %%searchphrase%% جستجو کردید %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"صفحه پیدا نشد %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:79:\"نوشته %%POSTLINK%% اولین بار در %%BLOGLINK%%. پدیدار شد.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:38:\"خطای 404: صفحه پیدا نشد\";s:29:\"breadcrumbs-display-blog-page\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:30:\"بایگانی‌ها برای\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:8:\"خانه\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:39:\"شما جستجو نمودید برای\";s:15:\"breadcrumbs-sep\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";s:8:\"category\";s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";s:1:\"0\";s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";s:1:\"0\";s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:38:\"بایگانی‌های %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:20:\"title-e-landing-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-e-landing-page\";s:0:\"\";s:22:\"noindex-e-landing-page\";b:0;s:33:\"display-metabox-pt-e-landing-page\";b:1;s:33:\"post_types-e-landing-page-maintax\";i:0;s:31:\"schema-page-type-e-landing-page\";s:7:\"WebPage\";s:34:\"schema-article-type-e-landing-page\";s:4:\"None\";s:27:\"social-title-e-landing-page\";s:9:\"%%title%%\";s:33:\"social-description-e-landing-page\";s:0:\"\";s:31:\"social-image-url-e-landing-page\";s:0:\"\";s:30:\"social-image-id-e-landing-page\";i:0;s:23:\"title-elementor_library\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-elementor_library\";s:0:\"\";s:25:\"noindex-elementor_library\";b:0;s:36:\"display-metabox-pt-elementor_library\";b:1;s:36:\"post_types-elementor_library-maintax\";i:0;s:34:\"schema-page-type-elementor_library\";s:7:\"WebPage\";s:37:\"schema-article-type-elementor_library\";s:4:\"None\";s:30:\"social-title-elementor_library\";s:9:\"%%title%%\";s:36:\"social-description-elementor_library\";s:0:\"\";s:34:\"social-image-url-elementor_library\";s:0:\"\";s:33:\"social-image-id-elementor_library\";i:0;s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:26:\"display-metabox-pt-product\";b:1;s:26:\"post_types-product-maintax\";s:11:\"product_cat\";s:24:\"schema-page-type-product\";s:7:\"WebPage\";s:27:\"schema-article-type-product\";s:4:\"None\";s:20:\"social-title-product\";s:9:\"%%title%%\";s:26:\"social-description-product\";s:0:\"\";s:24:\"social-image-url-product\";s:0:\"\";s:23:\"social-image-id-product\";i:0;s:23:\"title-ptarchive-product\";s:58:\"بایگانی %%pt_plural%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-product\";s:0:\"\";s:25:\"bctitle-ptarchive-product\";s:0:\"\";s:25:\"noindex-ptarchive-product\";b:0;s:30:\"social-title-ptarchive-product\";s:28:\"بایگانی %%pt_plural%%\";s:36:\"social-description-ptarchive-product\";s:0:\"\";s:34:\"social-image-url-ptarchive-product\";s:0:\"\";s:33:\"social-image-id-ptarchive-product\";i:0;s:21:\"title-tax-product_cat\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:31:\"display-metabox-tax-product_cat\";b:1;s:23:\"noindex-tax-product_cat\";b:0;s:28:\"social-title-tax-product_cat\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-product_cat\";s:0:\"\";s:32:\"social-image-url-tax-product_cat\";s:0:\"\";s:31:\"social-image-id-tax-product_cat\";i:0;s:29:\"taxonomy-product_cat-ptparent\";s:7:\"product\";s:21:\"title-tax-product_tag\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:31:\"display-metabox-tax-product_tag\";b:1;s:23:\"noindex-tax-product_tag\";b:0;s:28:\"social-title-tax-product_tag\";s:38:\"بایگانی‌های %%term_title%%\";s:34:\"social-description-tax-product_tag\";s:0:\"\";s:32:\"social-image-url-tax-product_tag\";s:0:\"\";s:31:\"social-image-id-tax-product_tag\";i:0;s:29:\"taxonomy-product_tag-ptparent\";s:7:\"product\";s:32:\"title-tax-product_shipping_class\";s:68:\"بایگانی‌های %%term_title%% %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:42:\"display-metabox-tax-product_shipping_class\";b:1;s:34:\"noindex-tax-product_shipping_class\";b:0;s:39:\"social-title-tax-product_shipping_class\";s:38:\"بایگانی‌های %%term_title%%\";s:45:\"social-description-tax-product_shipping_class\";s:0:\"\";s:43:\"social-image-url-tax-product_shipping_class\";s:0:\"\";s:42:\"social-image-id-tax-product_shipping_class\";i:0;s:40:\"taxonomy-product_shipping_class-ptparent\";s:7:\"product\";s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:29:\"open_graph_frontpage_image_id\";i:0;s:26:\"taxonomy-category-ptparent\";s:7:\"product\";s:26:\"taxonomy-post_tag-ptparent\";s:7:\"product\";s:29:\"taxonomy-post_format-ptparent\";s:7:\"product\";}", "yes");
INSERT INTO `theme_options` VALUES("633", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `theme_options` VALUES("678", "rsssl_google_analytics_dismissed", "1", "yes");
INSERT INTO `theme_options` VALUES("683", "rsssl_check_redirect_dismissed", "1", "yes");
INSERT INTO `theme_options` VALUES("649", "wpseo_ryte", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1645363578;}", "yes");
INSERT INTO `theme_options` VALUES("673", "rsssl_mixed_content_scan_dismissed", "1", "yes");
INSERT INTO `theme_options` VALUES("688", "rsssl_secure_cookies_set_dismissed", "1", "yes");
INSERT INTO `theme_options` VALUES("693", "rsssl_elementor_dismissed", "1", "yes");
INSERT INTO `theme_options` VALUES("981", "_transient_product-transient-version", "1645015929", "yes");
INSERT INTO `theme_options` VALUES("1201", "_transient_health-check-site-status-result", "{\"good\":\"20\",\"recommended\":\"7\",\"critical\":\"0\",\"0\":\"NaN\"}", "yes");
INSERT INTO `theme_options` VALUES("1359", "elementor_controls_usage", "a:1:{s:7:\"wp-page\";a:14:{s:6:\"column\";a:2:{s:5:\"count\";i:24;s:8:\"controls\";a:1:{s:6:\"layout\";a:1:{s:6:\"layout\";a:2:{s:12:\"_inline_size\";i:23;s:19:\"_inline_size_mobile\";i:5;}}}}s:7:\"section\";a:2:{s:5:\"count\";i:14;s:8:\"controls\";a:3:{s:6:\"layout\";a:2:{s:14:\"section_layout\";a:7:{s:13:\"content_width\";i:13;s:3:\"gap\";i:1;s:18:\"gap_columns_custom\";i:1;s:25:\"gap_columns_custom_mobile\";i:1;s:6:\"height\";i:2;s:13:\"custom_height\";i:2;s:6:\"layout\";i:1;}s:17:\"section_structure\";a:1:{s:9:\"structure\";i:4;}}s:5:\"style\";a:1:{s:14:\"section_border\";a:1:{s:13:\"border_radius\";i:2;}}s:8:\"advanced\";a:1:{s:16:\"section_advanced\";a:1:{s:6:\"margin\";i:1;}}}}s:11:\"text-editor\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:14:\"section_editor\";a:1:{s:6:\"editor\";i:1;}}}}s:17:\"suggestion_moment\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:3:{s:5:\"title\";i:1;s:10:\"categoryid\";i:1;s:5:\"color\";i:1;}}}}s:11:\"imageslider\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:4:{s:16:\"content_section1\";a:2:{s:6:\"image1\";i:1;s:5:\"link1\";i:1;}s:16:\"content_section2\";a:1:{s:6:\"image2\";i:1;}s:16:\"content_section3\";a:2:{s:6:\"image3\";i:1;s:5:\"link3\";i:1;}s:16:\"content_section4\";a:1:{s:6:\"image4\";i:1;}}}}s:15:\"feauturewidgets\";a:2:{s:5:\"count\";i:5;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:16:\"content_section1\";a:3:{s:6:\"title1\";i:5;s:3:\"id1\";i:5;s:6:\"image1\";i:5;}}}}s:14:\"categoryBanner\";a:2:{s:5:\"count\";i:7;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:6:{s:5:\"title\";i:7;s:10:\"buttontext\";i:7;s:5:\"image\";i:7;s:9:\"colorBack\";i:7;s:10:\"colorBack2\";i:7;s:10:\"buttonlink\";i:3;}}}}s:13:\"caruselwidget\";a:2:{s:5:\"count\";i:3;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:2:{s:5:\"title\";i:3;s:10:\"categoryid\";i:3;}}}}s:16:\"caruselwidgetoff\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:2:{s:10:\"categoryid\";i:1;s:9:\"colorBack\";i:1;}}}}s:15:\"categorybanner2\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:6:{s:16:\"content_section1\";a:3:{s:6:\"title1\";i:1;s:6:\"image1\";i:1;s:3:\"id1\";i:1;}s:16:\"content_section2\";a:3:{s:6:\"title2\";i:1;s:6:\"image2\";i:1;s:3:\"id2\";i:1;}s:16:\"content_section3\";a:3:{s:6:\"title3\";i:1;s:6:\"image3\";i:1;s:3:\"id3\";i:1;}s:16:\"content_section4\";a:3:{s:6:\"title4\";i:1;s:6:\"image4\";i:1;s:3:\"id4\";i:1;}s:16:\"content_section5\";a:3:{s:6:\"title5\";i:1;s:6:\"image5\";i:1;s:3:\"id5\";i:1;}s:16:\"content_section6\";a:3:{s:6:\"title6\";i:1;s:6:\"image6\";i:1;s:3:\"id6\";i:1;}}}}s:15:\"categorybanner3\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:16:\"content_section1\";a:10:{s:5:\"image\";i:1;s:5:\"title\";i:1;s:10:\"titlecolor\";i:1;s:11:\"description\";i:1;s:16:\"descriptioncolor\";i:1;s:10:\"buttontext\";i:1;s:10:\"buttonlink\";i:1;s:11:\"buttoncolor\";i:1;s:15:\"buttoncolortext\";i:1;s:15:\"backgroundcolor\";i:1;}}}}s:9:\"mailchimp\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:16:\"content_section1\";a:3:{s:5:\"title\";i:1;s:11:\"description\";i:1;s:5:\"color\";i:1;}}}}s:14:\"lastpostwidget\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:1:{s:15:\"content_section\";a:3:{s:5:\"title\";i:1;s:10:\"postnumber\";i:1;s:4:\"link\";i:1;}}}}s:6:\"brands\";a:2:{s:5:\"count\";i:1;s:8:\"controls\";a:1:{s:7:\"content\";a:8:{s:5:\"title\";a:2:{s:6:\"title1\";i:1;s:10:\"titlecolor\";i:1;}s:16:\"content_section1\";a:2:{s:6:\"image1\";i:1;s:5:\"link1\";i:1;}s:16:\"content_section2\";a:2:{s:6:\"image2\";i:1;s:5:\"link2\";i:1;}s:16:\"content_section3\";a:2:{s:6:\"image3\";i:1;s:5:\"link3\";i:1;}s:16:\"content_section4\";a:1:{s:6:\"image4\";i:1;}s:16:\"content_section5\";a:2:{s:6:\"image5\";i:1;s:5:\"link5\";i:1;}s:16:\"content_section6\";a:1:{s:6:\"image6\";i:1;}s:16:\"content_section7\";a:1:{s:6:\"image7\";i:1;}}}}}}", "no");
INSERT INTO `theme_options` VALUES("1901", "elementor_log", "a:16:{s:32:\"e06fd1ed074896174be1d16e3f0cf7f4\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:106:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:80;s:7:\"\0*\0date\";s:19:\"2021-08-09 07:29:52\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:19:\"Undefined offset: 2\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2021-08-09 07:29:52\";i:1;s:19:\"2021-08-09 07:42:16\";i:2;s:19:\"2021-08-09 07:42:23\";i:3;s:19:\"2021-08-09 07:42:36\";i:4;s:19:\"2021-08-09 07:43:08\";i:5;s:19:\"2021-08-09 07:43:27\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:19:\"Undefined offset: 2\";s:4:\"file\";s:106:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:80;s:5:\"trace\";b:1;}}s:32:\"9eea06eec156160f0b578701413a3d44\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:106:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:115;s:7:\"\0*\0date\";s:19:\"2021-08-10 07:14:12\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:59:\"Trying to get property &#039;post_title&#039; of non-object\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2021-08-10 07:14:12\";i:1;s:19:\"2021-08-10 07:14:48\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:49:\"Trying to get property \'post_title\' of non-object\";s:4:\"file\";s:106:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:115;s:5:\"trace\";b:1;}}s:32:\"48acbfadf655aa053fd2d695dba8208c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7bd391545113f83c0ee1c9f091134270\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"78bcd6de8b26e2cb7315a3d40a3d63ef\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"9076d90bfe5766353c1ffbcaa7345f88\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:86:\"المنتور/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:86:\"المنتور/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c7ffe54f347b0f104a62d4cbb5a68ab1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:88:\"المنتور/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:88:\"المنتور/Upgrades - _v_3_4_8_fix_font_awesome_default_value_from_1_to_yes Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"426fd49b2ee5098ade6af03530c76113\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:69:\"المنتور/Upgrades - _v_3_5_0_remove_old_elementor_scheme Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:69:\"المنتور/Upgrades - _v_3_5_0_remove_old_elementor_scheme Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"016ba5b88dc72f5c01ad93a1878b0307\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:71:\"المنتور/Upgrades - _v_3_5_0_remove_old_elementor_scheme Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:71:\"المنتور/Upgrades - _v_3_5_0_remove_old_elementor_scheme Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"3c4b5c2b9a668578ce30d34426b6c977\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.3.1\";s:2:\"to\";s:5:\"3.5.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.3.1\";s:2:\"to\";s:5:\"3.5.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"794a9b169b8dcee5a9580b682cca3247\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2021-12-25 19:52:47\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.3.1\";s:2:\"to\";s:5:\"3.5.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2021-12-25 19:52:47\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.3.1\";s:2:\"to\";s:5:\"3.5.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0d37451fdbe7a129c341271124fc56c2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-20 16:38:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.2\";s:2:\"to\";s:5:\"3.5.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-20 16:38:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.2\";s:2:\"to\";s:5:\"3.5.5\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9e45215db2d786c1a4640b64a9c2e43d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-20 16:39:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-20 16:39:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"aa5af754728f447823667a1967e05c6c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-20 16:39:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-20 16:39:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"e8f385b0c6d75ca22932bf1eed71f690\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-20 16:39:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-20 16:39:08\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"73e1c725d49c3ed0993d60d8b4312a52\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2022-02-20 16:39:08\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.2\";s:2:\"to\";s:5:\"3.5.5\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2022-02-20 16:39:08\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:5:\"3.5.2\";s:2:\"to\";s:5:\"3.5.5\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "no");
INSERT INTO `theme_options` VALUES("1955", "wp-smush-settings", "a:22:{s:4:\"auto\";b:1;s:5:\"lossy\";b:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:1;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("1956", "wp-smush-install-type", "existing", "no");
INSERT INTO `theme_options` VALUES("1957", "wp-smush-version", "3.8.8", "no");
INSERT INTO `theme_options` VALUES("1960", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1628497094;}s:5:\"queue\";a:2:{s:32:\"7de3619981caadc55f30a002bfb299f6\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1628497094;}s:32:\"fc50097023d0d34c5a66f6cddcf77694\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1629101894;}}s:4:\"done\";a:0:{}}", "no");
INSERT INTO `theme_options` VALUES("1961", "wpmudev_recommended_plugins_registered", "a:1:{s:23:\"wp-smushit/wp-smush.php\";a:1:{s:13:\"registered_at\";i:1628497094;}}", "no");
INSERT INTO `theme_options` VALUES("1962", "smush_global_stats", "a:9:{s:11:\"size_before\";i:0;s:10:\"size_after\";i:0;s:7:\"percent\";d:0;s:5:\"human\";s:10:\"0 بایت\";s:5:\"bytes\";i:0;s:12:\"total_images\";i:0;s:12:\"resize_count\";i:0;s:14:\"resize_savings\";i:0;s:18:\"conversion_savings\";i:0;}", "no");
INSERT INTO `theme_options` VALUES("1963", "wp-smush-preset_configs", "a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:12:\"Basic config\";s:11:\"description\";s:46:\"Recommended performance config for every site.\";s:7:\"default\";b:1;s:6:\"config\";a:2:{s:7:\"configs\";a:1:{s:8:\"settings\";a:22:{s:4:\"auto\";b:1;s:5:\"lossy\";b:1;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:1;s:6:\"backup\";b:1;s:10:\"png_to_jpg\";b:1;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:10:\"js_builder\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:0;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;s:17:\"background_images\";b:1;s:16:\"rest_api_support\";b:0;s:8:\"webp_mod\";b:0;}}s:7:\"strings\";a:7:{s:10:\"bulk_smush\";a:1:{i:0;s:241:\"فشرده سازی خودکار - فعال\nSuper-Smush - Inactive\nمتا دیتا - فعال\nتغییر اندازه تصویر - Inactive\nتصاویر اصلی - Inactive\nBackup Original Images - Inactive\nتبدیل PNG به JPG - Inactive\";}s:9:\"lazy_load\";a:1:{i:0;s:8:\"Inactive\";}s:3:\"cdn\";a:1:{i:0;s:8:\"Inactive\";}s:8:\"webp_mod\";a:1:{i:0;s:8:\"Inactive\";}s:12:\"integrations\";a:1:{i:0;s:159:\"پشتیبانی از گوتنبرگ - Inactive\nصفحه ساز ویژوال کامپوزر - Inactive\nآمازون S3 - Inactive\nگالری NextGen - Inactive\";}s:5:\"tools\";a:1:{i:0;s:56:\"تشخیص تغییر اندازه تصوير - Inactive\";}s:8:\"settings\";a:1:{i:0;s:116:\"قابلیت دسترسی رنگ - Inactive\nپیگیری استفاده - Inactive\nKeep Data On Uninstall - فعال\";}}}}}", "no");
INSERT INTO `theme_options` VALUES("1965", "skip-smush-setup", "1", "yes");
INSERT INTO `theme_options` VALUES("1968", "dir_smush_stats", "a:2:{s:9:\"dir_smush\";a:2:{s:5:\"total\";i:0;s:9:\"optimised\";i:0;}s:14:\"combined_stats\";a:0:{}}", "no");
INSERT INTO `theme_options` VALUES("2034", "bwp_minify_general", "a:24:{s:12:\"input_minurl\";s:0:\"\";s:13:\"input_minpath\";s:0:\"\";s:15:\"input_cache_dir\";s:0:\"\";s:14:\"input_doc_root\";s:0:\"\";s:14:\"input_maxfiles\";i:10;s:12:\"input_maxage\";i:1;s:12:\"input_ignore\";s:38:\"admin-bar\r\njquery-core\r\njquery-migrate\";s:12:\"input_header\";s:0:\"\";s:12:\"input_direct\";s:0:\"\";s:12:\"input_footer\";s:0:\"\";s:14:\"input_oblivion\";s:0:\"\";s:18:\"input_style_ignore\";s:20:\"admin-bar\r\ndashicons\";s:18:\"input_style_direct\";s:0:\"\";s:20:\"input_style_oblivion\";s:0:\"\";s:19:\"input_custom_buster\";s:0:\"\";s:13:\"enable_min_js\";s:3:\"yes\";s:14:\"enable_min_css\";s:3:\"yes\";s:15:\"enable_bloginfo\";s:0:\"\";s:22:\"enable_external_origin\";s:0:\"\";s:17:\"enable_css_bubble\";s:3:\"yes\";s:22:\"enable_cache_file_lock\";s:3:\"yes\";s:12:\"enable_debug\";s:0:\"\";s:18:\"select_buster_type\";s:4:\"none\";s:16:\"select_time_type\";i:86400;}", "yes");
INSERT INTO `theme_options` VALUES("1964", "wp-smush-lazy_load", "a:9:{s:6:\"format\";a:6:{s:4:\"jpeg\";b:1;s:3:\"png\";b:1;s:4:\"webp\";b:1;s:3:\"gif\";b:1;s:3:\"svg\";b:1;s:6:\"iframe\";b:1;}s:6:\"output\";a:4:{s:7:\"content\";b:1;s:7:\"widgets\";b:1;s:10:\"thumbnails\";b:1;s:9:\"gravatars\";b:1;}s:9:\"animation\";a:4:{s:8:\"selected\";s:6:\"fadein\";s:6:\"fadein\";a:2:{s:8:\"duration\";i:400;s:5:\"delay\";i:0;}s:7:\"spinner\";a:2:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}}s:11:\"placeholder\";a:3:{s:8:\"selected\";i:1;s:6:\"custom\";a:0:{}s:5:\"color\";s:7:\"#F3F3F3\";}}s:7:\"include\";a:7:{s:9:\"frontpage\";b:1;s:4:\"home\";b:1;s:4:\"page\";b:1;s:6:\"single\";b:1;s:7:\"archive\";b:1;s:8:\"category\";b:1;s:3:\"tag\";b:1;}s:13:\"exclude-pages\";a:0:{}s:15:\"exclude-classes\";a:0:{}s:6:\"footer\";b:1;s:6:\"native\";b:0;s:8:\"noscript\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("2547", "dgwt_wcas_settings_show_advanced", "on", "yes");
INSERT INTO `theme_options` VALUES("2446", "fs_debug_mode", "", "yes");
INSERT INTO `theme_options` VALUES("2447", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:700;a:3:{s:4:\"slug\";s:27:\"ajax-search-for-woocommerce\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}}s:11:\"plugin_data\";a:1:{s:27:\"ajax-search-for-woocommerce\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1628620695;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.2\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"1.15.0\";s:14:\"plugin_version\";s:6:\"1.16.0\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:14:\"instabotapp.ir\";s:9:\"server_ip\";s:13:\"46.225.218.70\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1628620695;s:7:\"version\";s:6:\"1.13.0\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1630355369;s:7:\"version\";s:6:\"1.13.0\";}}}s:13:\"file_slug_map\";a:1:{s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:27:\"ajax-search-for-woocommerce\";}s:7:\"plugins\";a:1:{s:27:\"ajax-search-for-woocommerce\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:40:\"FiboSearch - AJAX Search for WooCommerce\";s:4:\"slug\";s:27:\"ajax-search-for-woocommerce\";s:12:\"premium_slug\";s:35:\"ajax-search-for-woocommerce-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:7:\"version\";s:6:\"1.16.0\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:3:\"Pro\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_f4f2a51dbe0aee43de0692db77a3e\";s:10:\"secret_key\";N;s:2:\"id\";s:3:\"700\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"df223330046f0f5227419cf679737a6f\";s:13:\"admin_notices\";a:1:{s:27:\"ajax-search-for-woocommerce\";a:0:{}}}", "yes");
INSERT INTO `theme_options` VALUES("2448", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `theme_options` VALUES("2449", "fs_api_cache", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("2452", "widget_dgwt_wcas_ajax_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("2453", "dgwt_wcas_activation_date", "1628620697", "yes");
INSERT INTO `theme_options` VALUES("2454", "dgwt_wcas_settings", "a:70:{s:26:\"embedding_search_form_head\";s:0:\"\";s:10:\"how_to_use\";s:0:\"\";s:9:\"form_head\";s:0:\"\";s:11:\"layout_head\";s:0:\"\";s:11:\"search_form\";s:0:\"\";s:14:\"preloader_head\";s:0:\"\";s:17:\"autocomplete_head\";s:0:\"\";s:23:\"product_suggestion_head\";s:0:\"\";s:33:\"non_products_in_autocomplete_head\";s:0:\"\";s:28:\"show_product_tax_product_cat\";s:2:\"on\";s:35:\"show_product_tax_product_cat_images\";s:3:\"off\";s:28:\"show_product_tax_product_tag\";s:3:\"off\";s:16:\"details_box_head\";s:0:\"\";s:22:\"suggestions_style_head\";s:0:\"\";s:18:\"search_search_head\";s:0:\"\";s:33:\"search_in_product_tax_product_cat\";s:3:\"off\";s:33:\"search_in_product_tax_product_tag\";s:3:\"off\";s:27:\"search_scope_fuzziness_head\";s:0:\"\";s:20:\"search_synonyms_head\";s:0:\"\";s:20:\"filter_products_head\";s:0:\"\";s:21:\"filter_products_rules\";s:2:\"[]\";s:12:\"pro_features\";s:0:\"\";s:18:\"search_engine_head\";s:0:\"\";s:19:\"search_engine_build\";s:0:\"\";s:21:\"indexer_schedule_head\";s:0:\"\";s:20:\"troubleshooting_head\";s:0:\"\";s:9:\"min_chars\";s:1:\"3\";s:14:\"max_form_width\";s:3:\"600\";s:18:\"show_submit_button\";s:2:\"on\";s:18:\"search_submit_text\";s:0:\"\";s:18:\"search_placeholder\";s:74:\"محصول مورد نظر را وارد کرده و اینتر بزنید\";s:13:\"search_layout\";s:7:\"classic\";s:21:\"enable_mobile_overlay\";s:2:\"on\";s:17:\"mobile_breakpoint\";s:3:\"992\";s:17:\"search_icon_color\";s:0:\"\";s:14:\"bg_input_color\";s:0:\"\";s:16:\"text_input_color\";s:0:\"\";s:18:\"border_input_color\";s:0:\"\";s:15:\"bg_submit_color\";s:7:\"#00a2b5\";s:17:\"text_submit_color\";s:7:\"#0a0a0a\";s:14:\"show_preloader\";s:2:\"on\";s:13:\"preloader_url\";s:0:\"\";s:17:\"suggestions_limit\";s:1:\"7\";s:20:\"show_grouped_results\";s:2:\"on\";s:22:\"search_no_results_text\";s:32:\"نتیجه ای یافت نشد!\";s:18:\"show_product_image\";s:2:\"on\";s:18:\"show_product_price\";s:3:\"off\";s:17:\"show_product_desc\";s:3:\"off\";s:16:\"show_product_sku\";s:3:\"off\";s:27:\"search_see_all_results_text\";s:26:\"دیدن همه نتایج\";s:19:\"show_matching_posts\";s:3:\"off\";s:19:\"show_matching_pages\";s:3:\"off\";s:16:\"show_details_box\";s:3:\"off\";s:12:\"sug_bg_color\";s:0:\"\";s:15:\"sug_hover_color\";s:0:\"\";s:14:\"sug_text_color\";s:0:\"\";s:19:\"sug_highlight_color\";s:0:\"\";s:16:\"sug_border_color\";s:0:\"\";s:25:\"search_in_product_content\";s:3:\"off\";s:25:\"search_in_product_excerpt\";s:3:\"off\";s:21:\"search_in_product_sku\";s:3:\"off\";s:28:\"search_in_product_attributes\";s:3:\"off\";s:23:\"search_in_custom_fields\";s:0:\"\";s:20:\"exclude_out_of_stock\";s:3:\"off\";s:22:\"fuzziness_enabled_demo\";s:3:\"off\";s:15:\"search_synonyms\";s:0:\"\";s:20:\"filter_products_mode\";s:7:\"exclude\";s:16:\"indexer_schedule\";s:3:\"off\";s:25:\"indexer_schedule_interval\";s:6:\"weekly\";s:27:\"indexer_schedule_start_time\";s:1:\"3\";}", "yes");
INSERT INTO `theme_options` VALUES("2445", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:34:\"ajax-search-for-woocommerce/fs/lib\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.4.2\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1629229200;s:11:\"plugin_path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";}}s:7:\"abspath\";s:50:\"/home/instabot/domains/instabotapp.ir/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:59:\"ajax-search-for-woocommerce/ajax-search-for-woocommerce.php\";s:8:\"sdk_path\";s:34:\"ajax-search-for-woocommerce/fs/lib\";s:7:\"version\";s:5:\"2.4.2\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1629229200;}}", "yes");
INSERT INTO `theme_options` VALUES("2043", "bwp_minify_advanced", "a:8:{s:17:\"input_fly_minpath\";s:0:\"\";s:23:\"input_nginx_config_file\";s:0:\"\";s:14:\"input_cdn_host\";s:0:\"\";s:17:\"input_cdn_host_js\";s:0:\"\";s:18:\"input_cdn_host_css\";s:0:\"\";s:14:\"enable_fly_min\";s:0:\"\";s:10:\"enable_cdn\";s:0:\"\";s:19:\"select_cdn_ssl_type\";s:3:\"off\";}", "yes");
INSERT INTO `theme_options` VALUES("2035", "bwp_minify_detector_log", "a:3:{s:7:\"scripts\";a:36:{s:11:\"jquery-core\";a:8:{s:6:\"handle\";s:11:\"jquery-core\";s:3:\"src\";s:36:\"/wp-includes/js/jquery/jquery.min.js\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:17:\"ignored in header\";s:5:\"order\";i:3;s:5:\"group\";s:11:\"jquery-core\";}s:14:\"jquery-migrate\";a:8:{s:6:\"handle\";s:14:\"jquery-migrate\";s:3:\"src\";s:44:\"/wp-includes/js/jquery/jquery-migrate.min.js\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:11:\"jquery-core\";}s:8:\"position\";s:17:\"ignored in header\";s:5:\"order\";i:3;s:5:\"group\";s:14:\"jquery-migrate\";}s:14:\"jquery-blockui\";a:8:{s:6:\"handle\";s:14:\"jquery-blockui\";s:3:\"src\";s:77:\"wp-content/plugins/woocommerce/assets/js/jquery-blockui/jquery.blockUI.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:14:\"wc-add-to-cart\";a:8:{s:6:\"handle\";s:14:\"wc-add-to-cart\";s:3:\"src\";s:68:\"wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:2:{i:0;s:6:\"jquery\";i:1;s:14:\"jquery-blockui\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:9:\"js-cookie\";a:8:{s:6:\"handle\";s:9:\"js-cookie\";s:3:\"src\";s:67:\"wp-content/plugins/woocommerce/assets/js/js-cookie/js.cookie.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:11:\"woocommerce\";a:8:{s:6:\"handle\";s:11:\"woocommerce\";s:3:\"src\";s:68:\"wp-content/plugins/woocommerce/assets/js/frontend/woocommerce.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:3:{i:0;s:6:\"jquery\";i:1;s:14:\"jquery-blockui\";i:2;s:9:\"js-cookie\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:17:\"wc-cart-fragments\";a:8:{s:6:\"handle\";s:17:\"wc-cart-fragments\";s:3:\"src\";s:71:\"wp-content/plugins/woocommerce/assets/js/frontend/cart-fragments.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:2:{i:0;s:6:\"jquery\";i:1;s:9:\"js-cookie\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:13:\"custom-script\";a:8:{s:6:\"handle\";s:13:\"custom-script\";s:3:\"src\";s:39:\"wp-content/themes/theme/js/topbutton.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:13:\"custom-script\";}s:8:\"wp-embed\";a:8:{s:6:\"handle\";s:8:\"wp-embed\";s:3:\"src\";s:30:\"wp-includes/js/wp-embed.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:25:\"elementor-webpack-runtime\";a:8:{s:6:\"handle\";s:25:\"elementor-webpack-runtime\";s:3:\"src\";s:61:\"wp-content/plugins/elementor/assets/js/webpack.runtime.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:26:\"elementor-frontend-modules\";a:8:{s:6:\"handle\";s:26:\"elementor-frontend-modules\";s:3:\"src\";s:62:\"wp-content/plugins/elementor/assets/js/frontend-modules.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:2:{i:0;s:25:\"elementor-webpack-runtime\";i:1;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:19:\"elementor-waypoints\";a:8:{s:6:\"handle\";s:19:\"elementor-waypoints\";s:3:\"src\";s:66:\"wp-content/plugins/elementor/assets/lib/waypoints/waypoints.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:14:\"jquery-ui-core\";a:8:{s:6:\"handle\";s:14:\"jquery-ui-core\";s:3:\"src\";s:36:\"wp-includes/js/jquery/ui/core.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:6:\"swiper\";a:8:{s:6:\"handle\";s:6:\"swiper\";s:3:\"src\";s:60:\"wp-content/plugins/elementor/assets/lib/swiper/swiper.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:10:\"share-link\";a:8:{s:6:\"handle\";s:10:\"share-link\";s:3:\"src\";s:68:\"wp-content/plugins/elementor/assets/lib/share-link/share-link.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:16:\"elementor-dialog\";a:8:{s:6:\"handle\";s:16:\"elementor-dialog\";s:3:\"src\";s:60:\"wp-content/plugins/elementor/assets/lib/dialog/dialog.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:18:\"jquery-ui-position\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:18:\"elementor-frontend\";a:8:{s:6:\"handle\";s:18:\"elementor-frontend\";s:3:\"src\";s:54:\"wp-content/plugins/elementor/assets/js/frontend.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:6:{i:0;s:26:\"elementor-frontend-modules\";i:1;s:19:\"elementor-waypoints\";i:2;s:18:\"jquery-ui-position\";i:3;s:6:\"swiper\";i:4;s:10:\"share-link\";i:5;s:16:\"elementor-dialog\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:17:\"preloaded-modules\";a:8:{s:6:\"handle\";s:17:\"preloaded-modules\";s:3:\"src\";s:63:\"wp-content/plugins/elementor/assets/js/preloaded-modules.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:18:\"elementor-frontend\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:17:\"preloaded-modules\";}s:14:\"hoverintent-js\";a:8:{s:6:\"handle\";s:14:\"hoverintent-js\";s:3:\"src\";s:36:\"wp-includes/js/hoverintent-js.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:9:\"admin-bar\";a:8:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:32:\"/wp-includes/js/admin-bar.min.js\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:14:\"hoverintent-js\";}s:8:\"position\";s:17:\"ignored in footer\";s:5:\"order\";i:5;s:5:\"group\";s:9:\"admin-bar\";}s:12:\"wpfc-toolbar\";a:8:{s:6:\"handle\";s:12:\"wpfc-toolbar\";s:3:\"src\";s:49:\"wp-content/plugins/wp-fastest-cache/js/toolbar.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:15:\"jquery-ui-mouse\";a:8:{s:6:\"handle\";s:15:\"jquery-ui-mouse\";s:3:\"src\";s:37:\"wp-includes/js/jquery/ui/mouse.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:14:\"jquery-ui-core\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:19:\"jquery-ui-draggable\";a:8:{s:6:\"handle\";s:19:\"jquery-ui-draggable\";s:3:\"src\";s:41:\"wp-includes/js/jquery/ui/draggable.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:15:\"jquery-ui-mouse\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:14:\"hoverintent-js\";}s:10:\"underscore\";a:8:{s:6:\"handle\";s:10:\"underscore\";s:3:\"src\";s:32:\"wp-includes/js/underscore.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:8:\"backbone\";a:8:{s:6:\"handle\";s:8:\"backbone\";s:3:\"src\";s:30:\"wp-includes/js/backbone.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:2:{i:0;s:10:\"underscore\";i:1;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:19:\"backbone-marionette\";a:8:{s:6:\"handle\";s:19:\"backbone-marionette\";s:3:\"src\";s:75:\"wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:8:\"backbone\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:14:\"backbone-radio\";a:8:{s:6:\"handle\";s:14:\"backbone-radio\";s:3:\"src\";s:70:\"wp-content/plugins/elementor/assets/lib/backbone/backbone.radio.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:8:\"backbone\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:24:\"elementor-common-modules\";a:8:{s:6:\"handle\";s:24:\"elementor-common-modules\";s:3:\"src\";s:60:\"wp-content/plugins/elementor/assets/js/common-modules.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:14:\"wp-api-request\";a:8:{s:6:\"handle\";s:14:\"wp-api-request\";s:3:\"src\";s:33:\"wp-includes/js/api-request.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:6:\"jquery\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:19:\"regenerator-runtime\";a:8:{s:6:\"handle\";s:19:\"regenerator-runtime\";s:3:\"src\";s:53:\"wp-includes/js/dist/vendor/regenerator-runtime.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:11:\"wp-polyfill\";a:8:{s:6:\"handle\";s:11:\"wp-polyfill\";s:3:\"src\";s:45:\"wp-includes/js/dist/vendor/wp-polyfill.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:19:\"regenerator-runtime\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:8:\"wp-hooks\";a:8:{s:6:\"handle\";s:8:\"wp-hooks\";s:3:\"src\";s:32:\"wp-includes/js/dist/hooks.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:11:\"wp-polyfill\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:10:\"underscore\";}s:7:\"wp-i18n\";a:8:{s:6:\"handle\";s:7:\"wp-i18n\";s:3:\"src\";s:31:\"wp-includes/js/dist/i18n.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:2:{i:0;s:8:\"wp-hooks\";i:1;s:11:\"wp-polyfill\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:16:\"elementor-common\";a:8:{s:6:\"handle\";s:16:\"elementor-common\";s:3:\"src\";s:52:\"wp-content/plugins/elementor/assets/js/common.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:8:{i:0;s:6:\"jquery\";i:1;s:19:\"jquery-ui-draggable\";i:2;s:19:\"backbone-marionette\";i:3;s:14:\"backbone-radio\";i:4;s:24:\"elementor-common-modules\";i:5;s:16:\"elementor-dialog\";i:6;s:14:\"wp-api-request\";i:7;s:7:\"wp-i18n\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:20:\"elementor-app-loader\";a:8:{s:6:\"handle\";s:20:\"elementor-app-loader\";s:3:\"src\";s:56:\"wp-content/plugins/elementor/assets/js/app-loader.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:16:\"elementor-common\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:7:\"wp-i18n\";}s:19:\"elementor-admin-bar\";a:8:{s:6:\"handle\";s:19:\"elementor-admin-bar\";s:3:\"src\";s:65:\"wp-content/plugins/elementor/assets/js/elementor-admin-bar.min.js\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:26:\"elementor-frontend-modules\";}s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:17:\"preloaded-modules\";}}s:6:\"styles\";a:18:{s:16:\"wp-block-library\";a:9:{s:6:\"handle\";s:16:\"wp-block-library\";s:3:\"src\";s:52:\"wp-includes/css/dist/block-library/style-rtl.min.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:22:\"wc-block-vendors-style\";a:9:{s:6:\"handle\";s:22:\"wc-block-vendors-style\";s:3:\"src\";s:82:\"wp-content/plugins/woocommerce/packages/woocommerce-blocks/build/vendors-style.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:14:\"wc-block-style\";a:9:{s:6:\"handle\";s:14:\"wc-block-style\";s:3:\"src\";s:78:\"wp-content/plugins/woocommerce/packages/woocommerce-blocks/build/style-rtl.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:22:\"wc-block-vendors-style\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:18:\"woocommerce-layout\";a:9:{s:6:\"handle\";s:18:\"woocommerce-layout\";s:3:\"src\";s:68:\"wp-content/plugins/woocommerce/assets/css/woocommerce-layout-rtl.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:23:\"woocommerce-smallscreen\";a:9:{s:6:\"handle\";s:23:\"woocommerce-smallscreen\";s:3:\"src\";s:73:\"wp-content/plugins/woocommerce/assets/css/woocommerce-smallscreen-rtl.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:23:\"woocommerce-smallscreen\";s:5:\"media\";s:34:\"only screen and (max-width: 768px)\";}s:19:\"woocommerce-general\";a:9:{s:6:\"handle\";s:19:\"woocommerce-general\";s:3:\"src\";s:61:\"wp-content/plugins/woocommerce/assets/css/woocommerce-rtl.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:15:\"elementor-icons\";a:9:{s:6:\"handle\";s:15:\"elementor-icons\";s:3:\"src\";s:74:\"wp-content/plugins/elementor/assets/lib/eicons/css/elementor-icons.min.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:18:\"elementor-frontend\";a:9:{s:6:\"handle\";s:18:\"elementor-frontend\";s:3:\"src\";s:60:\"wp-content/plugins/elementor/assets/css/frontend-rtl.min.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:17:\"elementor-post-12\";a:9:{s:6:\"handle\";s:17:\"elementor-post-12\";s:3:\"src\";s:44:\"wp-content/uploads/elementor/css/post-12.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:18:\"elementor-frontend\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:17:\"elementor-post-12\";s:5:\"media\";s:3:\"all\";}s:16:\"elementor-global\";a:9:{s:6:\"handle\";s:16:\"elementor-global\";s:3:\"src\";s:43:\"wp-content/uploads/elementor/css/global.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:17:\"elementor-post-12\";s:5:\"media\";s:3:\"all\";}s:18:\"elementor-post-271\";a:9:{s:6:\"handle\";s:18:\"elementor-post-271\";s:3:\"src\";s:45:\"wp-content/uploads/elementor/css/post-271.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:18:\"elementor-frontend\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:17:\"elementor-post-12\";s:5:\"media\";s:3:\"all\";}s:14:\"google-fonts-1\";a:9:{s:6:\"handle\";s:14:\"google-fonts-1\";s:3:\"src\";s:325:\"https://fonts.googleapis.com/css?family=Roboto:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic%7CRoboto+Slab:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic&display=auto\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:17:\"ignored in header\";s:5:\"order\";i:3;s:5:\"group\";s:14:\"google-fonts-1\";s:5:\"media\";s:3:\"all\";}s:12:\"e-animations\";a:9:{s:6:\"handle\";s:12:\"e-animations\";s:3:\"src\";s:69:\"wp-content/plugins/elementor/assets/lib/animations/animations.min.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in footer\";s:5:\"order\";i:4;s:5:\"group\";s:12:\"e-animations\";s:5:\"media\";s:3:\"all\";}s:9:\"dashicons\";a:9:{s:6:\"handle\";s:9:\"dashicons\";s:3:\"src\";s:34:\"/wp-includes/css/dashicons.min.css\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:17:\"ignored in header\";s:5:\"order\";i:3;s:5:\"group\";s:9:\"dashicons\";s:5:\"media\";s:3:\"all\";}s:9:\"admin-bar\";a:9:{s:6:\"handle\";s:9:\"admin-bar\";s:3:\"src\";s:38:\"/wp-includes/css/admin-bar-rtl.min.css\";s:3:\"min\";b:0;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:9:\"dashicons\";}s:8:\"position\";s:17:\"ignored in header\";s:5:\"order\";i:3;s:5:\"group\";s:9:\"admin-bar\";s:5:\"media\";s:3:\"all\";}s:16:\"elementor-common\";a:9:{s:6:\"handle\";s:16:\"elementor-common\";s:3:\"src\";s:58:\"wp-content/plugins/elementor/assets/css/common-rtl.min.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:15:\"elementor-icons\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:24:\"wp-fastest-cache-toolbar\";a:9:{s:6:\"handle\";s:24:\"wp-fastest-cache-toolbar\";s:3:\"src\";s:51:\"wp-content/plugins/wp-fastest-cache/css/toolbar.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";b:0;s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}s:18:\"yoast-seo-adminbar\";a:9:{s:6:\"handle\";s:18:\"yoast-seo-adminbar\";s:3:\"src\";s:63:\"wp-content/plugins/wordpress-seo/css/dist/adminbar-1680-rtl.css\";s:3:\"min\";b:1;s:2:\"wp\";b:0;s:6:\"depend\";a:1:{i:0;s:9:\"admin-bar\";}s:8:\"position\";s:18:\"minified in header\";s:5:\"order\";i:2;s:5:\"group\";s:15:\"elementor-icons\";s:5:\"media\";s:3:\"all\";}}s:6:\"groups\";a:0:{}}", "yes");
INSERT INTO `theme_options` VALUES("2036", "bwp_minify_version", "1.3.3", "yes");
INSERT INTO `theme_options` VALUES("2416", "theme_mods_theme-1", "a:29:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:2:{s:8:\"top-menu\";i:93;s:9:\"mega-menu\";i:51;}s:8:\"off-text\";s:53:\"یک فرصت استثنایی خرید از سایت\";s:9:\"instalink\";s:32:\"http://instagram.com/funkadeh.tv\";s:17:\"insta-description\";s:86:\"با دنبال کردن پیج ما از کد های تخفیف بهرمند شوید\";s:12:\"whatsap-link\";s:25:\"http://wa.me/989012595403\";s:19:\"whatsap-description\";s:138:\"در صورت بروز هرگونه مشکل و یا داشتن سوال، در واتساپ پاسخگوی شما عزیزان هستیم\";s:13:\"telegram-link\";s:22:\"http://t.me/amiraslani\";s:20:\"telegram-description\";s:12:\"تلگرام\";s:12:\"youtube-link\";s:1:\"#\";s:19:\"youtube-description\";s:12:\"یوتیوب\";s:11:\"aparat-link\";s:1:\"#\";s:18:\"aparat-description\";s:12:\"آپارات\";s:4:\"logo\";s:58:\"https://instabotapp.ir/wp-content/uploads/2021/08/logo.jpg\";s:20:\"background-megamenu1\";s:59:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1.jpg\";s:20:\"background-megamenu2\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-1.jpg\";s:20:\"background-megamenu3\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-2.jpg\";s:20:\"background-megamenu4\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-3.jpg\";s:20:\"background-megamenu5\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-4.jpg\";s:20:\"background-megamenu6\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-5.jpg\";s:20:\"background-megamenu7\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-6.jpg\";s:20:\"background-megamenu8\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-7.jpg\";s:20:\"background-megamenu9\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-8.jpg\";s:12:\"insta-active\";b:1;s:15:\"whatsapp-active\";b:1;s:15:\"telegram-active\";b:1;s:14:\"youtube-active\";b:1;s:13:\"aparat-active\";b:1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1629280759;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:19:\"mihan_footer_widget\";a:4:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";i:3;s:6:\"text-2\";}s:26:\"mihan_bottom_footer_widget\";a:1:{i:0;s:13:\"custom_html-2\";}s:20:\"mihan_sidebar_widget\";a:4:{i:0;s:8:\"search-2\";i:1;s:24:\"mihanmarketpostswidget-2\";i:2;s:14:\"recent-posts-2\";i:3;s:17:\"recent-comments-2\";}}}}", "yes");
INSERT INTO `theme_options` VALUES("2455", "dgwt_wcas_version", "1.16.0", "yes");
INSERT INTO `theme_options` VALUES("3956", "yit_recently_activated", "a:8:{i:0;s:34:\"yith-woocommerce-wishlist/init.php\";i:1;s:33:\"yith-woocommerce-compare/init.php\";i:2;s:36:\"yith-woocommerce-quick-view/init.php\";i:3;s:34:\"yith-woocommerce-wishlist/init.php\";i:4;s:36:\"yith-woocommerce-quick-view/init.php\";i:5;s:33:\"yith-woocommerce-compare/init.php\";i:6;s:34:\"yith-woocommerce-wishlist/init.php\";i:7;s:33:\"yith-woocommerce-compare/init.php\";}", "yes");
INSERT INTO `theme_options` VALUES("4046", "yith_woocompare_fields", "a:9:{s:5:\"image\";b:1;s:5:\"title\";b:1;s:5:\"price\";b:1;s:11:\"add-to-cart\";b:1;s:11:\"description\";b:1;s:3:\"sku\";b:1;s:5:\"stock\";b:1;s:6:\"weight\";b:1;s:10:\"dimensions\";b:1;}", "yes");
INSERT INTO `theme_options` VALUES("3957", "yith_wcwl_wishlist_page_id", "506", "yes");
INSERT INTO `theme_options` VALUES("3958", "yith_wcwl_version", "3.0.25", "yes");
INSERT INTO `theme_options` VALUES("3959", "yith_wcwl_db_version", "3.0.0", "yes");
INSERT INTO `theme_options` VALUES("3960", "yith_wcwl_ajax_enable", "no", "yes");
INSERT INTO `theme_options` VALUES("3961", "yith_wfbt_enable_integration", "yes", "yes");
INSERT INTO `theme_options` VALUES("3962", "yith_wcwl_after_add_to_wishlist_behaviour", "remove", "yes");
INSERT INTO `theme_options` VALUES("3963", "yith_wcwl_show_on_loop", "yes", "yes");
INSERT INTO `theme_options` VALUES("3964", "yith_wcwl_loop_position", "after_add_to_cart", "yes");
INSERT INTO `theme_options` VALUES("3965", "yith_wcwl_button_position", "add-to-cart", "yes");
INSERT INTO `theme_options` VALUES("3966", "yith_wcwl_add_to_wishlist_text", "افزودن به علاقه مندی ها", "yes");
INSERT INTO `theme_options` VALUES("3967", "yith_wcwl_product_added_text", "اضافه شد!", "yes");
INSERT INTO `theme_options` VALUES("3968", "yith_wcwl_browse_wishlist_text", "لیست علاقه مندی ها", "yes");
INSERT INTO `theme_options` VALUES("3969", "yith_wcwl_already_in_wishlist_text", "این محصول در لیست علاقه مندی ها شما قرار دارد!", "yes");
INSERT INTO `theme_options` VALUES("3970", "yith_wcwl_add_to_wishlist_style", "link", "yes");
INSERT INTO `theme_options` VALUES("3971", "yith_wcwl_rounded_corners_radius", "16", "yes");
INSERT INTO `theme_options` VALUES("3972", "yith_wcwl_add_to_wishlist_icon", "fa-heart-o", "yes");
INSERT INTO `theme_options` VALUES("3973", "yith_wcwl_add_to_wishlist_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("3974", "yith_wcwl_added_to_wishlist_icon", "fa-heart", "yes");
INSERT INTO `theme_options` VALUES("3975", "yith_wcwl_added_to_wishlist_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("3976", "yith_wcwl_custom_css", "", "yes");
INSERT INTO `theme_options` VALUES("3977", "yith_wcwl_variation_show", "", "yes");
INSERT INTO `theme_options` VALUES("3978", "yith_wcwl_price_show", "yes", "yes");
INSERT INTO `theme_options` VALUES("3979", "yith_wcwl_stock_show", "yes", "yes");
INSERT INTO `theme_options` VALUES("3980", "yith_wcwl_show_dateadded", "", "yes");
INSERT INTO `theme_options` VALUES("3981", "yith_wcwl_add_to_cart_show", "yes", "yes");
INSERT INTO `theme_options` VALUES("3982", "yith_wcwl_show_remove", "yes", "yes");
INSERT INTO `theme_options` VALUES("3983", "yith_wcwl_repeat_remove_button", "", "yes");
INSERT INTO `theme_options` VALUES("3984", "yith_wcwl_redirect_cart", "no", "yes");
INSERT INTO `theme_options` VALUES("3985", "yith_wcwl_remove_after_add_to_cart", "yes", "yes");
INSERT INTO `theme_options` VALUES("3986", "yith_wcwl_enable_share", "yes", "yes");
INSERT INTO `theme_options` VALUES("3987", "yith_wcwl_share_fb", "yes", "yes");
INSERT INTO `theme_options` VALUES("3988", "yith_wcwl_share_twitter", "yes", "yes");
INSERT INTO `theme_options` VALUES("3989", "yith_wcwl_share_pinterest", "yes", "yes");
INSERT INTO `theme_options` VALUES("3990", "yith_wcwl_share_email", "yes", "yes");
INSERT INTO `theme_options` VALUES("3991", "yith_wcwl_share_whatsapp", "yes", "yes");
INSERT INTO `theme_options` VALUES("3992", "yith_wcwl_share_url", "no", "yes");
INSERT INTO `theme_options` VALUES("3993", "yith_wcwl_socials_title", "لیست علاقه مندی های من در دیجیکالا", "yes");
INSERT INTO `theme_options` VALUES("3994", "yith_wcwl_socials_text", "", "yes");
INSERT INTO `theme_options` VALUES("3995", "yith_wcwl_socials_image_url", "", "yes");
INSERT INTO `theme_options` VALUES("3996", "yith_wcwl_wishlist_title", "لیست علاقه مندی های من", "yes");
INSERT INTO `theme_options` VALUES("3997", "yith_wcwl_add_to_cart_text", "افزودن به سبد خرید", "yes");
INSERT INTO `theme_options` VALUES("3998", "yith_wcwl_add_to_cart_style", "link", "yes");
INSERT INTO `theme_options` VALUES("3999", "yith_wcwl_add_to_cart_rounded_corners_radius", "16", "yes");
INSERT INTO `theme_options` VALUES("4000", "yith_wcwl_add_to_cart_icon", "fa-shopping-cart", "yes");
INSERT INTO `theme_options` VALUES("4001", "yith_wcwl_add_to_cart_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4002", "yith_wcwl_color_headers_background", "#F4F4F4", "yes");
INSERT INTO `theme_options` VALUES("4003", "yith_wcwl_fb_button_icon", "fa-facebook", "yes");
INSERT INTO `theme_options` VALUES("4004", "yith_wcwl_fb_button_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4005", "yith_wcwl_tw_button_icon", "fa-twitter", "yes");
INSERT INTO `theme_options` VALUES("4006", "yith_wcwl_tw_button_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4007", "yith_wcwl_pr_button_icon", "fa-pinterest", "yes");
INSERT INTO `theme_options` VALUES("4008", "yith_wcwl_pr_button_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4009", "yith_wcwl_em_button_icon", "fa-envelope-o", "yes");
INSERT INTO `theme_options` VALUES("4010", "yith_wcwl_em_button_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4011", "yith_wcwl_wa_button_icon", "fa-whatsapp", "yes");
INSERT INTO `theme_options` VALUES("4012", "yith_wcwl_wa_button_custom_icon", "", "yes");
INSERT INTO `theme_options` VALUES("4013", "yit_plugin_fw_panel_wc_default_options_set", "a:3:{s:15:\"yith_wcwl_panel\";b:1;s:21:\"yith_woocompare_panel\";b:1;s:15:\"yith_wcqv_panel\";b:1;}", "yes");
INSERT INTO `theme_options` VALUES("4014", "yith_plugin_fw_promo_2019_bis", "1", "yes");
INSERT INTO `theme_options` VALUES("4015", "_site_transient_timeout_yith_promo_message", "3258548396", "no");
INSERT INTO `theme_options` VALUES("4016", "_site_transient_yith_promo_message", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- Default border color: #acc327 -->\n<!-- Default background color: #ecf7ed -->\n\n<promotions>\n    <expiry_date>2019-12-10</expiry_date>\n    <promo>\n        <promo_id>yithblackfriday2019</promo_id>\n        <title><![CDATA[<strong>YITH Black Friday</strong>]]></title>\n        <description><![CDATA[\n            Don\'t miss our <strong>30% discount</strong> on all our products! No coupon needed in cart. Valid from <strong>28th November</strong> to <strong>2nd December</strong>.\n        ]]></description>\n        <link>\n            <label>Get your deals now!</label>\n            <url><![CDATA[https://yithemes.com]]></url>\n        </link>\n        <style>\n            <image_bg_color>#272121</image_bg_color>\n            <border_color>#272121</border_color>\n            <background_color>#ffffff</background_color>\n        </style>\n        <start_date>2019-11-27 23:59:59</start_date>\n        <end_date>2019-12-03 08:00:00</end_date>\n    </promo>\n</promotions>", "no");
INSERT INTO `theme_options` VALUES("4021", "yith_wcwl_color_add_to_wishlist", "a:6:{s:10:\"background\";s:7:\"#333333\";s:4:\"text\";s:7:\"#FFFFFF\";s:6:\"border\";s:7:\"#333333\";s:16:\"background_hover\";s:7:\"#333333\";s:10:\"text_hover\";s:7:\"#FFFFFF\";s:12:\"border_hover\";s:7:\"#333333\";}", "yes");
INSERT INTO `theme_options` VALUES("4028", "widget_yith-woocompare-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("4029", "yith_woocompare_is_button", "button", "yes");
INSERT INTO `theme_options` VALUES("4030", "yith_woocompare_button_text", "مقایسه", "yes");
INSERT INTO `theme_options` VALUES("4031", "yith_woocompare_compare_button_in_product_page", "yes", "yes");
INSERT INTO `theme_options` VALUES("4032", "yith_woocompare_compare_button_in_products_list", "yes", "yes");
INSERT INTO `theme_options` VALUES("4033", "yith_woocompare_auto_open", "yes", "yes");
INSERT INTO `theme_options` VALUES("4034", "yith_woocompare_table_text", "مقایسه‌ی محصولات", "yes");
INSERT INTO `theme_options` VALUES("4035", "yith_woocompare_fields_attrs", "a:9:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:5:\"price\";i:3;s:11:\"add-to-cart\";i:4;s:11:\"description\";i:5;s:3:\"sku\";i:6;s:5:\"stock\";i:7;s:6:\"weight\";i:8;s:10:\"dimensions\";}", "yes");
INSERT INTO `theme_options` VALUES("4036", "yith_woocompare_price_end", "yes", "yes");
INSERT INTO `theme_options` VALUES("4037", "yith_woocompare_add_to_cart_end", "no", "yes");
INSERT INTO `theme_options` VALUES("4038", "yith_woocompare_image_size", "a:3:{s:5:\"width\";s:3:\"220\";s:6:\"height\";s:3:\"154\";s:4:\"crop\";s:2:\"on\";}", "yes");
INSERT INTO `theme_options` VALUES("4052", "yith-wcqv-enable", "yes", "yes");
INSERT INTO `theme_options` VALUES("4053", "yith-wcqv-enable-mobile", "yes", "yes");
INSERT INTO `theme_options` VALUES("4054", "yith-wcqv-button-label", "Quick View", "yes");
INSERT INTO `theme_options` VALUES("4055", "yith-wcqv-background-modal", "#ffffff", "yes");
INSERT INTO `theme_options` VALUES("4056", "yith-wcqv-close-color", "#cdcdcd", "yes");
INSERT INTO `theme_options` VALUES("4057", "yith-wcqv-close-color-hover", "#ff0000", "yes");
INSERT INTO `theme_options` VALUES("4179", "dgwt_wcas_dismiss_review_notice", "1", "yes");
INSERT INTO `theme_options` VALUES("13073", "theme_mods_Shapino", "a:53:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"mega-menu\";i:51;s:8:\"top-menu\";i:93;}s:18:\"custom_css_post_id\";i:-1;s:13:\"company-color\";s:7:\"#00abc9\";s:8:\"off-text\";s:103:\"یک فرصت استثنایی خرید از سایت | ۵۰% تخفیف تا پایان تابستان\";s:12:\"insta-active\";b:1;s:9:\"instalink\";s:29:\"http://instagram.com/yourpage\";s:12:\"whatsap-link\";s:26:\"http://wa.me/9890123456789\";s:15:\"whatsapp-active\";b:1;s:13:\"telegram-link\";s:18:\"http://t.me/yourId\";s:15:\"telegram-active\";b:1;s:19:\"float-header-active\";b:1;s:4:\"logo\";s:60:\"https://instabotapp.ir/wp-content/uploads/2021/08/logo-1.jpg\";s:4:\"tell\";s:20:\"۰۲۱۲۳۴۵۶۷۸\";s:11:\"go-top-icon\";b:1;s:15:\"float-cart-icon\";b:1;s:18:\"float-product-info\";b:1;s:19:\"tags-product-active\";b:1;s:23:\"category-product-active\";b:1;s:24:\"date-article-single-page\";b:1;s:18:\"author-single-page\";b:1;s:20:\"category-single-page\";b:1;s:16:\"tags-single-page\";b:1;s:17:\"share-single-page\";b:1;s:12:\"date-article\";b:1;s:24:\"side-bar-archive-product\";b:1;s:12:\"youtube-link\";s:1:\"#\";s:14:\"youtube-active\";b:1;s:11:\"aparat-link\";s:1:\"#\";s:13:\"aparat-active\";b:1;s:20:\"background-megamenu1\";s:59:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1.jpg\";s:20:\"background-megamenu2\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-1.jpg\";s:20:\"background-megamenu3\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-2.jpg\";s:20:\"background-megamenu4\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-3.jpg\";s:20:\"background-megamenu5\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-4.jpg\";s:21:\"background-megamenu10\";s:60:\"https://instabotapp.ir/wp-content/uploads/2021/09/benner.jpg\";s:20:\"background-megamenu6\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-5.jpg\";s:20:\"background-megamenu7\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-6.jpg\";s:20:\"background-megamenu8\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-7.jpg\";s:20:\"background-megamenu9\";s:61:\"https://instabotapp.ir/wp-content/uploads/2021/08/back1-8.jpg\";s:15:\"megamenu-design\";s:1:\"1\";s:25:\"acccount-header-bacground\";s:7:\"#cc28a0\";s:10:\"cart-color\";s:7:\"#353535\";s:21:\"cart-number-bacground\";s:7:\"#cc28a0\";s:17:\"top-footer-active\";b:0;s:22:\"top-footer-media-color\";s:7:\"#e5e5e5\";s:27:\"top-footer-media-text-color\";s:7:\"#707070\";s:27:\"top-footer-media-icon-color\";s:7:\"#8224e3\";s:15:\"instalinkfooter\";s:1:\"#\";s:18:\"whatsap-linkfooter\";s:1:\"#\";s:19:\"telegram-linkfooter\";s:1:\"#\";s:18:\"youtube-linkfooter\";s:1:\"#\";s:16:\"preloader-active\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("7509", "_transient_orders-transient-version", "1630484105", "yes");
INSERT INTO `theme_options` VALUES("8155", "woocommerce_refund_returns_page_id", "781", "yes");
INSERT INTO `theme_options` VALUES("17790", "woocommerce_task_list_hidden_lists", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("9111", "_elementor_editor_upgrade_notice_dismissed", "1639651996", "yes");
INSERT INTO `theme_options` VALUES("10960", "widget_mc4wp_form_widget", "a:2:{i:3;a:1:{s:5:\"title\";s:14:\"خبرنامه\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("10962", "mc4wp_version", "4.8.6", "yes");
INSERT INTO `theme_options` VALUES("10964", "mc4wp", "a:6:{s:19:\"grecaptcha_site_key\";s:0:\"\";s:21:\"grecaptcha_secret_key\";s:0:\"\";s:7:\"api_key\";s:37:\"c46810ea6428d47e6524c3fe7ab45268-us10\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1631685106;}", "yes");
INSERT INTO `theme_options` VALUES("10979", "mc4wp_form_stylesheets", "a:1:{i:0;s:6:\"themes\";}", "yes");
INSERT INTO `theme_options` VALUES("10974", "mc4wp_default_form_id", "925", "yes");
INSERT INTO `theme_options` VALUES("11011", "duplicator_settings", "a:17:{s:7:\"version\";s:5:\"1.4.4\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:10;}", "yes");
INSERT INTO `theme_options` VALUES("11012", "duplicator_version_plugin", "1.4.4", "yes");
INSERT INTO `theme_options` VALUES("11014", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-20 13:32:52\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:7:\"10.4.20\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"Shapino_Theme\";s:4:\"Hash\";s:35:\"2b50d6afa458c1fc4242_20220220133252\";s:8:\"NameHash\";s:49:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:49:\"/home/instabot/domains/instabotapp.ir/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-20 13:32:52\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:7:\"10.4.20\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"Shapino_Theme\";s:4:\"Hash\";s:35:\"2b50d6afa458c1fc4242_20220220133252\";s:8:\"NameHash\";s:49:\"Shapino_Theme_2b50d6afa458c1fc4242_20220220133252\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:58:\"/home/instabot/domains/instabotapp.ir/public_html/wp-admin\";i:1;s:68:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/uploads\";i:2;s:70:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/languages\";i:3;s:67:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content/themes\";i:4;s:61:\"/home/instabot/domains/instabotapp.ir/public_html/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:49:\"/home/instabot/domains/instabotapp.ir/public_html\";i:1;s:60:\"/home/instabot/domains/instabotapp.ir/public_html/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:129;}", "yes");
INSERT INTO `theme_options` VALUES("11225", "amp-options", "a:13:{s:13:\"theme_support\";s:12:\"transitional\";s:20:\"supported_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:9:\"analytics\";a:0:{}s:23:\"all_templates_supported\";b:1;s:19:\"supported_templates\";a:1:{i:0;s:11:\"is_singular\";}s:7:\"version\";s:5:\"2.1.4\";s:12:\"reader_theme\";s:6:\"legacy\";s:20:\"paired_url_structure\";s:9:\"query_var\";s:17:\"plugin_configured\";b:1;s:15:\"mobile_redirect\";b:0;s:17:\"late_defined_slug\";N;s:18:\"suppressed_plugins\";a:0:{}s:21:\"primary_theme_support\";N;}", "no");
INSERT INTO `theme_options` VALUES("11229", "amp_css_transient_monitor_time_series", "a:1:{i:20210915;i:0;}", "no");
INSERT INTO `theme_options` VALUES("11264", "_transient_timeout_amp_remote_request_101623f47561580a914e5d56e153cf6c", "3264147120", "no");
INSERT INTO `theme_options` VALUES("11265", "_transient_amp_remote_request_101623f47561580a914e5d56e153cf6c", "s:2690:\"O:45:\"AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\":4:{s:51:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0body\";s:399:\"{\"ampRuntimeVersion\":\"012109032350000\",\"ampCssUrl\":\"https://cdn.ampproject.org/rtv/012109032350000/v0.css\",\"canaryPercentage\":\"0.005\",\"diversions\":[\"002109032350000\",\"002109102127000\",\"022109032350000\",\"032109032350000\",\"032109102127000\",\"042109142054000\",\"052109032350000\",\"112109032350000\"],\"ltsRuntimeVersion\":\"012108280007001\",\"ltsCssUrl\":\"https://cdn.ampproject.org/rtv/012108280007001/v0.css\"}\";s:54:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0headers\";a:19:{s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:12:\"content-type\";s:31:\"application/json; charset=UTF-8\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:23:\"content-security-policy\";s:647:\"default-src * blob: data:; script-src blob: https://cdn.ampproject.org/lts/ https://cdn.ampproject.org/rtv/ https://cdn.ampproject.org/sw/ https://cdn.ampproject.org/v0.js https://cdn.ampproject.org/v0.mjs https://cdn.ampproject.org/v0/ https://cdn.ampproject.org/viewer/; object-src \'none\'; style-src \'unsafe-inline\' https://cdn.ampproject.org/rtv/ https://cdn.materialdesignicons.com https://cloud.typography.com https://fast.fonts.net https://fonts.googleapis.com https://maxcdn.bootstrapcdn.com https://p.typekit.net https://pro.fontawesome.com https://use.fontawesome.com https://use.typekit.net; report-uri https://csp.withgoogle.com/csp/amp\";s:28:\"cross-origin-resource-policy\";s:12:\"cross-origin\";s:38:\"cross-origin-opener-policy-report-only\";s:48:\"same-origin; report-to=\"amphtml-china-available\"\";s:9:\"report-to\";s:142:\"{\"group\":\"amphtml-china-available\",\"max_age\":2592000,\"endpoints\":[{\"url\":\"https://csp.withgoogle.com/csp/report-to/amphtml-china-available\"}]}\";s:19:\"timing-allow-origin\";s:1:\"*\";s:14:\"content-length\";s:3:\"399\";s:4:\"date\";s:29:\"Wed, 15 Sep 2021 17:46:00 GMT\";s:7:\"expires\";s:29:\"Wed, 15 Sep 2021 17:46:00 GMT\";s:13:\"cache-control\";s:17:\"public, max-age=0\";s:13:\"last-modified\";s:21:\"Invalid:9223372036854\";s:25:\"strict-transport-security\";s:44:\"max-age=31536000; includeSubDomains; preload\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:6:\"server\";s:4:\"sffe\";s:16:\"x-xss-protection\";s:1:\"0\";s:7:\"alt-svc\";s:189:\"h3=\":443\"; ma=2592000,h3-29=\":443\"; ma=2592000,h3-T051=\":443\"; ma=2592000,h3-Q050=\":443\"; ma=2592000,h3-Q046=\":443\"; ma=2592000,h3-Q043=\":443\"; ma=2592000,quic=\":443\"; ma=2592000; v=\"46,43\"\";}s:58:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0status_code\";i:200;s:53:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0expiry\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2021-09-16 17:46:00.934790\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}}\";", "no");
INSERT INTO `theme_options` VALUES("11266", "_transient_timeout_amp_remote_request_5602bb6bb0292910f56ad18ec5da3131", "3264147122", "no");
INSERT INTO `theme_options` VALUES("11267", "_transient_amp_remote_request_5602bb6bb0292910f56ad18ec5da3131", "s:12556:\"O:45:\"AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\":4:{s:51:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0body\";s:10246:\"html{overflow-x:hidden!important}html.i-amphtml-fie{height:100%!important;width:100%!important}html:not([amp4ads]),html:not([amp4ads]) body{height:auto!important}html:not([amp4ads]) body{margin:0!important}body{-webkit-text-size-adjust:100%;-moz-text-size-adjust:100%;-ms-text-size-adjust:100%;text-size-adjust:100%}html.i-amphtml-singledoc.i-amphtml-embedded{-ms-touch-action:pan-y pinch-zoom;touch-action:pan-y pinch-zoom}html.i-amphtml-fie>body,html.i-amphtml-singledoc>body{overflow:visible!important}html.i-amphtml-fie:not(.i-amphtml-inabox)>body,html.i-amphtml-singledoc:not(.i-amphtml-inabox)>body{position:relative!important}html.i-amphtml-ios-embed-legacy>body{overflow-x:hidden!important;overflow-y:auto!important;position:absolute!important}html.i-amphtml-ios-embed{overflow-y:auto!important;position:static}#i-amphtml-wrapper{overflow-x:hidden!important;overflow-y:auto!important;position:absolute!important;top:0!important;left:0!important;right:0!important;bottom:0!important;margin:0!important;display:block!important}html.i-amphtml-ios-embed.i-amphtml-ios-overscroll,html.i-amphtml-ios-embed.i-amphtml-ios-overscroll>#i-amphtml-wrapper{-webkit-overflow-scrolling:touch!important}#i-amphtml-wrapper>body{position:relative!important;border-top:1px solid transparent!important}#i-amphtml-wrapper+body{visibility:visible}#i-amphtml-wrapper+body .i-amphtml-lightbox-element,#i-amphtml-wrapper+body[i-amphtml-lightbox]{visibility:hidden}#i-amphtml-wrapper+body[i-amphtml-lightbox] .i-amphtml-lightbox-element{visibility:visible}#i-amphtml-wrapper.i-amphtml-scroll-disabled,.i-amphtml-scroll-disabled{overflow-x:hidden!important;overflow-y:hidden!important}amp-instagram{padding:54px 0px 0px!important;background-color:#fff}amp-iframe iframe{box-sizing:border-box!important}[amp-access][amp-access-hide]{display:none}[subscriptions-dialog],body:not(.i-amphtml-subs-ready) [subscriptions-action],body:not(.i-amphtml-subs-ready) [subscriptions-section]{display:none!important}amp-experiment,amp-live-list>[update]{display:none}amp-list[resizable-children]>.i-amphtml-loading-container.amp-hidden{display:none!important}amp-list [fetch-error],amp-list[load-more] [load-more-button],amp-list[load-more] [load-more-end],amp-list[load-more] [load-more-failed],amp-list[load-more] [load-more-loading]{display:none}amp-list[diffable] div[role=list]{display:block}amp-story-page,amp-story[standalone]{min-height:1px!important;display:block!important;height:100%!important;margin:0!important;padding:0!important;overflow:hidden!important;width:100%!important}amp-story[standalone]{background-color:#202125!important;position:relative!important}amp-story-page{background-color:#757575}amp-story .amp-active>div,amp-story .i-amphtml-loader-background{display:none!important}amp-story-page:not(:first-of-type):not([distance]):not([active]){transform:translateY(1000vh)!important}amp-autocomplete{position:relative!important;display:inline-block!important}amp-autocomplete>input,amp-autocomplete>textarea{padding:0.5rem;border:1px solid rgba(0,0,0,0.33)}.i-amphtml-autocomplete-results,amp-autocomplete>input,amp-autocomplete>textarea{font-size:1rem;line-height:1.5rem}[amp-fx^=fly-in]{visibility:hidden}amp-script[nodom],amp-script[sandboxed]{position:fixed!important;top:0!important;width:1px!important;height:1px!important;overflow:hidden!important;visibility:hidden}\n/*# sourceURL=/css/ampdoc.css*/[hidden]{display:none!important}.i-amphtml-element{display:inline-block}.i-amphtml-blurry-placeholder{transition:opacity 0.3s cubic-bezier(0.0,0.0,0.2,1)!important;pointer-events:none}[layout=nodisplay]:not(.i-amphtml-element){display:none!important}.i-amphtml-layout-fixed,[layout=fixed][width][height]:not(.i-amphtml-layout-fixed){display:inline-block;position:relative}.i-amphtml-layout-responsive,[layout=responsive][width][height]:not(.i-amphtml-layout-responsive),[width][height][heights]:not([layout]):not(.i-amphtml-layout-responsive),[width][height][sizes]:not(img):not([layout]):not(.i-amphtml-layout-responsive){display:block;position:relative}.i-amphtml-layout-intrinsic,[layout=intrinsic][width][height]:not(.i-amphtml-layout-intrinsic){display:inline-block;position:relative;max-width:100%}.i-amphtml-layout-intrinsic .i-amphtml-sizer{max-width:100%}.i-amphtml-intrinsic-sizer{max-width:100%;display:block!important}.i-amphtml-layout-container,.i-amphtml-layout-fixed-height,[layout=container],[layout=fixed-height][height]:not(.i-amphtml-layout-fixed-height){display:block;position:relative}.i-amphtml-layout-fill,.i-amphtml-layout-fill.i-amphtml-notbuilt,[layout=fill]:not(.i-amphtml-layout-fill),body noscript>*{display:block;overflow:hidden!important;position:absolute;top:0;left:0;bottom:0;right:0}body noscript>*{position:absolute!important;width:100%;height:100%;z-index:2}body noscript{display:inline!important}.i-amphtml-layout-flex-item,[layout=flex-item]:not(.i-amphtml-layout-flex-item){display:block;position:relative;-ms-flex:1 1 auto;flex:1 1 auto}.i-amphtml-layout-fluid{position:relative}.i-amphtml-layout-size-defined{overflow:hidden!important}.i-amphtml-layout-awaiting-size{position:absolute!important;top:auto!important;bottom:auto!important}i-amphtml-sizer{display:block!important}@supports (aspect-ratio:1/1){i-amphtml-sizer.i-amphtml-disable-ar{display:none!important}}.i-amphtml-blurry-placeholder,.i-amphtml-fill-content{display:block;height:0;max-height:100%;max-width:100%;min-height:100%;min-width:100%;width:0;margin:auto}.i-amphtml-layout-size-defined .i-amphtml-fill-content{position:absolute;top:0;left:0;bottom:0;right:0}.i-amphtml-replaced-content,.i-amphtml-screen-reader{padding:0!important;border:none!important}.i-amphtml-screen-reader{position:fixed!important;top:0px!important;left:0px!important;width:4px!important;height:4px!important;opacity:0!important;overflow:hidden!important;margin:0!important;display:block!important;visibility:visible!important}.i-amphtml-screen-reader~.i-amphtml-screen-reader{left:8px!important}.i-amphtml-screen-reader~.i-amphtml-screen-reader~.i-amphtml-screen-reader{left:12px!important}.i-amphtml-screen-reader~.i-amphtml-screen-reader~.i-amphtml-screen-reader~.i-amphtml-screen-reader{left:16px!important}.i-amphtml-unresolved{position:relative;overflow:hidden!important}.i-amphtml-select-disabled{-webkit-user-select:none!important;-ms-user-select:none!important;user-select:none!important}.i-amphtml-notbuilt,[layout]:not(.i-amphtml-element),[width][height][heights]:not([layout]):not(.i-amphtml-element),[width][height][sizes]:not(img):not([layout]):not(.i-amphtml-element){position:relative;overflow:hidden!important;color:transparent!important}.i-amphtml-notbuilt:not(.i-amphtml-layout-container)>*,[layout]:not([layout=container]):not(.i-amphtml-element)>*,[width][height][heights]:not([layout]):not(.i-amphtml-element)>*,[width][height][sizes]:not([layout]):not(.i-amphtml-element)>*{display:none}amp-img:not(.i-amphtml-element)[i-amphtml-ssr]>img.i-amphtml-fill-content{display:block}.i-amphtml-notbuilt:not(.i-amphtml-layout-container),[layout]:not([layout=container]):not(.i-amphtml-element),[width][height][heights]:not([layout]):not(.i-amphtml-element),[width][height][sizes]:not(img):not([layout]):not(.i-amphtml-element){color:transparent!important;line-height:0!important}.i-amphtml-ghost{visibility:hidden!important}.i-amphtml-element>[placeholder],[layout]:not(.i-amphtml-element)>[placeholder],[width][height][heights]:not([layout]):not(.i-amphtml-element)>[placeholder],[width][height][sizes]:not([layout]):not(.i-amphtml-element)>[placeholder]{display:block;line-height:normal}.i-amphtml-element>[placeholder].amp-hidden,.i-amphtml-element>[placeholder].hidden{visibility:hidden}.i-amphtml-element:not(.amp-notsupported)>[fallback],.i-amphtml-layout-container>[placeholder].amp-hidden,.i-amphtml-layout-container>[placeholder].hidden{display:none}.i-amphtml-layout-size-defined>[fallback],.i-amphtml-layout-size-defined>[placeholder]{position:absolute!important;top:0!important;left:0!important;right:0!important;bottom:0!important;z-index:1}amp-img[i-amphtml-ssr]:not(.i-amphtml-element)>[placeholder]{z-index:auto}.i-amphtml-notbuilt>[placeholder]{display:block!important}.i-amphtml-hidden-by-media-query{display:none!important}.i-amphtml-element-error{background:red!important;color:#fff!important;position:relative!important}.i-amphtml-element-error:before{content:attr(error-message)}i-amp-scroll-container,i-amphtml-scroll-container{position:absolute;top:0;left:0;right:0;bottom:0;display:block}i-amp-scroll-container.amp-active,i-amphtml-scroll-container.amp-active{overflow:auto;-webkit-overflow-scrolling:touch}.i-amphtml-loading-container{display:block!important;pointer-events:none;z-index:1}.i-amphtml-notbuilt>.i-amphtml-loading-container{display:block!important}.i-amphtml-loading-container.amp-hidden{visibility:hidden}.i-amphtml-element>[overflow]{cursor:pointer;position:relative;z-index:2;visibility:hidden;display:initial;line-height:normal}.i-amphtml-layout-size-defined>[overflow]{position:absolute}.i-amphtml-element>[overflow].amp-visible{visibility:visible}template{display:none!important}.amp-border-box,.amp-border-box *,.amp-border-box :after,.amp-border-box :before{box-sizing:border-box}amp-pixel{display:none!important}amp-analytics,amp-auto-ads,amp-story-auto-ads{position:fixed!important;top:0!important;width:1px!important;height:1px!important;overflow:hidden!important;visibility:hidden}html.i-amphtml-fie>amp-analytics{position:initial!important}[visible-when-invalid]:not(.visible),form [submit-error],form [submit-success],form [submitting]{display:none}amp-accordion{display:block!important}@media (min-width:1px){:where(amp-accordion>section)>:first-child{margin:0;background-color:#efefef;padding-right:20px;border:1px solid #dfdfdf}:where(amp-accordion>section)>:last-child{margin:0}}amp-accordion>section{float:none!important}amp-accordion>section>*{float:none!important;display:block!important;overflow:hidden!important;position:relative!important}amp-accordion,amp-accordion>section{margin:0}amp-accordion:not(.i-amphtml-built)>section>:last-child{display:none!important}amp-accordion:not(.i-amphtml-built)>section[expanded]>:last-child{display:block!important}\n/*# sourceURL=/css/ampshared.css*/\";s:54:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0headers\";a:19:{s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:12:\"content-type\";s:23:\"text/css; charset=UTF-8\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:23:\"content-security-policy\";s:647:\"default-src * blob: data:; script-src blob: https://cdn.ampproject.org/lts/ https://cdn.ampproject.org/rtv/ https://cdn.ampproject.org/sw/ https://cdn.ampproject.org/v0.js https://cdn.ampproject.org/v0.mjs https://cdn.ampproject.org/v0/ https://cdn.ampproject.org/viewer/; object-src \'none\'; style-src \'unsafe-inline\' https://cdn.ampproject.org/rtv/ https://cdn.materialdesignicons.com https://cloud.typography.com https://fast.fonts.net https://fonts.googleapis.com https://maxcdn.bootstrapcdn.com https://p.typekit.net https://pro.fontawesome.com https://use.fontawesome.com https://use.typekit.net; report-uri https://csp.withgoogle.com/csp/amp\";s:28:\"cross-origin-resource-policy\";s:12:\"cross-origin\";s:38:\"cross-origin-opener-policy-report-only\";s:48:\"same-origin; report-to=\"amphtml-china-available\"\";s:9:\"report-to\";s:142:\"{\"group\":\"amphtml-china-available\",\"max_age\":2592000,\"endpoints\":[{\"url\":\"https://csp.withgoogle.com/csp/report-to/amphtml-china-available\"}]}\";s:19:\"timing-allow-origin\";s:1:\"*\";s:14:\"content-length\";s:5:\"10246\";s:4:\"date\";s:29:\"Wed, 15 Sep 2021 17:46:01 GMT\";s:7:\"expires\";s:29:\"Wed, 15 Sep 2021 17:46:01 GMT\";s:13:\"cache-control\";s:53:\"private, max-age=3000, stale-while-revalidate=1206600\";s:4:\"etag\";s:18:\"\"dabead494b08a776\"\";s:25:\"strict-transport-security\";s:44:\"max-age=31536000; includeSubDomains; preload\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:6:\"server\";s:4:\"sffe\";s:16:\"x-xss-protection\";s:1:\"0\";s:7:\"alt-svc\";s:189:\"h3=\":443\"; ma=2592000,h3-29=\":443\"; ma=2592000,h3-T051=\":443\"; ma=2592000,h3-Q050=\":443\"; ma=2592000,h3-Q046=\":443\"; ma=2592000,h3-Q043=\":443\"; ma=2592000,quic=\":443\"; ma=2592000; v=\"46,43\"\";}s:58:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0status_code\";i:200;s:53:\"\0AmpProject\\AmpWP\\RemoteRequest\\CachedResponse\0expiry\";O:17:\"DateTimeImmutable\":3:{s:4:\"date\";s:26:\"2021-09-16 17:46:01.655597\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}}\";", "no");
INSERT INTO `theme_options` VALUES("69104", "product_cat_children", "a:26:{i:18;a:4:{i:0;i:23;i:1;i:24;i:2;i:25;i:3;i:26;}i:20;a:7:{i:0;i:28;i:1;i:29;i:2;i:30;i:3;i:31;i:4;i:32;i:5;i:33;i:6;i:34;}i:19;a:4:{i:0;i:35;i:1;i:36;i:2;i:37;i:3;i:38;}i:21;a:4:{i:0;i:39;i:1;i:40;i:2;i:41;i:3;i:42;}i:27;a:3:{i:0;i:43;i:1;i:44;i:2;i:45;}i:22;a:5:{i:0;i:46;i:1;i:47;i:2;i:48;i:3;i:49;i:4;i:50;}i:23;a:6:{i:0;i:52;i:1;i:53;i:2;i:54;i:3;i:55;i:4;i:56;i:5;i:57;}i:24;a:3:{i:0;i:58;i:1;i:59;i:2;i:60;}i:26;a:6:{i:0;i:61;i:1;i:62;i:2;i:63;i:3;i:64;i:4;i:65;i:5;i:66;}i:25;a:4:{i:0;i:67;i:1;i:68;i:2;i:69;i:3;i:70;}i:30;a:3:{i:0;i:71;i:1;i:72;i:2;i:73;}i:33;a:3:{i:0;i:74;i:1;i:75;i:2;i:76;}i:34;a:3:{i:0;i:77;i:1;i:78;i:2;i:79;}i:29;a:2:{i:0;i:80;i:1;i:81;}i:31;a:3:{i:0;i:82;i:1;i:83;i:2;i:84;}i:28;a:4:{i:0;i:85;i:1;i:86;i:2;i:87;i:3;i:88;}i:39;a:3:{i:0;i:89;i:1;i:90;i:2;i:91;}i:40;a:3:{i:0;i:118;i:1;i:119;i:2;i:120;}i:42;a:3:{i:0;i:121;i:1;i:122;i:2;i:123;}i:41;a:3:{i:0;i:124;i:1;i:125;i:2;i:126;}i:45;a:3:{i:0;i:127;i:1;i:128;i:2;i:129;}i:43;a:3:{i:0;i:130;i:1;i:131;i:2;i:132;}i:44;a:3:{i:0;i:133;i:1;i:134;i:2;i:135;}i:35;a:3:{i:0;i:136;i:1;i:137;i:2;i:138;}i:37;a:3:{i:0;i:139;i:1;i:140;i:2;i:141;}i:38;a:3:{i:0;i:142;i:1;i:143;i:2;i:144;}}", "yes");
INSERT INTO `theme_options` VALUES("13100", "duplicator_ui_view_state", "a:3:{s:24:\"dup-pack-installer-panel\";s:1:\"0\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:22:\"dup-pack-storage-panel\";s:1:\"0\";}", "yes");
INSERT INTO `theme_options` VALUES("13465", "wp_statistics", "a:29:{s:9:\"robotlist\";s:1715:\"007ac9\n5bot\nA6-Indexer\nAbachoBOT\naccoona\nAcoiRobot\nAddThis.com\nADmantX\nAdsBot-Google\nadvbot\nAhrefsBot\naiHitBot\nalexa\nalphabot\nAltaVista\nAntivirusPro\nanyevent\nappie\nApplebot\narchive.org_bot\nAsk Jeeves\nASPSeek\nBaiduspider\nBenjojo\nBeetleBot\nbingbot\nBlekkobot\nblexbot\nBOT for JCE\nbubing\nButterfly\ncbot\nclamantivirus\ncliqzbot\nclumboot\ncoccoc\ncrawler\nCrocCrawler\ncrowsnest.tv\ndbot\ndl2bot\ndotbot\ndownloadbot\nduckduckgo\nDumbot\nEasouSpider\neStyle\nEveryoneSocialBot\nExabot\nezooms\nfacebook.com\nfacebookexternalhit\nFAST\nFeedfetcher-Google\nfeedzirra\nfindxbot\nFirfly\nFriendFeedBot\nfroogle\nGeonaBot\nGigabot\ngirafabot\ngimme60bot\nglbot\nGooglebot\nGroupHigh\nia_archiver\nIDBot\nInfoSeek\ninktomi\nIstellaBot\njetmon\nKraken\nLeikibot\nlinkapediabot\nlinkdexbot\nLinkpadBot\nLoadTimeBot\nlooksmart\nltx71\nLycos\nMail.RU_Bot\nMe.dium\nmeanpathbot\nmediabot\nmedialbot\nMediapartners-Google\nMJ12bot\nmsnbot\nMojeekBot\nmonobot\nmoreover\nMRBOT\nNationalDirectory\nNerdyBot\nNetcraftSurveyAgent\nniki-bot\nnutch\nOpenbot\nOrangeBot\nowler\np4Bot\nPaperLiBot\npageanalyzer\nPagesInventory\nPimonster\nporkbun\npr-cy\nproximic\npwbot\nr4bot\nrabaz\nRambler\nRankivabot\nrevip\nriddler\nrogerbot\nScooter\nScrubby\nscrapy.org\nSearchmetricsBot\nsees.co\nSemanticBot\nSemrushBot\nSeznamBot\nsfFeedReader\nshareaholic-bot\nsistrix\nSiteExplorer\nSlurp\nSocialradarbot\nSocialSearch\nSogou web spider\nSpade\nspbot\nSpiderLing\nSputnikBot\nSuperfeedr\nSurveyBot\nTechnoratiSnoop\nTECNOSEEK\nTeoma\ntrendictionbot\nTweetmemeBot\nTwiceler\nTwitterbot\nTwitturls\nu2bot\nuMBot-LN\nuni5download\nunrulymedia\nUptimeRobot\nURL_Spider_SQL\nVagabondo\nvBSEO\nWASALive-Bot\nWebAlta Crawler\nWebBug\nWebFindBot\nWebMasterAid\nWeSEE\nWotbox\nwsowner\nwsr-agent\nwww.galaxy.com\nx100bot\nXoviBot\nxzybot\nyandex\nYahoo\nYammybot\nYoudaoBot\nZyBorg\nZemlyaCrawl\";s:13:\"anonymize_ips\";b:0;s:5:\"geoip\";b:0;s:10:\"useronline\";b:1;s:6:\"visits\";b:1;s:8:\"visitors\";b:1;s:5:\"pages\";b:1;s:12:\"check_online\";i:120;s:8:\"menu_bar\";b:0;s:11:\"coefficient\";i:1;s:12:\"stats_report\";b:0;s:11:\"time_report\";s:5:\"daily\";s:11:\"send_report\";s:4:\"mail\";s:14:\"content_report\";s:0:\"\";s:12:\"update_geoip\";b:1;s:8:\"store_ua\";b:0;s:21:\"exclude_administrator\";b:1;s:18:\"disable_se_clearch\";b:1;s:16:\"disable_se_qwant\";b:1;s:16:\"disable_se_baidu\";b:1;s:14:\"disable_se_ask\";b:1;s:8:\"map_type\";s:6:\"jqvmap\";s:18:\"force_robot_update\";b:1;s:9:\"ip_method\";s:11:\"REMOTE_ADDR\";s:17:\"exclude_loginpage\";b:1;s:12:\"exclude_404s\";b:1;s:13:\"exclude_feeds\";b:1;s:20:\"disable_donation_nag\";b:1;s:13:\"admin_notices\";b:0;}", "yes");
INSERT INTO `theme_options` VALUES("13466", "wp_statistics_plugin_version", "13.1.6", "yes");
INSERT INTO `theme_options` VALUES("13467", "wp_statistics_disable_addons", "yes", "yes");
INSERT INTO `theme_options` VALUES("13468", "widget_wp_statistics_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `theme_options` VALUES("13469", "wp_statistics_check_user_online", "1645376516", "yes");
INSERT INTO `theme_options` VALUES("13473", "wp_statistics_overview_page_ads", "a:3:{s:9:\"timestamp\";i:1645046808;s:3:\"ads\";a:6:{s:2:\"ID\";s:7:\"widgets\";s:5:\"title\";s:21:\"WP-Statistics Widgets\";s:4:\"link\";s:20:\"https://j.mp/3nosCVs\";s:5:\"image\";s:20:\"https://j.mp/3cmRBSQ\";s:7:\"_target\";s:3:\"yes\";s:6:\"status\";s:3:\"yes\";}s:4:\"view\";s:18:\"advanced-reporting\";}", "no");
INSERT INTO `theme_options` VALUES("13478", "elementor_allow_tracking", "no", "yes");
INSERT INTO `theme_options` VALUES("13479", "elementor_tracker_notice", "1", "yes");
INSERT INTO `theme_options` VALUES("14269", "wp_statistics_referrals_detail", "a:16:{s:14:\"instabotapp.ir\";a:3:{s:2:\"ip\";s:14:\"185.73.226.102\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:23:\"خانه - شاپینو\";}s:9:\"baidu.com\";a:3:{s:2:\"ip\";s:14:\"220.181.38.251\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:27:\"百度一下，你就知道\";}s:14:\"www.google.com\";a:3:{s:2:\"ip\";s:15:\"142.250.184.228\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:6:\"Google\";}s:11:\"zibabash.ir\";a:3:{s:2:\"ip\";s:14:\"185.165.31.185\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:89:\"زیبا باش - فروشگاه لوازم آرایشی، بهداشتی و زیبایی\";}s:17:\"www.site-shot.com\";a:3:{s:2:\"ip\";s:14:\"172.67.200.143\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:40:\"Site-Shot - Capture a Website screenshot\";}s:12:\"lab.onsec.ru\";a:3:{s:2:\"ip\";s:15:\"142.250.186.179\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:10:\"@ONsec_Lab\";}s:17:\"www.google.com.hk\";a:3:{s:2:\"ip\";s:14:\"142.250.186.99\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:6:\"Google\";}s:7:\"rfrr.ir\";a:3:{s:2:\"ip\";s:13:\"93.115.150.57\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:0:\"\";}s:17:\"www.rtl-theme.com\";a:3:{s:2:\"ip\";s:15:\"195.201.161.136\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:72:\"قالب وردپرس | خرید قالب وردپرس | راست چین\";}s:13:\"stuffgate.com\";a:3:{s:2:\"ip\";s:14:\"172.67.180.241\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:0:\"\";}s:14:\"www.amachap.ir\";a:3:{s:2:\"ip\";s:14:\"185.73.226.108\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:88:\"خانه - آما چاپ | خدمات چاپ و محصولات خام سابلیمیشن\";}s:19:\"shop.asemanbike.com\";a:3:{s:2:\"ip\";s:14:\"158.255.74.181\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:32:\"خانه - آسمان دوچرخ\";}s:22:\"www.taralightingco.com\";a:3:{s:2:\"ip\";s:14:\"116.202.224.76\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:167:\"صنایع روشنایی تارا | فروش اینترنتی انواع لامپ هالوژن ، لوستر ، آباژور و شمعدان + ارسال رایگان\";}s:12:\"asreenoo.com\";a:3:{s:2:\"ip\";s:13:\"185.94.99.174\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:21:\"خانه - عصرنو\";}s:9:\"kish.land\";a:3:{s:2:\"ip\";s:13:\"176.9.239.166\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:29:\"کـــیش لـــــند\";}s:12:\"www.bing.com\";a:3:{s:2:\"ip\";s:13:\"13.107.21.200\";s:7:\"country\";s:3:\"000\";s:5:\"title\";s:4:\"Bing\";}}", "no");
INSERT INTO `theme_options` VALUES("85425", "_transient_timeout_mc4wp_mailchimp_lists", "1645425389", "no");
INSERT INTO `theme_options` VALUES("85426", "_transient_mc4wp_mailchimp_lists", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("81232", "_transient_timeout_wc_product_children_1027", "1647528355", "no");
INSERT INTO `theme_options` VALUES("81233", "_transient_wc_product_children_1027", "a:2:{s:3:\"all\";a:0:{}s:7:\"visible\";a:0:{}}", "no");
INSERT INTO `theme_options` VALUES("81234", "_transient_timeout_wc_var_prices_1027", "1647607956", "no");
INSERT INTO `theme_options` VALUES("81235", "_transient_wc_var_prices_1027", "{\"version\":\"1645015929\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":[],\"regular_price\":[],\"sale_price\":[]}}", "no");
INSERT INTO `theme_options` VALUES("85777", "rewrite_rules", "a:209:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:47:\"(([^/]+/)*wishlist)(/(.*))?/page/([0-9]{1,})/?$\";s:76:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]&paged=$matches[5]\";s:30:\"(([^/]+/)*wishlist)(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&wishlist-action=$matches[4]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=271&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `theme_options` VALUES("82003", "_transient_timeout_yith_wcwl_hidden_products", "1647618772", "no");
INSERT INTO `theme_options` VALUES("82004", "_transient_yith_wcwl_hidden_products", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("85751", "_site_transient_timeout_theme_roots", "1645365371", "no");
INSERT INTO `theme_options` VALUES("85752", "_site_transient_theme_roots", "a:1:{s:7:\"Shapino\";s:7:\"/themes\";}", "no");
INSERT INTO `theme_options` VALUES("60763", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1645906236", "no");
INSERT INTO `theme_options` VALUES("60764", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:34:{s:27:\"stripe_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"stripe_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:380:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/stripe/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#apple-pay\">enable Apple Pay with Stripe</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"stripe_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}s:27:\"square_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"square_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:393:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/woocommerce-square/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#section-14\">enable Apple Pay with Square</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"square_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}}}s:26:\"wcpay_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"wcpay_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:338:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/payments/apple-pay/\">enable Apple Pay with WooCommerce Payments</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"wcpay_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:15:\"&page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:14:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:45:\"https://woocommerce.com/woocommerce-shipping/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:31:\"https://woocommerce.com/mobile/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:16:48\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:251:\"WooCommerce Shipping & Tax helps get your store \"ready to sell\" as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:17:25\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:270:\"Product Add-Ons allow your customers to personalize products while they\'re shopping on your online store. No more follow-up email requests—customers get what they want, before they\'re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:18:01\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:18:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:175:\"Deciding what to start with first is tricky. To help you properly prioritize, we’ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:20:31\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:39:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:26:\"ecomm-wc-navigation-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"ecomm-wc-navigation-survey\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"We’d like your feedback on the WooCommerce navigation\";s:7:\"content\";s:134:\"We’re making improvements to the WooCommerce navigation and would love your feedback. Share your experience in this 2 minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:63:\"https://automattic.survey.fm/feedback-on-woocommerce-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:38:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:90;}}}s:43:\"wc_simple_payments_m2_reader_launch_q1_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"wc_simple_payments_m2_reader_launch_q1_2022\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Take quick and easy in-person payments\";s:7:\"content\";s:300:\"WooCommerce is continuing to power up your business with our new Simple Payments feature, built exclusively for WooCommerce In-Person Payments. Capture quick and simple payments anywhere else your customers are – or offer a local pickup option with payment taken in-person for orders placed online.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"wc_simple_payments_m2_reader_launch_q1_2022\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:43:\"https://woocommerce.com/in-person-payments/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-02-04 00:00:43\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-02-24 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:22:\"wcpay_applepay_q1_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:22:\"wcpay_applepay_q1_2022\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Increase conversions with Apple Pay – just like Diane does\";s:7:\"content\";s:472:\"See how Diane from <a href=\"https://woocommerce.com/posts/lady-dye-yarns-from-crafts-to-activism-with-woocommerce/?utm_source=product&amp;utm_medium=inboxnotification&amp;utm_campaign=apple-pay\" target=\"_blank\">Lady Dye Yarns</a> uses Apple Pay to provide customers with the fast, secure checkout experience they love. You can, too – Apple Pay is included in WooCommerce Payments. Here\'s how you can increase conversions by encouraging shoppers to pay with a single tap.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"wcpay_applepay_q1_2022\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:39:\"Let your customers know about Apple Pay\";}}s:3:\"url\";s:48:\"https://developer.apple.com/apple-pay/marketing/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-02-07 00:00:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-03-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:23:\"stripe_applepay_q1_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:23:\"stripe_applepay_q1_2022\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with Apple Pay – just like Thomas does\";s:7:\"content\";s:521:\"Read the inspirational story of <a href=\"https://woocommerce.com/posts/incredible-story-of-thomas-trendy-socks-down-syndrome-entrepreneur/?utm_source=product&amp;utm_medium=inboxnotification&amp;utm_campaign=apple-pay\" target=\"_blank\">Thomas\'s Trendy Socks</a> and see how he’s using Apple Pay to provide customers with the fast, secure checkout experience they love. You can, too – ready to turn more visitors into buyers? Accept Apple Pay by selecting Enable express checkouts in Settings &gt; Payments &gt; Stripe.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:23:\"stripe_applepay_q1_2022\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Add Apple Pay\";}}s:3:\"url\";s:45:\"&page=wc-settings&tab=checkout&section=stripe\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-02-07 00:00:33\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-03-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}}}s:23:\"square_applepay_q1_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:23:\"square_applepay_q1_2022\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Increase conversions with a faster checkout experience\";s:7:\"content\";s:252:\"By enabling Apple Pay in Square, your customers can complete purchases quickly and securely with a single touch or a glance – no lengthy checkout forms necessary. Accept Apple Pay by enabling Digital Wallets within Settings &gt; Payments &gt; Square.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:23:\"square_applepay_q1_2022\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Add Apple Pay\";}}s:3:\"url\";s:28:\"&page=wc-settings&tab=square\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-02-07 00:00:11\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-03-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}}}}}s:29:\"lead_gen_existing_customers_1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"lead_gen_existing_customers_1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:20:\"Talk to a consultant\";s:7:\"content\";s:164:\"As your business grows, you want to optimize costs, streamline operations, and sell more. We can help. Talk to us about how you can get the most out of WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:29:\"lead_gen_existing_customers_1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Yes, please\";}}s:3:\"url\";s:61:\"https://woocommerce.com/take-your-business-to-the-next-level/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-02-10 18:10:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2022-02-27 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"ZA\";}}}}}}", "no");
INSERT INTO `theme_options` VALUES("63218", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `theme_options` VALUES("85804", "woocommerce_admin_version", "3.1.0", "yes");
INSERT INTO `theme_options` VALUES("85807", "_elementor_global_css", "a:6:{s:4:\"time\";i:1645362581;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `theme_options` VALUES("85808", "_elementor_assets_data", "a:1:{s:3:\"css\";a:1:{s:7:\"widgets\";a:15:{s:17:\"suggestion_moment\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:11:\"imageslider\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:15:\"feauturewidgets\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:14:\"categoryBanner\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:21:\"categorytitlecarousel\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:16:\"caruselwidgetoff\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:13:\"caruselwidget\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:15:\"categorybanner2\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:15:\"categorybanner3\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:24:\"caruselwidgetsupermarket\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:9:\"mailchimp\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:14:\"lastpostwidget\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:7:\"heading\";a:2:{s:7:\"content\";s:672:\"<style>/*! elementor - v3.5.5 - 03-02-2022 */\n.elementor-heading-title{padding:0;margin:0;line-height:1}.elementor-widget-heading .elementor-heading-title[class*=elementor-size-]>a{color:inherit;font-size:inherit;line-height:inherit}.elementor-widget-heading .elementor-heading-title.elementor-size-small{font-size:15px}.elementor-widget-heading .elementor-heading-title.elementor-size-medium{font-size:19px}.elementor-widget-heading .elementor-heading-title.elementor-size-large{font-size:29px}.elementor-widget-heading .elementor-heading-title.elementor-size-xl{font-size:39px}.elementor-widget-heading .elementor-heading-title.elementor-size-xxl{font-size:59px}</style>\";s:7:\"version\";s:5:\"3.5.5\";}s:9:\"questions\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}s:6:\"brands\";a:2:{s:7:\"content\";s:0:\"\";s:7:\"version\";s:5:\"3.5.5\";}}}}", "yes");
INSERT INTO `theme_options` VALUES("60996", "dgwt_wcas_settings_version", "1", "yes");
INSERT INTO `theme_options` VALUES("61004", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `theme_options` VALUES("61005", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `theme_options` VALUES("61006", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `theme_options` VALUES("75450", "_transient_timeout_wc_shipping_method_count_legacy", "1646440675", "no");
INSERT INTO `theme_options` VALUES("75451", "_transient_wc_shipping_method_count_legacy", "a:2:{s:7:\"version\";s:10:\"1628194187\";s:5:\"value\";i:0;}", "no");
INSERT INTO `theme_options` VALUES("67631", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:3;s:3:\"all\";i:3;s:8:\"approved\";s:1:\"3\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `theme_options` VALUES("76460", "_transient_timeout_rsssl_admin_notices", "1645450383", "no");
INSERT INTO `theme_options` VALUES("76461", "_transient_rsssl_admin_notices", "a:0:{}", "no");
INSERT INTO `theme_options` VALUES("85460", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1645430328", "no");
INSERT INTO `theme_options` VALUES("85461", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `theme_options` VALUES("85464", "_transient_timeout_wpseo_unindexed_post_link_count", "1645430328", "no");
INSERT INTO `theme_options` VALUES("85465", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `theme_options` VALUES("85466", "_transient_timeout_wpseo_unindexed_term_link_count", "1645430328", "no");
INSERT INTO `theme_options` VALUES("85467", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `theme_options` VALUES("80891", "_site_transient_timeout_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "1645514514", "no");
INSERT INTO `theme_options` VALUES("80892", "_site_transient_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `theme_options` VALUES("85462", "_transient_timeout_wpseo_total_unindexed_general_items", "1645430328", "no");
INSERT INTO `theme_options` VALUES("85463", "_transient_wpseo_total_unindexed_general_items", "0", "no");
INSERT INTO `theme_options` VALUES("85469", "_transient_rsssl_certinfo", "a:16:{s:4:\"name\";s:18:\"/CN=instabotapp.ir\";s:7:\"subject\";a:1:{s:2:\"CN\";s:14:\"instabotapp.ir\";}s:4:\"hash\";s:8:\"2fff4ba7\";s:6:\"issuer\";a:3:{s:1:\"C\";s:2:\"US\";s:1:\"O\";s:13:\"Let\'s Encrypt\";s:2:\"CN\";s:2:\"R3\";}s:7:\"version\";i:2;s:12:\"serialNumber\";s:42:\"366575469278055858082712952067421532485520\";s:15:\"serialNumberHex\";s:36:\"043544BB50E811CE4C7D00A4B0785E0A7790\";s:9:\"validFrom\";s:13:\"220203194930Z\";s:7:\"validTo\";s:13:\"220504194929Z\";s:16:\"validFrom_time_t\";i:1643917770;s:14:\"validTo_time_t\";i:1651693769;s:15:\"signatureTypeSN\";s:10:\"RSA-SHA256\";s:15:\"signatureTypeLN\";s:23:\"sha256WithRSAEncryption\";s:16:\"signatureTypeNID\";i:668;s:8:\"purposes\";a:9:{i:1;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslclient\";}i:2;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslserver\";}i:3;a:3:{i:0;b:1;i:1;b:0;i:2;s:11:\"nssslserver\";}i:4;a:3:{i:0;b:0;i:1;b:0;i:2;s:9:\"smimesign\";}i:5;a:3:{i:0;b:0;i:1;b:0;i:2;s:12:\"smimeencrypt\";}i:6;a:3:{i:0;b:0;i:1;b:0;i:2;s:7:\"crlsign\";}i:7;a:3:{i:0;b:1;i:1;b:1;i:2;s:3:\"any\";}i:8;a:3:{i:0;b:1;i:1;b:0;i:2;s:10:\"ocsphelper\";}i:9;a:3:{i:0;b:0;i:1;b:0;i:2;s:13:\"timestampsign\";}}s:10:\"extensions\";a:9:{s:8:\"keyUsage\";s:35:\"Digital Signature, Key Encipherment\";s:16:\"extendedKeyUsage\";s:60:\"TLS Web Server Authentication, TLS Web Client Authentication\";s:16:\"basicConstraints\";s:8:\"CA:FALSE\";s:20:\"subjectKeyIdentifier\";s:59:\"28:47:B7:69:94:34:F2:8A:F5:45:D0:B0:A3:41:10:B0:C4:B3:75:67\";s:22:\"authorityKeyIdentifier\";s:66:\"keyid:14:2E:B3:17:B7:58:56:CB:AE:50:09:40:E6:1F:AF:9D:8B:14:C2:C6\n\";s:19:\"authorityInfoAccess\";s:73:\"OCSP - URI:http://r3.o.lencr.org\nCA Issuers - URI:http://r3.i.lencr.org/\n\";s:14:\"subjectAltName\";s:42:\"DNS:instabotapp.ir, DNS:www.instabotapp.ir\";s:19:\"certificatePolicies\";s:89:\"Policy: 2.23.140.1.2.1\nPolicy: 1.3.6.1.4.1.44947.1.1.1\n  CPS: http://cps.letsencrypt.org\n\";s:15:\"ct_precert_scts\";s:1152:\"Signed Certificate Timestamp:\n    Version   : v1(0)\n    Log ID    : 29:79:BE:F0:9E:39:39:21:F0:56:73:9F:63:A5:77:E5:\n                BE:57:7D:9C:60:0A:F8:F9:4D:5D:26:5C:25:5D:C7:84\n    Timestamp : Feb  3 20:49:30.792 2022 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:45:02:20:35:94:4C:4D:A9:EC:8D:9B:46:66:27:CF:\n                A9:7B:D3:98:4F:8B:6D:65:16:D9:B0:7D:8E:8E:56:8A:\n                D6:73:94:D9:02:21:00:E2:1E:5C:9D:A3:88:2A:89:CB:\n                BD:4C:79:43:D0:E1:15:91:6D:8C:C2:38:96:17:F8:BF:\n                8C:59:2A:DD:89:27:99\nSigned Certificate Timestamp:\n    Version   : v1(0)\n    Log ID    : 6F:53:76:AC:31:F0:31:19:D8:99:00:A4:51:15:FF:77:\n                15:1C:11:D9:02:C1:00:29:06:8D:B2:08:9A:37:D9:13\n    Timestamp : Feb  3 20:49:30.849 2022 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:44:02:20:46:3E:2A:56:5A:AC:E6:60:8F:4C:D2:0E:\n                68:FA:80:D5:7B:4B:7B:B3:09:50:40:96:F6:1F:2D:E5:\n                0E:8D:CE:20:02:20:24:95:B3:5A:DD:83:09:1D:C4:F8:\n                E2:9B:DD:BF:A0:94:01:81:35:DA:A4:59:16:71:98:0A:\n                7A:3A:19:76:3C:79\";}}", "no");
INSERT INTO `theme_options` VALUES("84940", "_transient_timeout_wc_related_1025", "1645372325", "no");
INSERT INTO `theme_options` VALUES("84941", "_transient_wc_related_1025", "a:1:{s:52:\"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1025\";a:12:{i:0;s:3:\"287\";i:1;s:4:\"1020\";i:2;s:4:\"1022\";i:3;s:4:\"1027\";i:4;s:4:\"1259\";i:5;s:4:\"1262\";i:6;s:4:\"1265\";i:7;s:4:\"1267\";i:8;s:4:\"1270\";i:9;s:4:\"1273\";i:10;s:4:\"1276\";i:11;s:4:\"1278\";}}", "no");
INSERT INTO `theme_options` VALUES("85468", "_transient_timeout_rsssl_certinfo", "1645430328", "no");
INSERT INTO `theme_options` VALUES("81732", "_transient_timeout_orders-all-statuses", "1645616567", "no");
INSERT INTO `theme_options` VALUES("81733", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1640449232\";s:5:\"value\";a:0:{}}", "no");
INSERT INTO `theme_options` VALUES("81885", "_transient_timeout_wc_term_counts", "1647647134", "no");
INSERT INTO `theme_options` VALUES("81886", "_transient_wc_term_counts", "a:44:{i:61;s:1:\"2\";i:136;s:1:\"4\";i:87;s:1:\"3\";i:55;s:1:\"5\";i:69;s:1:\"1\";i:35;s:1:\"4\";i:23;s:1:\"5\";i:28;s:1:\"3\";i:26;s:1:\"4\";i:19;s:1:\"4\";i:18;s:2:\"13\";i:25;s:1:\"4\";i:20;s:1:\"3\";i:65;s:1:\"2\";i:68;s:1:\"2\";i:176;s:1:\"4\";i:175;s:1:\"4\";i:171;s:1:\"4\";i:173;s:1:\"4\";i:172;s:1:\"4\";i:174;s:1:\"4\";i:117;s:1:\"5\";i:96;s:1:\"5\";i:97;s:1:\"5\";i:95;s:1:\"5\";i:94;s:1:\"5\";i:145;s:1:\"3\";i:150;s:1:\"2\";i:146;s:1:\"3\";i:147;s:1:\"3\";i:151;s:1:\"1\";i:149;s:1:\"1\";i:148;s:1:\"1\";i:165;s:1:\"8\";i:164;s:1:\"4\";i:162;s:1:\"4\";i:163;s:1:\"4\";i:168;s:1:\"4\";i:166;s:1:\"4\";i:169;s:1:\"4\";i:167;s:1:\"4\";i:170;s:1:\"4\";i:67;s:1:\"1\";i:152;s:1:\"1\";}", "no");
INSERT INTO `theme_options` VALUES("84913", "_transient_timeout_wc_related_1037", "1645368685", "no");
INSERT INTO `theme_options` VALUES("84914", "_transient_wc_related_1037", "a:1:{s:52:\"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=1037\";a:2:{i:0;s:3:\"693\";i:1;s:4:\"1033\";}}", "no");
INSERT INTO `theme_options` VALUES("80889", "_site_transient_timeout_browser_44ba4bd2ab021ee49477f1f0798ce185", "1645514513", "no");
INSERT INTO `theme_options` VALUES("80890", "_site_transient_browser_44ba4bd2ab021ee49477f1f0798ce185", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"83.0.4103.101\";s:8:\"platform\";s:7:\"Android\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:1;}", "no");
INSERT INTO `theme_options` VALUES("85553", "_transient_timeout_wc_onboarding_product_data", "1645438700", "no");
INSERT INTO `theme_options` VALUES("85554", "_transient_wc_onboarding_product_data", "a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:19:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 20 Feb 2022 10:18:20 GMT\";s:12:\"content-type\";s:31:\"application/json; charset=UTF-8\";s:14:\"content-length\";s:5:\"12857\";s:12:\"x-robots-tag\";s:7:\"noindex\";s:4:\"link\";s:60:\"<https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:29:\"access-control-expose-headers\";s:33:\"X-WP-Total, X-WP-TotalPages, Link\";s:28:\"access-control-allow-headers\";s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";s:13:\"x-wccom-cache\";s:3:\"HIT\";s:13:\"cache-control\";s:10:\"max-age=60\";s:5:\"allow\";s:3:\"GET\";s:4:\"x-rq\";s:13:\"hhn2 0 4 9980\";s:16:\"content-encoding\";s:4:\"gzip\";s:3:\"age\";s:2:\"40\";s:7:\"x-cache\";s:3:\"hit\";s:4:\"vary\";s:23:\"Accept-Encoding, Origin\";s:13:\"accept-ranges\";s:5:\"bytes\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}}s:4:\"body\";s:70976:\"{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2016\\/01\\/woo-Google_Analytics-fvsrvf.png\"},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Automatically calculate how much sales tax should be collected for WooCommerce orders - by city, country, or state - at checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/12\\/stripe-app-icon-7m1xi7.png\"},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2017\\/11\\/Jetpack-1-m5mwyg.png\",\"excerpt\":\"Security, performance, and marketing tools made for WooCommerce stores by the WordPress experts. Get started with basic security and speed tools for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Jetpack\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/jetpack\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2021\\/02\\/jetpack-logo--80sgtq.png\"},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297,\"rating\":2,\"reviews_count\":55,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"The only payment solution fully integrated to Woo. Accept credit\\/debit cards &amp; local payment options with no setup or monthly fees.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/02\\/woo-WooCommerce_Payments-mtulxp.png\"},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816,\"rating\":3.6,\"reviews_count\":11,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/08\\/woo-Amazon_Pay-8lvfuy.png\"},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503,\"rating\":3.2,\"reviews_count\":65,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2016\\/07\\/woo-Square-u8km15.png\"},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147,\"rating\":3.4,\"reviews_count\":40,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"PayPal Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Dark.png\",\"excerpt\":\"PayPal Checkout now with Smart Payment Buttons\\u2122, dynamically displays, PayPal, Venmo, PayPal Credit, or other local payment options in a single stack giving customers the choice to pay with their preferred option.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"69e6cba62ac4021df9e117cc3f716d07\",\"slug\":\"woocommerce-gateway-paypal-express-checkout\",\"id\":1597922,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618,\"rating\":3,\"reviews_count\":21,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Mailchimp\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/mailchimp\\/\",\"icon\":null},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/woo-Shipstation-xqap96.png\"},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/09\\/woo-Payfast-murskg.png\"},{\"title\":\"Google Listings &amp; Ads\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/06\\/marketplace-card.png\",\"excerpt\":\"Reach millions of engaged shoppers across Google with free product listings and ads. Built in partnership with Google.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-listings-and-ads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"118f4d86-f126-4c3a-8525-644e3170d161\",\"slug\":\"google-listings-and-ads\",\"id\":7623964,\"rating\":3,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2021\\/06\\/woo-GoogleListingsAds-jworee.png\"},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/woo-USPS-yhn1rb.png\"},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665,\"rating\":3.4,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayPal Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/PPCP-Tile-PayPal-Logo-and-Cart-Art-2x-2-uozwz8.jpg\",\"excerpt\":\"PayPal\'s latest, all-in-one checkout solution. Securely accept PayPal Digital Payments, credit\\/debit cards and local payment methods.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paypal-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"934115ab-e3f3-4435-9580-345b1ce21899\",\"slug\":\"woocommerce-paypal-payments\",\"id\":6410731,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/woo-PayPal-nlioum.png\"},{\"title\":\"Google Ads &amp; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145,\"rating\":4.4,\"reviews_count\":109,\"vendor_name\":\"Kliken\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/kliken\\/\",\"icon\":null},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693,\"rating\":3.1,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890,\"rating\":2.7,\"reviews_count\":18,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/woo-CanadaPost-fjlcfq.png\"},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2016\\/02\\/woo-Braintree-wrweyl.png\"},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Power your membership association, online magazine, elearning sites, and more with access control to content\\/products and member discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589,\"rating\":4.4,\"reviews_count\":78,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/woo-FedEx-auxjb7.png\"},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/woo-RoyalMail-sd9zwy.png\"},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/07\\/logo-pb-lzevsq.png\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages, and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716,\"rating\":4.9,\"reviews_count\":115,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Multichannel for WooCommerce: Google, Amazon, eBay &amp; Walmart Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/Woo-Extension-Store-Logo-v2.png\",\"excerpt\":\"Get the official Google, Amazon, eBay and Walmart extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890,\"rating\":3.1,\"reviews_count\":33,\"vendor_name\":\"Codisto\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/codisto\\/\",\"icon\":null},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982,\"rating\":3,\"reviews_count\":16,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/woocommerce-xero-integration-sdth2k.jpg\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/woo-Xero-4ovyoc.png\"},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/10\\/woo-AutomateWoo-m4jpva.png\"},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481,\"rating\":4.7,\"reviews_count\":44,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Live Chat\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/live-chat\\/\",\"icon\":null},{\"title\":\"Storefront Homepage Contact Section\",\"image\":\"\",\"excerpt\":\"Add a Contact section to the Storefront homepage.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/storefront-homepage-contact-section\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"cb12b87f8bbb0139dafbf92ca1f871ef\",\"slug\":\"storefront-homepage-contact-section\",\"id\":1468793,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259,\"rating\":2.9,\"reviews_count\":11,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Storefront Footer Bar\",\"image\":\"\",\"excerpt\":\"Adds a full-width widget region above the Storefront footer widget area, which can be customized with colors and a background image.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/storefront-footer-bar\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"6cfd3d4f923cafa16e4801ae801751f4\",\"slug\":\"storefront-footer-bar\",\"id\":1434472,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652,\"rating\":4.5,\"reviews_count\":22,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/02\\/woo-AmazonS3Storage-jhzxk2.png\"},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729,\"rating\":4.5,\"reviews_count\":126,\"vendor_name\":\"StoreApps\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/storeapps\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/wc-icon-smart-coupons-160-p8fwgu.png\"},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Automate sales tax compliance for your multi-channel e-commerce business. Accurate sales tax calculations, data aggregation, quality reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"TaxJar\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/taxjar\\/\",\"icon\":null},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate your WooCommerce store with 4000+ cloud apps and services today. Trusted by 11,000+ users.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589,\"rating\":4.5,\"reviews_count\":35,\"vendor_name\":\"OM4\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/om4\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/OM4-Software-Logo-RGB-Round-160x160-1-372opg.png\"},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/06\\/WooCommerce-icon-160x160-1-3o68ab.jpg\"},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on-time tax filing. No more tracking sales tax rates and rules.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738,\"rating\":5,\"reviews_count\":52,\"vendor_name\":\"Backcourt Development\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/backcourt-development\\/\",\"icon\":null},{\"title\":\"Sensei LMS Course Progress\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/sensei-course-progress.png\",\"excerpt\":\"Enable your students to easily see their progress and pick up where they left off in a course.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sensei-course-progress\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ec0f55d8fa7c517dc1844f5c873a77da\",\"slug\":\"sensei-course-progress\",\"id\":435833,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643,\"rating\":3.4,\"reviews_count\":27,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Storefront Reviews\",\"image\":\"\",\"excerpt\":\"Reviews can often be the deciding factor when making a purchase online. Highlight your best reviews on your homepage, or across your site with Storefront Reviews.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/storefront-reviews\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/reviews\\/\",\"price\":\"&#36;19.00\",\"hash\":\"0c8a1d86b8eff9f1edffa923aeb3fc1f\",\"slug\":\"storefront-reviews\",\"id\":1044976,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666,\"rating\":4.3,\"reviews_count\":27,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed rich product data to Google Merchant Center for setting up free product listings, product ads, and local inventory campaigns. Full control over your field mappings, and feed content so you can maximize campaign performance and ad spend.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619,\"rating\":4.2,\"reviews_count\":37,\"vendor_name\":\"Ademti Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/ademti-software\\/\",\"icon\":null},{\"title\":\"Sensei LMS Certificates\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/sensei-certificates.png\",\"excerpt\":\"Award your students with a certificate of completion and a sense of accomplishment after finishing a course.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sensei-certificates\\/?utm_source=extensio