<?php get_header();?>
<div class="site-center">
    <div class="content">
        <h1 class="archive-title"><?php single_cat_title();?></h1>
        <div class="clear"></div>
        <?php if (category_description()) : ?>
            <div class="archive-description"><?php echo category_description(); ?></div>
        <?php endif;?>
        <div class="clear"></div>


        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

        <div class="index-article">
            <?php if(get_theme_mod('date-article')==1):?>
                <div class="article-date">
                    <?php the_time( 'd F Y' ); ?>
                </div>
            <?php endif;?>

            <?php if ( has_post_thumbnail() ) : ?>
                <div class="index-article-img"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a></div>
            <?php else:?>
                <div class="index-article-img"><a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/no-thumbnail.png" ></a></div>        
            <?php endif;?>
            <a href="<?php the_permalink(); ?>"><span class="index-article-title"><?php echo wp_trim_words(get_the_title(),10,' ...'); ?></span></a>
            <div class="read-more"><a href="<?php the_permalink(); ?>"><?php _e('مطالعه مطلب','shapino');?></a></div>
        </div>

        <?php endwhile;?>
        <div class="clear"></div>
        <div class="number-page">
            <?php mihanwp_numeric_posts_nav(); ?>
        </div>
        <?php endif;?>

    </div>

    <?php get_sidebar();?>
    <div class="clear"></div>
</div>

<?php get_footer();?>