<?php get_header();?>

<div class="site-center">
            <div class="content">
                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                    <article>
                        <h1 class="post-title"><?php the_title();?></h1>

                        <div class="post-info">
                            <?php if(get_theme_mod("author-single-page")==1):?>
                                <span class="post-icon-post"><?php _e('نویسنده','shapino');?> : <?php the_author();?></span>
                            <?php endif;?>

                            <?php if(get_theme_mod("date-article-single-page")==1):?>
                                <span class="post-icon-date"><?php _e('تاریخ انتشار','shapino');?> : <?php the_date();?></span>
                            <?php endif;?>

                            <?php if(get_theme_mod("category-single-page")==1):?>
                                <span class="post-icon-category"><?php _e('دسته بندی','shapino');?> : <?php the_category(' ، ');?></span>
                            <?php endif;?>
                        </div>
                        <div class="thumbnail-post"><?php the_post_thumbnail(); ?></div>
                        <?php the_content();?>
                        <?php if (has_tag()):?>
                            <?php if(get_theme_mod("tags-single-page")==1):?>
                                <span class="tag-none"><?php $tags=_e('برچسب ها : ','shapino');?></span>
                                <span class="post-icon-tags"><?php echo the_tags($tags .' #',' #'); ?></span>
                                <span class="post-icon-tags-ltr"><?php echo the_tags($tags .'#','# '); ?></span>
                            <?php endif;?>
                        <?php endif;?>

                        <?php if(get_theme_mod("share-single-page")==1):?>
                            <span id="share-icon">
                                <a href="javascript:void(0);">
                                    <i class="fas fa-share-alt"></i>
                                    <?php _e('اشتراک گذاری','shapino');?>
                                </a>
                            </span>
                        <?php endif;?>
                        <div class="clear"></div>
                    </article>
                    <div class="comments-box">
                        <?php comments_template();?>
                    </div>
                <?php endwhile;?>
                <?php endif;?>

            </div>

        <?php get_sidebar();?>
        </div>

        <div class="clear"></div>



        <div id="share-background"></div>
        <div id="share">
            <div class="top-share">
                <span><?php _e('اشتراک گذاری در','shapino');?></span>
                <i class="fas fa-times" id="close-share"></i>
            </div>
            <ul>
                <a target="_blank" href="https://wa.me/?text=<?php echo wp_get_shortlink();?>"><li><i class="fab fa-whatsapp"></i></li></a>
                <a target="_blank" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink();?>"><li><i class="fab fa-telegram-plane"></i></li></a>
                <a target="_blank" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink();?>"><li><i class="fab fa-twitter"></i></li></a>
                <a href="mailto:?body=<?php echo wp_get_shortlink();?>"><li><i class="far fa-envelope"></i></li></a>
                <a href="sms:/* phone number here */?body=/* <?php echo wp_get_shortlink();?> */"><li><i class="fas fa-sms"></i></li></a>

                    
            </ul>
            <div class="clear"></div>
            <span class="link-post" id="link-post"><?php echo wp_get_shortlink();?></span>
            <div class="clear"></div>


            <button onclick="copyToClipboard('#link-post')" class="copy-link" id='copy-link'>
                <?php _e('کپی لینک','shapino');?>
                <i class="far fa-copy"></i>
            </button>
            <span class="copyed-link-post" id="copyed-link-post"><?php _e('لینک کپی شد','shapino');?></span>
        </div>


        
<?php get_footer();?>