<?php
class Elementor_carusel_Widget_off extends \Elementor\Widget_Base {

	public function get_name() {
    return 'caruselwidgetoff';
  }

	public function get_title() {
    return __('اسلایدر محصولات پیشنهاده ویژه','shapino');
  }

	public function get_icon() {
    return 'fas fa-percent';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'اسلایدر محصولات پیشنهاده ویژه', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);


$this->add_control(
  'categoryid',
  [
    'label' => __( 'آیدی دسته بندی محصولات پیشنهاد ویژه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 44', 'shapino' ),
  ]
);
$this->add_control(
  'colorBack',
  [
    'label' => __( 'رنگ پس زمینه ', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'image',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'description' => __("سایز تصویر باید 311*180 باشد",'shapino'),
  ]
);

$this->add_control(
  'image2',
  [
    'label' => __( 'تصویر ریسپانسیو', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'description' => __("سایز تصویر باید 123*330 باشد",'shapino'),
  ]
);




$this->add_control(
  'show_countainer',
  [
    'label' => esc_html__( 'شمارش معکوس', 'plugin-name' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'your-plugin' ),
    'label_off' => esc_html__( 'غیر فعال', 'your-plugin' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);


$this->add_control(
  'countainer_daily',
  [
    'label' => esc_html__( 'شمارش معکوس روزانه', 'plugin-name' ),
    'type' => \Elementor\Controls_Manager::SWITCHER,
    'label_on' => esc_html__( 'فعال', 'your-plugin' ),
    'label_off' => esc_html__( 'غیر فعال', 'your-plugin' ),
    'return_value' => 'yes',
    'default' => 'yes',
  ]
);


$this->add_control(
  'due_date',
  [
    'label' => esc_html__( 'تاریخ و ساعت پایان پیشنهاد ویژه', 'plugin-name' ),
    'type' => \Elementor\Controls_Manager::DATE_TIME,
  ]
);

$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();


    if (is_admin())
    {
      // solves the width issue
      // The javascript called after elementor scripts are fully loaded.
      if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
          return;
      }
      ?>
      		<script>	
            $('.owl-carousel2').owlCarousel({
                nav:true,
                rtl:true,
                loop:false,
                margin:0,
                dots:false,
                responsive:{
                    0:{
                        items:2
                    },
                
                    600:{
                        items:2
                    },
                    1000:{
                        items:3
                    }
                }
            });
          </script>


      <?php
    }



    $category_link = get_category_link( $settings['categoryid']);
    $background=$settings['colorBack']; 
    $image=$settings['image']['url'];
    $image2=$settings['image2']['url'];
    $show_countainer = $settings['show_countainer'];
    $countainer_daily = $settings['countainer_daily'];
    $due_date=$settings['due_date'];
    ?>

<script>
function numberToPersian(number) {
     const persian = { 0: "۰", 1: "۱", 2: "۲", 3: "۳", 4: "۴", 5: "۵", 6: "۶", 7: "۷", 
     8: "۸", 9: "۹" };
     number = number.toString().split("");
     let persianNumber = ""
     for (let i = 0; i < number.length; i++) {
          number[i] = persian[number[i]];
     }
     for (let i = 0; i < number.length; i++) {
          persianNumber += number[i];
     }
     return persianNumber;
}

function countDaily(){
  let counter = setInterval(countainer,1000);
  function countainer(){
      let nowDate=new Date();
      let lastToday=new Date(nowDate.getFullYear(),nowDate.getMonth(),nowDate.getDate(),23,59,59);

      let discount = lastToday.getTime() - nowDate.getTime() ;


      let hours= Math.floor((discount / (1000*60*60)));
      let minutes= Math.floor((discount % (1000*60*60))/(1000*60));
      let seconds= Math.floor((discount % (1000*60))/(1000));

      hours=numberToPersian(hours);
      minutes=numberToPersian(minutes);
      seconds=numberToPersian(seconds);

      let resault=`${hours}:${minutes}:${seconds}`;

      let items=document.querySelectorAll(".countdown");
      for(let i of items){
        i.textContent=resault;
      }


  }
}
function countWithDate(year,month,day,houre,minute,second){
  let yourDate=new Date(year,month-1,day,houre,minute,second);
  let counter = setInterval(countainer,1000);
  function countainer(){
      let nowDate=new Date();

      let discount = yourDate.getTime() - nowDate.getTime() ;

      let hours= Math.floor((discount / (1000*60*60)));
      let minutes= Math.floor((discount % (1000*60*60))/(1000*60));
      let seconds= Math.floor((discount % (1000*60))/(1000));

      hours=numberToPersian(hours);
      minutes=numberToPersian(minutes);
      seconds=numberToPersian(seconds);

      let resault=`${hours}:${minutes}:${seconds}`;

      let items=document.querySelectorAll(".countdown");
      for(let i of items){
        i.textContent=resault;
      }

      if(discount<0){
          clearInterval(counter);
          document.querySelector(".countdown").textContent="تمام";

          let items2=document.querySelectorAll(".countdown");
          for(let i of items2){
            i.textContent="تمام";
          }
      }
  }
}



    <?php if($show_countainer=="yes"):?>

      <?php if($countainer_daily=="yes"):?>
        countDaily();

      <?php else:?>

        let newDatee="<?php echo $due_date;?>";
        newDatee=newDatee.split(" ");
        let newYear=newDatee[0].split("-")[0];
        let newMonth=newDatee[0].split("-")[1];
        let newDay=newDatee[0].split("-")[2];
        let newHoure=newDatee[1].split(":")[0];
        let newMinute=newDatee[1].split(":")[1];

        countWithDate(newYear,newMonth,newDay,newHoure,newMinute,0)


      <?php endif;?>
    <?php endif;?>

  </script>

    <style>
      .product-box-all .see-all:hover{
        color:<?php echo $background ;?>;
      }
      <?php if($image!=null):?>
        .product-box-all .off-icon{
          background:url(<?php echo $image;?>) no-repeat center top 30px transparent !important;
        }
      <?php endif;?>

      <?php if($image2!=null):?>
        @media screen and (max-width:500px){
          .product-box-all{
            background:url(<?php echo $image2;?>) no-repeat top center <?php echo $background;?> !important;
          }
        }
      <?php endif;?>

      @media screen and (max-width:500px){
			.product-box-all{
				background-color:<?php echo $background;?> !important;
			}
		}

    </style>

    <?php
        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['categoryid'],)),'posts_per_page' => '10'
        ));

        if ( $the_query->have_posts() ) {
          echo "<div class='product-box-all' style='background:$background'>";
            echo "<div class='off-icon'>";

            ?>


            <?php 

            echo "<a href='$category_link' class='see-all'>";

            echo _e('دیدن همه','shapino');
            echo '</a>';

            echo "</div>";
            echo '<div class="owl-carousel2 owl-theme product-box-off">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php echo mt_show_sale_percentage_loop();?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                  <span class="price-regular"><?php echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <span class="price-onsale"><?php echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان</span>
    
                                <?php else: ?>
                                    <?php if(get_post_meta(get_the_ID(),'_regular_price',true)!=""):?>
                                      <span class="price-regular-regular"><?php echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                    <?php else:?>
                                      <span class="price-regular-regular">ناموجود</span>
                                    <?php endif;?>
                                <?php endif; ?>



                                <?php if($show_countainer=="yes"):?>
                                  <div class="countdown-box">
                                    <p class="countdown" ></p>
                                    <i class="far fa-clock"></i>
                                  </div>
                                <?php endif;?>  


                                <!-- <?php // $_product = wc_get_product( get_the_id() );?>
                                <span class="price-home"><?php // echo number_format($_product->get_price());?> تومان</span>
                                  -->


                </div>

            <?php 
            }
            echo '</div>';
              echo "<div class='clear'>";
              echo "</div>";
            echo '</div>';

            echo "<div class='clear'>";
            echo "</div>";
        }
      
    
  }

	protected function _content_template() {}

}