<?php
class Elementor_carusel_Widget extends \Elementor\Widget_Base {

	public function get_name() {
    return 'caruselwidget';
  }

	public function get_title() {
    return __('اسلایدر محصول','shapino');
  }

	public function get_icon() {
    return 'fas fa-sliders-h';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'اسلایدر محصول', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : محصولات الکترونیکی', 'shapino' ),
  ]
);
$this->add_control(
  'categoryid',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 44', 'shapino' ),
  ]
);
$this->add_control(
  'number',
  [
    'label' => __( 'چند محصول نمایش داده شود؟', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 10', 'shapino' ),
  ]
);

$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();
    $category_link = get_category_link( $settings['categoryid']);
    $number=$settings['number'];
    echo '<h3 class="box-title">';
    echo $settings['title'];
    echo '</h3>';
    echo "<a href='$category_link' class='see-all' id='see-all'>";
    echo _e('دیدن همه','shapino');
    echo '</a>';
        
        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['categoryid'],)),'posts_per_page' => $settings['number']
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
    
  }

	protected function _content_template() {}

}