<?php
class Elementor_category_banner extends \Elementor\Widget_Base {

	public function get_name() {
    return 'categoryBanner';
  }

	public function get_title() {
    return __('بنر سفارشی','shapino');
  }

	public function get_icon() {
    return 'far fa-image';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'بنر سفارشی', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : محصولات الکترونیکی', 'shapino' ),
  ]
);
$this->add_control(
  'buttontext',
  [
    'label' => __( 'متن دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : مشاهده', 'shapino' ),
  ]
);
$this->add_control(
  'buttonlink',
  [
    'label' => __( 'لینک دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : http://google.com', 'shapino' ),
  ]
);
$this->add_control(
  'image',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
    'description' => __("سایز تصویر باید 250 * 257 باشد",'shapino'),
  ]
);
$this->add_control(
  'colorBack',
  [
    'label' => __( 'رنگ پس زمینه 1', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);
$this->add_control(
  'colorBack2',
  [
    'label' => __( 'رنگ پس زمینه 2', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();
    $buttonlink=$settings['buttonlink'];
    $buttontext=$settings['buttontext'];
    $title=$settings['title'];
    $back=$settings['colorBack'];
    $back2=$settings['colorBack2'];
    $img=$settings['image']['url'];

    echo "<div class='category-banner' style='background-image:linear-gradient(to left , $back , $back2);'>";
    echo  "<a class='category-banner-title' href='$buttonlink'>$title</a>";
    echo  "<a class='category-banner-button' href='$buttonlink'>$buttontext</a>";
    echo  '<img class="category-banner-img" src="';
    echo $img;
    echo '"/>';
    echo '</div>';

    
  }

	protected function _content_template() {}

}