<?php
class Elementor_category_banner_2 extends \Elementor\Widget_Base {

	public function get_name() {
    return 'categorybanner2';
  }

	public function get_title() {
    return __('بنر دسته بندی ها - طرح 2','shapino');
  }

	public function get_icon() {
    return 'far fa-image';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section1',
  [
    'label' => __( 'آیتم 1', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);

$this->add_control(
  'title1',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image1',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id1',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);


$this->end_controls_section();



$this->start_controls_section(
  'content_section2',
  [
    'label' => __( 'آیتم 2', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);


$this->add_control(
  'title2',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image2',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id2',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);


$this->end_controls_section();


$this->start_controls_section(
  'content_section3',
  [
    'label' => __( 'آیتم 3', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);


$this->add_control(
  'title3',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image3',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id3',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);


$this->end_controls_section();



$this->start_controls_section(
  'content_section4',
  [
    'label' => __( 'آیتم 4', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);


$this->add_control(
  'title4',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image4',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id4',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);


$this->end_controls_section();



$this->start_controls_section(
  'content_section5',
  [
    'label' => __( 'آیتم 5', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);


$this->add_control(
  'title5',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image5',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id5',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);

$this->end_controls_section();




$this->start_controls_section(
  'content_section6',
  [
    'label' => __( 'آیتم 6', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);

$this->add_control(
  'title6',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);
$this->add_control(
  'image6',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);
$this->add_control(
  'id6',
  [
    'label' => __( 'آیدی دسته بندی محصول', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 22', 'shapino' ),
  ]
);

$this->end_controls_section();




}









	protected function render() {
    $settings = $this->get_settings_for_display();


    if (is_admin())
    {
      // solves the width issue
      // The javascript called after elementor scripts are fully loaded.
      if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
          return;
      }
      ?>
      		<script>	
            $('.category-banner-2').owlCarousel({
                nav:false,
                rtl:true,
                loop:false,
                margin:0,
                dots:false,
                responsive:{
                    0:{
                        items:2
                    },
                
                    600:{
                        items:2
                    },
                    1000:{
                        items:6
                    }
                }
            });
          </script>
      <?php
    }




    $image1=$settings['image1']['url'];
    $image2=$settings['image2']['url'];
    $image3=$settings['image3']['url'];
    $image4=$settings['image4']['url'];
    $image5=$settings['image5']['url'];
    $image6=$settings['image6']['url'];

    $id1=$settings['id1'];
    $id2=$settings['id2'];
    $id3=$settings['id3'];
    $id4=$settings['id4'];
    $id5=$settings['id5'];
    $id6=$settings['id6'];

    $term1 = get_term( $id1, 'product_cat' ); 
    $term2 = get_term( $id2, 'product_cat' ); 
    $term3 = get_term( $id3, 'product_cat' ); 
    $term4 = get_term( $id4, 'product_cat' ); 
    $term5 = get_term( $id5, 'product_cat' ); 
    $term6 = get_term( $id6, 'product_cat' ); 


    $link1 = get_category_link( $id1 );
    $link2 = get_category_link( $id2 );
    $link3 = get_category_link( $id3 );
    $link4 = get_category_link( $id4 );
    $link5 = get_category_link( $id5 );
    $link6 = get_category_link( $id6);

    $title1=$settings['title1'];
    $title2=$settings['title2'];
    $title3=$settings['title3'];
    $title4=$settings['title4'];
    $title5=$settings['title5'];
    $title6=$settings['title6'];

    echo "<div class='category-banner-2 owl-theme'>";

      echo "<a href='$link1' class='category-banner2-item'>";
        echo "<img src='";
        echo $image1;
        echo "'/>";

        echo "<span>";
        echo $title1;
        echo "</span>";

        echo "<p>";
        echo $term1->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";



      echo "<a href='$link2' class='category-banner2-item'>";
        echo "<img src='";
        echo $image2;
        echo "'/>";

        echo "<span>";
        echo $title2;
        echo "</span>";

        echo "<p>";
        echo $term2->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";



      echo "<a href='$link3' class='category-banner2-item'>";
        echo "<img src='";
        echo $image3;
        echo "'/>";

        echo "<span>";
        echo $title3;
        echo "</span>";

        echo "<p>";
        echo $term3->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";


      echo "<a href='$link4' class='category-banner2-item'>";

        echo "<img src='";
        echo $image4;
        echo "'/>";

        echo "<span>";
        echo $title4;
        echo "</span>";

        echo "<p>";
        echo $term4->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";


      echo "<a href='$link5' class='category-banner2-item'>";

        echo "<img src='";
        echo $image5;
        echo "'/>";

        echo "<span>";
        echo $title5;
        echo "</span>";

        echo "<p>";
        echo $term5->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";


      echo "<a href='$link6' class='category-banner2-item'>";

        echo "<img src='";
        echo $image6;
        echo "'/>";

        echo "<span>";
        echo $title6;
        echo "</span>";

        echo "<p>";
        echo $term6->count;
        echo _e(' محصول','shapino');
        echo "</p>";

      echo "</a>";

    echo "</div>";
    
  }

	protected function _content_template() {}

}