<?php
class Elementor_category_banner_3 extends \Elementor\Widget_Base {

	public function get_name() {
    return 'categorybanner3';
  }

	public function get_title() {
    return __('بنر تمام صفحه','shapino');
  }

	public function get_icon() {
    return 'far fa-image';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section1',
  [
    'label' => __( 'بنر تمام صفحه', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);

$this->add_control(
  'image',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : کیف و کفش', 'shapino' ),
  ]
);

$this->add_control(
  'titlecolor',
  [
    'label' => __( 'رنگ عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'description',
  [
    'label' => __( 'توضیحات', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);

$this->add_control(
  'descriptioncolor',
  [
    'label' => __( 'رنگ توضیحات', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'buttontext',
  [
    'label' => __( 'متن دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);
$this->add_control(
  'buttonlink',
  [
    'label' => __( 'لینک دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);

$this->add_control(
  'buttoncolor',
  [
    'label' => __( 'رنگ پس زمینه دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);
$this->add_control(
  'buttoncolortext',
  [
    'label' => __( 'رنگ متن دکمه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'backgroundcolor',
  [
    'label' => __( 'رنگ پس زمینه بنر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->end_controls_section();

}

	protected function render() {
    $settings = $this->get_settings_for_display();
    $image=$settings['image']['url'];
    $title=$settings['title'];
    $titlecolor=$settings['titlecolor'];
    $description=$settings['description'];
    $descriptioncolor=$settings['descriptioncolor'];
    $buttonlink=$settings['buttonlink'];
    $buttontext=$settings['buttontext'];
    $buttoncolor=$settings['buttoncolor'];
    $buttoncolortext=$settings['buttoncolortext'];
    $backgroundcolor=$settings['backgroundcolor'];

    ?>



    <div class="banner-100" style="background-color:<?php echo $backgroundcolor;?>;"> 
      <div class="banner-100-image">
        <img src="<?php echo $image; ?>">
      </div>

      <div class="banner-100-description">
        <span style="color:<?php echo $titlecolor;?>;"><?php echo $title; ?></span>
        <p style="color:<?php echo $descriptioncolor;?>;"><?php echo $description; ?></p>
        <a target="_blank" onmouseover="this.style='color:<?php echo $buttoncolor;?>;border : 2px solid <?php echo $buttoncolor;?>;';" onmouseout="this.style=' transition-duration:0.3s ; color:<?php echo $buttoncolortext; ?> ;background-color:<?php echo $buttoncolor; ?>;border: 2px solid <?php echo $buttoncolor; ?>;'" style="color:<?php echo $buttoncolortext; ?> ;background-color:<?php echo $buttoncolor;?>; border : 2px solid <?php echo $buttoncolor;?>;" href="<?php echo $buttonlink; ?>"><?php echo $buttontext; ?></a>
      </div>
      <div class="clear"></div>
    </div>



    <?php
    
    
  }

	protected function _content_template() {}

}