<?php
class Elementor_category_title_carousel extends \Elementor\Widget_Base {

	public function get_name() {
    return 'categorytitlecarousel';
  }

	public function get_title() {
    return __('دسته بندی محصولات','shapino');
  }

	public function get_icon() {
    return 'fa-solid fa-tags';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

protected function _register_controls() {



  $this->start_controls_section('content_section0',
  [
    'label' => __( 'رنگ', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

  );


$this->add_control(
  'colorTab',
  [
    'label' => __( 'رنگ متن تب ها ', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'colorBack',
  [
    'label' => __( 'رنگ پس زمینه تب فعال', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);



$this->add_control(
  'color',
  [
    'label' => __( 'رنگ متن تب فعال ', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'seeAll',
  [
    'label' => __( 'رنگ متن مشاهده همه ', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->add_control(
  'seeAllBack',
  [
    'label' => __( 'رنگ پس زمینه مشاهده همه ', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);


$this->end_controls_section();


  

$this->start_controls_section('content_section1',
  [
    'label' => __( 'آیتم 1', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

  );



$this->add_control(
  'title1',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'گوشی موبایل', 'shapino' ),
  ]
);

$this->add_control(
  'id1',
  [
    'label' => __( 'آیدی دسته بندی', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 21', 'shapino' ),
  ]
);

$this->add_control(
  'image1',
  [
    'label' => __( 'آیکن', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,

  ]
);



$this->end_controls_section();






  
$this->start_controls_section(
  'content_section2',
  [
    'label' => __( 'آیتم 2', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
  
  );
  
  
  
  $this->add_control(
    'title2',
    [
      'label' => __( 'عنوان', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'گوشی موبایل', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'id2',
    [
      'label' => __( 'آیدی دسته بندی', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'مثلا : 21', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'image2',
    [
      'label' => __( 'آیکن', 'shapino' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
  
    ]
  );
  
  
  
  $this->end_controls_section();

  
  
$this->start_controls_section(
  'content_section3',
  [
    'label' => __( 'آیتم 3', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
  
  );
  
  
  
  $this->add_control(
    'title3',
    [
      'label' => __( 'عنوان', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'گوشی موبایل', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'id3',
    [
      'label' => __( 'آیدی دسته بندی', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'مثلا : 21', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'image3',
    [
      'label' => __( 'آیکن', 'shapino' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
  
    ]
  );
  
  
  
  $this->end_controls_section();

  
  
$this->start_controls_section(
  'content_section4',
  [
    'label' => __( 'آیتم 4', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
  
  );
  
  
  
  $this->add_control(
    'title4',
    [
      'label' => __( 'عنوان', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'گوشی موبایل', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'id4',
    [
      'label' => __( 'آیدی دسته بندی', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'مثلا : 21', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'image4',
    [
      'label' => __( 'آیکن', 'shapino' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
  
    ]
  );
  
  
  
  $this->end_controls_section();

  
  
$this->start_controls_section(
  'content_section5',
  [
    'label' => __( 'آیتم 5', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
  
  );
  
  
  
  $this->add_control(
    'title5',
    [
      'label' => __( 'عنوان', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'گوشی موبایل', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'id5',
    [
      'label' => __( 'آیدی دسته بندی', 'shapino' ),
      'type' => \Elementor\Controls_Manager::TEXT,
      'input_type' => 'text',
      'placeholder' => __( 'مثلا : 21', 'shapino' ),
    ]
  );
  
  $this->add_control(
    'image5',
    [
      'label' => __( 'آیکن', 'shapino' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
  
    ]
  );
  
  
  
  $this->end_controls_section();
  

  
$this->start_controls_section(
    'content_section6',
    [
      'label' => __( 'آیتم 6', 'shapino' ),
      'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]
    
    );
    
    
    
    $this->add_control(
      'title6',
      [
        'label' => __( 'عنوان', 'shapino' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'input_type' => 'text',
        'placeholder' => __( 'گوشی موبایل', 'shapino' ),
      ]
    );
    
    $this->add_control(
      'id6',
      [
        'label' => __( 'آیدی دسته بندی', 'shapino' ),
        'type' => \Elementor\Controls_Manager::TEXT,
        'input_type' => 'text',
        'placeholder' => __( 'مثلا : 21', 'shapino' ),
      ]
    );
    
    $this->add_control(
      'image6',
      [
        'label' => __( 'آیکن', 'shapino' ),
        'type' => \Elementor\Controls_Manager::MEDIA,
    
      ]
    );
    
    
    
    $this->end_controls_section();
    


}

	protected function render() {
    $settings = $this->get_settings_for_display();

    if (is_admin())
    {
      // solves the width issue
      // The javascript called after elementor scripts are fully loaded.
      if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
          return;
      }
      ?>
      		<script>	
            $('.brands-carousel').owlCarousel({
                nav:true,
                rtl:true,
                loop:true,
                margin:0,
                dots:false,
                responsive:{
                    0:{
                        items:2
                    },
                
                    600:{
                        items:4
                    },
                    1000:{
                        items:6
                    }
                }
            });
          </script>
      <?php
    }


    $image1=$settings['image1']['url'];
    $image2=$settings['image2']['url'];
    $image3=$settings['image3']['url'];
    $image4=$settings['image4']['url'];
    $image5=$settings['image5']['url'];
    $image6=$settings['image6']['url'];


    $title1=$settings['title1'];
    $title2=$settings['title2'];
    $title3=$settings['title3'];
    $title4=$settings['title4'];
    $title5=$settings['title5'];
    $title6=$settings['title6'];

    $id1=$settings['id1'];
    $id2=$settings['id2'];
    $id3=$settings['id3'];
    $id4=$settings['id4'];
    $id5=$settings['id5'];
    $id6=$settings['id6'];

    $link1 = get_category_link( $id1);
    $link2 = get_category_link( $id2);
    $link3 = get_category_link( $id3);
    $link4 = get_category_link( $id4);
    $link5 = get_category_link( $id5);
    $link6 = get_category_link( $id6);

    ?>

    <style>

    .font-icon-category-title-bg{
        transition-duration: 0.3s;
        background-color: <?php echo $settings["colorBack"];?> !important;
        color: <?php echo $settings["color"];?> !important;
    }

    .category-title-carousel-list li .font-icon-category-title{
      color: <?php echo $settings["colorTab"];?>;
    }
    .see-all-category-title a{
      color: <?php echo $settings["seeAll"];?>;
      background-color: <?php echo $settings["seeAllBack"];?>;
    }
    </style>



    <ul class="category-title-carousel-list">
      <div class="see-all-category-title">

        <a href="<?php echo $link1;?>">
          <i class="fas fa-angle-right"></i>
          <i class="fas fa-angle-right"></i>
          مشاهده همه محصولات
        </a>

      </div>

      <?php if($title1!=null):?>
        <li> <span class="font-icon-category-title font-icon-category-title-bg" index-item='1' hreff='<?php echo $link1;?>'><img src="<?php echo $image1;?>"> <?php echo $title1;?></span>

        </li>
      <?php endif;?>

      <?php if($title2!=null):?>
        <li> <span class="font-icon-category-title" index-item='2' hreff='<?php echo $link2;?>'><img src="<?php echo $image2;?>"> <?php echo $title2;?></span>

        </li>
      <?php endif;?>

      <?php if($title3!=null):?>
        <li> <span class="font-icon-category-title" index-item='3' hreff='<?php echo $link3;?>'><img src="<?php echo $image3;?>"> <?php echo $title3;?></span>

        </li>
      <?php endif;?>

      <?php if($title4!=null):?>
        <li> <span class="font-icon-category-title" index-item='4' hreff='<?php echo $link4;?>'><img src="<?php echo $image4;?>"> <?php echo $title4;?></span>

        </li>
      <?php endif;?>

      <?php if($title5!=null):?>
        <li> <span class="font-icon-category-title" index-item='5' hreff='<?php echo $link5;?>'><img src="<?php echo $image5;?>"> <?php echo $title5;?></span>

        </li>
      <?php endif;?>

      <?php if($title6!=null):?>
        <li> <span class="font-icon-category-title" index-item='6' hreff='<?php echo $link6;?>'><img src="<?php echo $image6;?>"> <?php echo $title6;?></span>

        </li>
      <?php endif;?>

    </ul>

    <ul class="category-title-carousel">

      <?php if($title1!=null):?>
        <li>

        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id1'],)),'posts_per_page' => "10"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="1" style="display:block">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>

        </li>
      <?php endif;?>
    

      <?php if($title2!=null):?>
        <li> 
        
        

        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id2'],)),'posts_per_page' => "4"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="2">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>


        </li>
      <?php endif;?>

      <?php if($title3!=null):?>
        <li> 
        

        
        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id3'],)),'posts_per_page' => "4"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="3">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>

        
        </li>
      <?php endif;?>

      <?php if($title4!=null):?>
        <li> 
        
        

        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id4'],)),'posts_per_page' => "4"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="4">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>


        </li>
      <?php endif;?>

      <?php if($title5!=null):?>
        <li> 
        
        
        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id5'],)),'posts_per_page' => "4"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="5">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>


        </li>
      <?php endif;?>

      <?php if($title6!=null):?>
        <li> 
        
        
        <?php 

        $the_query = new WP_Query(array(
            'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['id6'],)),'posts_per_page' => "4"
        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel owl-theme product-box" index-item="6">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="product-item">
                                <?php if ( in_array( 'yith-woocommerce-wishlist/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode('[yith_wcwl_add_to_wishlist]');
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-compare/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_compare_button]' );
                                }?>
                                <?php if ( in_array( 'yith-woocommerce-quick-view/init.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                    echo do_shortcode( '[yith_quick_view]' );
                                }?>

                                <div class="product-item-add-to-cart"><a href="<?php the_permalink();?>" ><?php _e('مشاهده محصول','shapino');?></a></div>
                                <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <div class="off-product-box"><?php _e('تخفیف ویژه','shapino');?></div>
                                <?php endif; ?>
                                <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
                                <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
                                <!--
                                <?php //if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_sale_price',true));?> تومان با تخفیف</span>
                                    <?php //else: ?>
                                    <span class="price-home"><?php // echo number_format(get_post_meta(get_the_ID(),'_regular_price',true));?> تومان</span>
                                  <?php //endif; ?>
                                  -->
                                <?php $_product = wc_get_product( get_the_id() );?>
                                <?php if($_product->get_price()!=""):?>
                                  <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>
                                <?php else :?>   
                                  <span class="price-home">ناموجود</span>
                                <?php endif ;?>   

                </div>

            <?php 
            }
            echo '</div>';
        }
      
        ?>
        
        </li>
      <?php endif;?>

    </ul>



    <div class="see-all-category-title see-all-category-title-bottom">

      <a href="<?php echo $link1;?>">
        <i class="fas fa-angle-right"></i>
        <i class="fas fa-angle-right"></i>
        مشاهده همه محصولات
      </a>

    </div>



    <?php



  }

	protected function _content_template() {}

}