<?php
class Elementor_lastPost_Widget extends \Elementor\Widget_Base {

	public function get_name() {
    return 'lastpostwidget';
  }

	public function get_title() {
    return __('اسلایدر آخرین مطالب سایت','shapino');
  }

	public function get_icon() {
    return 'fas fa-newspaper';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'آخرین مطالب سایت', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);
$this->add_control(
  'postnumber',
  [
    'label' => __( ' چند پست نمایش داده شود', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 10', 'shapino' ),
  ]
);
$this->add_control(
  'link',
  [
    'label' => __( 'لینکه دکمه دیدن همه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : http://yourblog.com', 'shapino' ),
  ]
);
/*
$this->add_control(
  'catId',
  [
    'label' => __( 'آیدی دسته بندی نوشته', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);
*/

$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();

    if (is_admin())
    {
      // solves the width issue
      // The javascript called after elementor scripts are fully loaded.
      if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
          return;
      }
      ?>
      		<script>	
            $('.owl-carousel').owlCarousel({
                nav:true,
                rtl:true,
                loop:true,
                margin:0,
                dots:false,
                responsive:{
                    0:{
                        items:2
                    },
                    600:{
                        items:3
                    },
                    1000:{
                        items:4
                    }
                }
            });
          </script>
      <?php
    }



    $link = $settings['link'];
    echo '<h3 class="lastpost-title">';
    echo $settings['title'];
    echo '</h3>';

        
        $the_query = new WP_Query(array(
            'post_type'=>'post',
            'posts_per_page' => $settings['postnumber'],

            //'post_type'=>'post','tax_query'=>array(array('taxonomy'=>'category','field'=>'tag_ID','terms'=>$settings["catId"],)),'posts_per_page' => $settings['postnumber']


        ));

        if ( $the_query->have_posts() ) {
            echo '<div class="owl-carousel last-post-carusel">';
            while ( $the_query->have_posts() ){
                $the_query->the_post();
                ?>

                <div class="index-article-home index-article ">
                    <div class="article-date">
                      <?php the_time( 'd F Y' ); ?>
                    </div>
                    <?php if ( has_post_thumbnail() ) : ?>
                        <div class="index-article-img"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a></div>
                    <?php else:?>
                        <div class="index-article-img"><a href="<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/no-thumbnail.png" ></a></div>        
                    <?php endif;?>
                    <a href="<?php the_permalink(); ?>"><span class="index-article-title"><?php echo wp_trim_words(get_the_title(),10,' ...'); ?></span></a>
                    <div class="read-more"><a href="<?php the_permalink(); ?>"><?php _e('مطالعه مطلب','shapino');?></a></div>
                </div>

            <?php 
            }
            echo '</div>';
        }
      
    echo "<a href='$link' class='see-all-lastpost'>";
    echo _e("دیدن همه",'shapino');
    echo '</a>';
    
  }

	protected function _content_template() {}

}