<?php
class Elementor_mailchimp extends \Elementor\Widget_Base {

	public function get_name() {
    return 'mailchimp';
  }

	public function get_title() {
    return __('خبرنامه','shapino');
  }

	public function get_icon() {
    return 'far fa-envelope-open';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section1',
  [
    'label' => __( 'باکس خبرنامه', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);

$this->add_control(
  'description',
  [
    'label' => __( 'توضیحات کوتاه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);


$this->add_control(
  'color',
  [
    'label' => __('رنگ پس زمینه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);


$this->end_controls_section();





}









	protected function render() {

    $settings = $this->get_settings_for_display();

    $color=$settings['color'];

    $description=$settings['description'];

    $title=$settings['title'];






    ?>

    <style>
    .input-mail .mc4wp-form-fields p input[type=submit]{
      color:<?php echo $color;?> !important;
    }
    </style>

    <div class="top-footer-mail-box" style="background-color:<?php echo $color;?>;">
        <div class="site-center">
          <div class="top-footer-mail-box-top-box">
              <div class="mail-icon">
                  <i class="fas fa-envelope-open-text" style="color:<?php echo $color;?>;"></i>
              </div>

              <div class="txt-mail">
                  <span><?php echo $title;?></span>
                  <p><?php echo $description;?></p>
              </div>
            </div>
            <div class="input-mail">
                <?php 
                  if( in_array( 'mailchimp-for-wp/mailchimp-for-wp.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

                echo do_shortcode("[mc4wp_form]"); 
                    }
                ?>
            </div>
        </div>
    </div>

    <?php
    
  }

	protected function _content_template() {}

}