<?php
class Elementor_questions extends \Elementor\Widget_Base {

	public function get_name() {
    return 'questions';
  }

	public function get_title() {
    return __('سوالات متداول','shapino');
  }

	public function get_icon() {
    return 'fa-solid fa-circle-question';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'باکس سوالات متداول', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXTAREA,
    'input_type' => 'text',
    'placeholder' => __( '', 'shapino' ),
  ]
);
$this->add_control(
  'text',
  [
    'label' => __( 'توضیحات', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXTAREA,
    'input_type' => 'text',
    'placeholder' => __( '', 'shapino' ),
  ]
);


$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();
    $title=$settings['title'];
    $text=$settings['text'];


    ?>

    <div class="question-box">
      <a>
        <span><?php echo $title;?></span>
        
        <i class="fas fa-angle-right"></i>
      </a>

      <div>
        <?php echo $text;?>
      </div>
    </div>



    <?php


    
  }

	protected function _content_template() {}

}