<?php
class Elementor_suggestion_moment extends \Elementor\Widget_Base {

	public function get_name() {
    return 'suggestion_moment';
  }

	public function get_title() {
    return __('پیشنهاد لحظه ای','shapino');
  }

	public function get_icon() {
    return 'fas fa-lightbulb';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section',
  [
    'label' => __( 'پیشنهاد لحظه ای', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]
);

$this->add_control(
  'title',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);
$this->add_control(
  'categoryid',
  [
    'label' => __( 'آیدی دسته محصولات پیشنهادی', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
    'placeholder' => __( 'مثلا : 44', 'shapino' ),
  ]
);
$this->add_control(
  'color',
  [
    'label' => __( 'رنگ نوار زمان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
);

$this->end_controls_section();
  }

	protected function render() {
    $settings = $this->get_settings_for_display();
    $color=$settings['color'];

    if (is_admin())
    {
      // solves the width issue
      // The javascript called after elementor scripts are fully loaded.
      if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
          return;
      }
      ?>
      		<script>	
              initSlider();

              function initSlider() {
                $(".suggestion-moment").owlCarousel({
                  items: 1,
                  loop: true,
                  autoplay: true,
                  onInitialized: startProgressBar,
                  onTranslate: resetProgressBar,
                  onTranslated: startProgressBar,
                  rtl:true,
                  dots:false,
                });
              }

              function startProgressBar() {
                // apply keyframe animation
                $(".slide-progress").css({
                  width: "100%",
                  transition: "width 5000ms"
                });
              }

              function resetProgressBar() {
                $(".slide-progress").css({
                  width: 0,
                  transition: "width 0s"
                });
              }
          </script>
      <?php
    }

    ?>



    <?php $the_query = new WP_Query(array(
      'post_type'=>'product','tax_query'=>array(array('taxonomy'=>'product_cat','field'=>'tag_ID','terms'=>$settings['categoryid'],)),'posts_per_page' => '100',
    ));
    if ( $the_query->have_posts() ) {

    echo '<div class="container">';
    ?>
    <span class="suggestion-title"><?php echo $settings['title'];?></span>
    <?php
    echo '<div class="owl-demo">';
      ?>
      <div class="slide-progress" style="background:<?php echo $color;?>"></div>
      <?php 
      
      echo '<div class="suggestion-moment owl-theme">';
        while ( $the_query->have_posts() ){
        $the_query->the_post();
        ?>

          <div class="item">
              <?php if(get_post_meta(get_the_ID(),'_sale_price',true) != null):?>
                <div class="off-product-box"><?php echo mt_show_sale_percentage_loop();?></div>
              <?php endif; ?>
              <a href="<?php the_permalink();?>" class="product-image-home"><?php the_post_thumbnail();?></a>     
              <a href="<?php the_permalink();?>"><span class="product-title-home"><?php echo wp_trim_words(get_the_title(),12,' ... ');?></span></a>         
              <?php $_product = wc_get_product( get_the_id() );?>
              <span class="price-home"><?php echo number_format($_product->get_price());?> تومان</span>                        
          </div>


        <?php 
        }
      }
      echo "</div>";

      echo "</div>";
      echo "</div>";
  } 
	protected function _content_template() {}
}
