<?php
class Elementor_feauture_widgets extends \Elementor\Widget_Base {

	public function get_name() {
    return 'feauturewidgets';
  }

	public function get_title() {
    return __('ویجت امکانات','shapino');
  }

	public function get_icon() {
    return 'far fa-image';
  }

	public function get_categories() {
    return [ 'theme-category' ];
  }

	protected function _register_controls() {
    $this->start_controls_section(
  'content_section1',
  [
    'label' => __( 'ویجت امکانات', 'shapino' ),
    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
  ]

);

$this->add_control(
  'title1',
  [
    'label' => __( 'عنوان', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);

$this->add_control(
  'id1',
  [
    'label' => __( 'توضیحات کوتاه', 'shapino' ),
    'type' => \Elementor\Controls_Manager::TEXT,
    'input_type' => 'text',
  ]
);


$this->add_control(
  'image1',
  [
    'label' => __( 'تصویر', 'shapino' ),
    'type' => \Elementor\Controls_Manager::MEDIA,
  ]
);


$this->end_controls_section();





}









	protected function render() {
    $settings = $this->get_settings_for_display();

    $image1=$settings['image1']['url'];

    $id1=$settings['id1'];

    $title1=$settings['title1'];

    ?>

      <div class="feauture-widgets">
        <img src="<?php echo $image1;?>" alt="">
        <div>
          <h5><?php echo $title1;?></h5>
          <span><?php echo $id1;?></span>
        </div>
        <div class="clear"></div>
      </div>

    <?php
    
  }

	protected function _content_template() {}

}