<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

// number post
$args = array( 'post_type' => 'product', 'post_status' => 'publish', 
'posts_per_page' => -1 );
$products = new WP_Query( $args );
$current_user = wp_get_current_user();
$int = wc_get_customer_order_count($current_user->ID);

?>
<div class="top-dashboard">
	<a href="<?php bloginfo('url');?>/shop">
		<div class="top-dashboard-item number-product-account">
			<i class="fas fa-box"></i>
			<div>
				<p><?php echo $products->found_posts;?> <?php _e('محصول','shapino');?> </p>
				<span><?php _e('در سایت وجود دارد','shapino');?></span>
			</div>
		</div>
	</a>
	<a href="<?php bloginfo('url');?>/my-account/orders"><div class="top-dashboard-item number-buyed">
		<i class="fas fa-box-open"></i>
		<div>
			<p><?php echo $int;?> <?php _e('سفارش','shapino');?> </p>
			<span><?php _e('ثبت کرده اید','shapino');?></span>
		</div>
	</div></a>

	<a href="<?php bloginfo('url');?>/cart"><div class="top-dashboard-item number-entezar-pardakht">
		<i class="fas fa-cart-plus"></i>
		<div>
			<p><?php echo WC()->cart->get_cart_contents_count();?> <?php _e('محصول','shapino');?> </p>
			<span><?php _e('در انتظار پرداخت','shapino');?></span>
		</div>
	</div></a>

	<div class="top-dashboard-item date-register">
		<i class="fas fa-user-clock"></i>
		<div>
			<p><?php echo human_time_diff( strtotime(get_userdata(get_current_user_id( ))->user_registered) ); ?> </p>
			<span><?php _e('همراه ما هستید','shapino');?></span>
		</div>
	</div>
	<div class="clear"></div>
</div>
<p>
	<?php
	printf(
		/* translators: 1: user display name 2: logout url */
		wp_kses( __( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ), $allowed_html ),
		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
		esc_url( wc_logout_url() )
	);
	?>
</p>

<p>
	<?php
	/* translators: 1: Orders URL 2: Address URL 3: Account URL. */
	$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">billing address</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce' );
	if ( wc_shipping_enabled() ) {
		/* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
		$dashboard_desc = __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'woocommerce' );
	}
	printf(
		wp_kses( $dashboard_desc, $allowed_html ),
		esc_url( wc_get_endpoint_url( 'orders' ) ),
		esc_url( wc_get_endpoint_url( 'edit-address' ) ),
		esc_url( wc_get_endpoint_url( 'edit-account' ) )
	);
	?>
</p>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
