<?php
/**
 * Single Product Price
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/price.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

?>
<span class="price-text">قیمت : </span>
<p class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>"><?php echo $product->get_price_html(); ?></p>


<?php if(get_theme_mod("float-product-info")==1):?>
<div class="product-info-fixed">
            <ul>
				<ul class="fixed-info-product">
					<li><span class="title-fixed"><?php echo wp_trim_words( get_the_title(), 5, ' ... ' );?></span></li>
					<li><span class="price-fixed"><?php echo $product->get_price_html(); ?></span></li>

					<li>
						<?php
							global $product;

							echo apply_filters( 'woocommerce_loop_add_to_cart_link',
								sprintf( '<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="button %s product_type_%s">%s</a>',
									esc_url( $product->add_to_cart_url() ),
									esc_attr( $product->get_id() ),
									esc_attr( $product->get_sku() ),
									$product->is_purchasable() ? 'add_to_cart_button' : '',
									esc_attr( $product->get_type() ),
									esc_html( $product->add_to_cart_text() )
								),
							$product );

						?>

					</li>
				</ul>
				<ul class="show-buttons-fixed">
					<li><a href="#product_title" id="show-descriptions"><?php _e('توضیحات','shapino');?></a></li>
					<li><a href="#tab-additional_information" id="show-information"><?php _e('مشخصات','shapino');?></a></li>		
					<li><a href="#comments" id="show-comments"><?php _e('نظرات','shapino');?></a></li>
				</ul>
            </ul>
</div>  
<?php endif;?>